/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.models.Objects;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Objects.Commit", generator="Immutables")
@Immutable
public final class ImmutableCommit
implements Objects.Commit {
    private final String id;
    private final String author;
    private final LocalDateTime dateTime;
    private final String message;
    @Nullable
    private final String parent;
    @Nullable
    private final String merge;
    private final String tree;

    private ImmutableCommit(String id, String author, LocalDateTime dateTime, String message, @Nullable String parent, @Nullable String merge, String tree) {
        this.id = id;
        this.author = author;
        this.dateTime = dateTime;
        this.message = message;
        this.parent = parent;
        this.merge = merge;
        this.tree = tree;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Optional<String> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public Optional<String> getMerge() {
        return Optional.ofNullable(this.merge);
    }

    @Override
    public String getTree() {
        return this.tree;
    }

    public final ImmutableCommit withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableCommit(newValue, this.author, this.dateTime, this.message, this.parent, this.merge, this.tree);
    }

    public final ImmutableCommit withAuthor(String value) {
        String newValue = Objects.requireNonNull(value, "author");
        if (this.author.equals(newValue)) {
            return this;
        }
        return new ImmutableCommit(this.id, newValue, this.dateTime, this.message, this.parent, this.merge, this.tree);
    }

    public final ImmutableCommit withDateTime(LocalDateTime value) {
        if (this.dateTime == value) {
            return this;
        }
        LocalDateTime newValue = Objects.requireNonNull(value, "dateTime");
        return new ImmutableCommit(this.id, this.author, newValue, this.message, this.parent, this.merge, this.tree);
    }

    public final ImmutableCommit withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableCommit(this.id, this.author, this.dateTime, newValue, this.parent, this.merge, this.tree);
    }

    public final ImmutableCommit withParent(String value) {
        String newValue = Objects.requireNonNull(value, "parent");
        if (Objects.equals(this.parent, newValue)) {
            return this;
        }
        return new ImmutableCommit(this.id, this.author, this.dateTime, this.message, newValue, this.merge, this.tree);
    }

    public final ImmutableCommit withParent(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.parent, value)) {
            return this;
        }
        return new ImmutableCommit(this.id, this.author, this.dateTime, this.message, value, this.merge, this.tree);
    }

    public final ImmutableCommit withMerge(String value) {
        String newValue = Objects.requireNonNull(value, "merge");
        if (Objects.equals(this.merge, newValue)) {
            return this;
        }
        return new ImmutableCommit(this.id, this.author, this.dateTime, this.message, this.parent, newValue, this.tree);
    }

    public final ImmutableCommit withMerge(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.merge, value)) {
            return this;
        }
        return new ImmutableCommit(this.id, this.author, this.dateTime, this.message, this.parent, value, this.tree);
    }

    public final ImmutableCommit withTree(String value) {
        String newValue = Objects.requireNonNull(value, "tree");
        if (this.tree.equals(newValue)) {
            return this;
        }
        return new ImmutableCommit(this.id, this.author, this.dateTime, this.message, this.parent, this.merge, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommit && this.equalTo((ImmutableCommit)another);
    }

    private boolean equalTo(ImmutableCommit another) {
        return this.id.equals(another.id) && this.author.equals(another.author) && this.dateTime.equals(another.dateTime) && this.message.equals(another.message) && Objects.equals(this.parent, another.parent) && Objects.equals(this.merge, another.merge) && this.tree.equals(another.tree);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.author.hashCode();
        h += (h << 5) + this.dateTime.hashCode();
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.parent);
        h += (h << 5) + Objects.hashCode(this.merge);
        h += (h << 5) + this.tree.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Commit").omitNullValues().add("id", (Object)this.id).add("author", (Object)this.author).add("dateTime", (Object)this.dateTime).add("message", (Object)this.message).add("parent", (Object)this.parent).add("merge", (Object)this.merge).add("tree", (Object)this.tree).toString();
    }

    public static ImmutableCommit copyOf(Objects.Commit instance) {
        if (instance instanceof ImmutableCommit) {
            return (ImmutableCommit)instance;
        }
        return ImmutableCommit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Objects.Commit", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_AUTHOR = 2L;
        private static final long INIT_BIT_DATE_TIME = 4L;
        private static final long INIT_BIT_MESSAGE = 8L;
        private static final long INIT_BIT_TREE = 16L;
        private long initBits = 31L;
        @Nullable
        private String id;
        @Nullable
        private String author;
        @Nullable
        private LocalDateTime dateTime;
        @Nullable
        private String message;
        @Nullable
        private String parent;
        @Nullable
        private String merge;
        @Nullable
        private String tree;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Objects.IsObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Objects.Commit instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Objects.IsObject instance;
            if (object instanceof Objects.IsObject) {
                instance = (Objects.IsObject)object;
                this.id(instance.getId());
            }
            if (object instanceof Objects.Commit) {
                instance = (Objects.Commit)object;
                this.dateTime(instance.getDateTime());
                this.tree(instance.getTree());
                Optional<String> parentOptional = instance.getParent();
                if (parentOptional.isPresent()) {
                    this.parent(parentOptional);
                }
                this.message(instance.getMessage());
                this.author(instance.getAuthor());
                Optional<String> mergeOptional = instance.getMerge();
                if (mergeOptional.isPresent()) {
                    this.merge(mergeOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder author(String author) {
            this.author = Objects.requireNonNull(author, "author");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dateTime(LocalDateTime dateTime) {
            this.dateTime = Objects.requireNonNull(dateTime, "dateTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parent(String parent) {
            this.parent = Objects.requireNonNull(parent, "parent");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parent(Optional<String> parent) {
            this.parent = parent.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder merge(String merge) {
            this.merge = Objects.requireNonNull(merge, "merge");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder merge(Optional<String> merge) {
            this.merge = merge.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tree(String tree) {
            this.tree = Objects.requireNonNull(tree, "tree");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableCommit build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommit(this.id, this.author, this.dateTime, this.message, this.parent, this.merge, this.tree);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("author");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("dateTime");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("tree");
            }
            return "Cannot build Commit, some of required attributes are not set " + attributes;
        }
    }
}

