/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.exceptions;

import io.resys.thena.docdb.api.exceptions.DocDBException;
import io.resys.thena.docdb.api.models.ImmutableMessage;
import io.resys.thena.docdb.api.models.Message;
import java.util.List;

public class RepoException
extends DocDBException {
    private static final long serialVersionUID = 4311634600357697485L;

    public RepoException(String msg) {
        super(msg);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        public Message notRepoWithName(String repoId) {
            return ImmutableMessage.builder().text("Repo with name: '" + repoId + "' does not exist!").build();
        }

        public Message noRepoRef(String repo, String ref) {
            return ImmutableMessage.builder().text("Repo with name: '" + repo + "'," + " has no ref: '" + ref + "'" + "!").build();
        }

        public Message noRepoRef(String repo, String ref, List<String> allRefs) {
            return ImmutableMessage.builder().text("Repo with name: '" + repo + "'," + " has no ref: '" + ref + "'" + " known refs: '" + String.join((CharSequence)",", allRefs) + "'" + "!").build();
        }

        public Message nameNotUnique(String name, String id) {
            return ImmutableMessage.builder().text("Repo with name: '" + name + "' already exists," + " id: '" + id + "'" + "!").build();
        }

        public String updateConflict(String id, String dbRev, String userRev, String name) {
            return "Repo with" + " id: '" + id + "'" + " name: '" + name + "'" + " can't be updated" + " because of revision conflict" + " '" + dbRev + "' (db) != (user) '" + userRev + "'" + "!";
        }
    }
}

