/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.actions;

import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.immutables.value.Value;

public interface ObjectsActions {
    public RepoStateBuilder repoState();

    public RefStateBuilder refState();

    public CommitStateBuilder commitState();

    public BlobStateBuilder blobState();

    @Value.Immutable
    public static interface ObjectsResult<T> {
        @Nullable
        public Repo getRepo();

        @Nullable
        public T getObjects();

        public ObjectsStatus getStatus();

        public List<Message> getMessages();
    }

    public static enum ObjectsStatus {
        OK,
        ERROR;

    }

    @Value.Immutable
    public static interface BlobObjects {
        public Repo getRepo();

        public Objects.Commit getCommit();

        public Objects.Tree getTree();

        public List<Objects.Blob> getBlob();
    }

    @Value.Immutable
    public static interface BlobObject {
        public Repo getRepo();

        public Objects.Commit getCommit();

        public Objects.Tree getTree();

        public Objects.Blob getBlob();
    }

    @Value.Immutable
    public static interface RefObjects {
        public Repo getRepo();

        public Objects.Ref getRef();

        public Objects.Commit getCommit();

        public Objects.Tree getTree();

        public Map<String, Objects.Blob> getBlobs();
    }

    @Value.Immutable
    public static interface CommitObjects {
        public Repo getRepo();

        public Objects.Commit getCommit();

        public Objects.Tree getTree();

        public Map<String, Objects.Blob> getBlobs();
    }

    public static interface RefStateBuilder {
        public RefStateBuilder repo(String var1);

        public RefStateBuilder ref(String var1);

        public RefStateBuilder blobs();

        public RefStateBuilder blobs(boolean var1);

        public Uni<ObjectsResult<RefObjects>> build();
    }

    public static interface CommitStateBuilder {
        public CommitStateBuilder repo(String var1);

        public CommitStateBuilder anyId(String var1);

        public CommitStateBuilder blobs();

        public CommitStateBuilder blobs(boolean var1);

        public Uni<ObjectsResult<CommitObjects>> build();
    }

    public static interface RepoStateBuilder {
        public RepoStateBuilder repo(String var1);

        public Uni<ObjectsResult<Objects>> build();
    }

    public static interface BlobStateBuilder {
        public BlobStateBuilder repo(String var1);

        public BlobStateBuilder anyId(String var1);

        public BlobStateBuilder blobNames(List<String> var1);

        public BlobStateBuilder blobName(String var1);

        public Uni<ObjectsResult<BlobObject>> get();

        public Uni<ObjectsResult<BlobObjects>> list();
    }
}

