/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.actions.TagActions;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Objects;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TagActions.TagResult", generator="Immutables")
@Immutable
public final class ImmutableTagResult
implements TagActions.TagResult {
    @Nullable
    private final Objects.Tag tag;
    private final TagActions.TagStatus status;
    private final ImmutableList<Message> messages;

    private ImmutableTagResult(@Nullable Objects.Tag tag, TagActions.TagStatus status, ImmutableList<Message> messages) {
        this.tag = tag;
        this.status = status;
        this.messages = messages;
    }

    @Override
    @Nullable
    public Objects.Tag getTag() {
        return this.tag;
    }

    @Override
    public TagActions.TagStatus getStatus() {
        return this.status;
    }

    public ImmutableList<Message> getMessages() {
        return this.messages;
    }

    public final ImmutableTagResult withTag(@Nullable Objects.Tag value) {
        if (this.tag == value) {
            return this;
        }
        return new ImmutableTagResult(value, this.status, this.messages);
    }

    public final ImmutableTagResult withStatus(TagActions.TagStatus value) {
        if (this.status == value) {
            return this;
        }
        TagActions.TagStatus newValue = Objects.requireNonNull(value, "status");
        if (this.status.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTagResult(this.tag, newValue, this.messages);
    }

    public final ImmutableTagResult withMessages(Message ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTagResult(this.tag, this.status, (ImmutableList<Message>)newValue);
    }

    public final ImmutableTagResult withMessages(Iterable<? extends Message> elements) {
        if (this.messages == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTagResult(this.tag, this.status, (ImmutableList<Message>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTagResult && this.equalTo((ImmutableTagResult)another);
    }

    private boolean equalTo(ImmutableTagResult another) {
        return Objects.equals(this.tag, another.tag) && this.status.equals((Object)another.status) && this.messages.equals(another.messages);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.tag);
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + this.messages.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TagResult").omitNullValues().add("tag", (Object)this.tag).add("status", (Object)this.status).add("messages", this.messages).toString();
    }

    public static ImmutableTagResult copyOf(TagActions.TagResult instance) {
        if (instance instanceof ImmutableTagResult) {
            return (ImmutableTagResult)instance;
        }
        return ImmutableTagResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TagActions.TagResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STATUS = 1L;
        private long initBits = 1L;
        @Nullable
        private Objects.Tag tag;
        @Nullable
        private TagActions.TagStatus status;
        private ImmutableList.Builder<Message> messages = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TagActions.TagResult instance) {
            Objects.requireNonNull(instance, "instance");
            Objects.Tag tagValue = instance.getTag();
            if (tagValue != null) {
                this.tag(tagValue);
            }
            this.status(instance.getStatus());
            this.addAllMessages(instance.getMessages());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tag(@Nullable Objects.Tag tag) {
            this.tag = tag;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder status(TagActions.TagStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMessages(Message element) {
            this.messages.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMessages(Message ... elements) {
            this.messages.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder messages(Iterable<? extends Message> elements) {
            this.messages = ImmutableList.builder();
            return this.addAllMessages(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMessages(Iterable<? extends Message> elements) {
            this.messages.addAll(elements);
            return this;
        }

        public ImmutableTagResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTagResult(this.tag, this.status, (ImmutableList<Message>)this.messages.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build TagResult, some of required attributes are not set " + attributes;
        }
    }
}

