/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.actions.RepoActions;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Repo;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RepoActions.RepoResult", generator="Immutables")
@Immutable
public final class ImmutableRepoResult
implements RepoActions.RepoResult {
    @Nullable
    private final Repo repo;
    private final RepoActions.RepoStatus status;
    private final ImmutableList<Message> messages;

    private ImmutableRepoResult(@Nullable Repo repo, RepoActions.RepoStatus status, ImmutableList<Message> messages) {
        this.repo = repo;
        this.status = status;
        this.messages = messages;
    }

    @Override
    @Nullable
    public Repo getRepo() {
        return this.repo;
    }

    @Override
    public RepoActions.RepoStatus getStatus() {
        return this.status;
    }

    public ImmutableList<Message> getMessages() {
        return this.messages;
    }

    public final ImmutableRepoResult withRepo(@Nullable Repo value) {
        if (this.repo == value) {
            return this;
        }
        return new ImmutableRepoResult(value, this.status, this.messages);
    }

    public final ImmutableRepoResult withStatus(RepoActions.RepoStatus value) {
        if (this.status == value) {
            return this;
        }
        RepoActions.RepoStatus newValue = Objects.requireNonNull(value, "status");
        if (this.status.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableRepoResult(this.repo, newValue, this.messages);
    }

    public final ImmutableRepoResult withMessages(Message ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRepoResult(this.repo, this.status, (ImmutableList<Message>)newValue);
    }

    public final ImmutableRepoResult withMessages(Iterable<? extends Message> elements) {
        if (this.messages == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRepoResult(this.repo, this.status, (ImmutableList<Message>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepoResult && this.equalTo((ImmutableRepoResult)another);
    }

    private boolean equalTo(ImmutableRepoResult another) {
        return Objects.equals(this.repo, another.repo) && this.status.equals((Object)another.status) && this.messages.equals(another.messages);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repo);
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + this.messages.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RepoResult").omitNullValues().add("repo", (Object)this.repo).add("status", (Object)this.status).add("messages", this.messages).toString();
    }

    public static ImmutableRepoResult copyOf(RepoActions.RepoResult instance) {
        if (instance instanceof ImmutableRepoResult) {
            return (ImmutableRepoResult)instance;
        }
        return ImmutableRepoResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RepoActions.RepoResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STATUS = 1L;
        private long initBits = 1L;
        @Nullable
        private Repo repo;
        @Nullable
        private RepoActions.RepoStatus status;
        private ImmutableList.Builder<Message> messages = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RepoActions.RepoResult instance) {
            Objects.requireNonNull(instance, "instance");
            Repo repoValue = instance.getRepo();
            if (repoValue != null) {
                this.repo(repoValue);
            }
            this.status(instance.getStatus());
            this.addAllMessages(instance.getMessages());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repo(@Nullable Repo repo) {
            this.repo = repo;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder status(RepoActions.RepoStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMessages(Message element) {
            this.messages.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMessages(Message ... elements) {
            this.messages.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder messages(Iterable<? extends Message> elements) {
            this.messages = ImmutableList.builder();
            return this.addAllMessages(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMessages(Iterable<? extends Message> elements) {
            this.messages.addAll(elements);
            return this;
        }

        public ImmutableRepoResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRepoResult(this.repo, this.status, (ImmutableList<Message>)this.messages.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build RepoResult, some of required attributes are not set " + attributes;
        }
    }
}

