/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Repo;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ObjectsActions.ObjectsResult", generator="Immutables")
@Immutable
public final class ImmutableObjectsResult<T>
implements ObjectsActions.ObjectsResult<T> {
    @Nullable
    private final Repo repo;
    @Nullable
    private final T objects;
    private final ObjectsActions.ObjectsStatus status;
    private final ImmutableList<Message> messages;

    private ImmutableObjectsResult(@Nullable Repo repo, @Nullable T objects, ObjectsActions.ObjectsStatus status, ImmutableList<Message> messages) {
        this.repo = repo;
        this.objects = objects;
        this.status = status;
        this.messages = messages;
    }

    @Override
    @Nullable
    public Repo getRepo() {
        return this.repo;
    }

    @Override
    @Nullable
    public T getObjects() {
        return this.objects;
    }

    @Override
    public ObjectsActions.ObjectsStatus getStatus() {
        return this.status;
    }

    public ImmutableList<Message> getMessages() {
        return this.messages;
    }

    public final ImmutableObjectsResult<T> withRepo(@Nullable Repo value) {
        if (this.repo == value) {
            return this;
        }
        return new ImmutableObjectsResult<T>(value, this.objects, this.status, this.messages);
    }

    public final ImmutableObjectsResult<T> withObjects(@Nullable T value) {
        if (this.objects == value) {
            return this;
        }
        return new ImmutableObjectsResult<T>(this.repo, value, this.status, this.messages);
    }

    public final ImmutableObjectsResult<T> withStatus(ObjectsActions.ObjectsStatus value) {
        if (this.status == value) {
            return this;
        }
        ObjectsActions.ObjectsStatus newValue = Objects.requireNonNull(value, "status");
        if (this.status.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableObjectsResult<T>(this.repo, this.objects, newValue, this.messages);
    }

    public final ImmutableObjectsResult<T> withMessages(Message ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableObjectsResult<T>(this.repo, this.objects, this.status, (ImmutableList<Message>)newValue);
    }

    public final ImmutableObjectsResult<T> withMessages(Iterable<? extends Message> elements) {
        if (this.messages == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableObjectsResult<T>(this.repo, this.objects, this.status, (ImmutableList<Message>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableObjectsResult && this.equalTo((ImmutableObjectsResult)another);
    }

    private boolean equalTo(ImmutableObjectsResult<?> another) {
        return Objects.equals(this.repo, another.repo) && Objects.equals(this.objects, another.objects) && this.status.equals((Object)another.status) && this.messages.equals(another.messages);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repo);
        h += (h << 5) + Objects.hashCode(this.objects);
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + this.messages.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ObjectsResult").omitNullValues().add("repo", (Object)this.repo).add("objects", this.objects).add("status", (Object)this.status).add("messages", this.messages).toString();
    }

    public static <T> ImmutableObjectsResult<T> copyOf(ObjectsActions.ObjectsResult<T> instance) {
        if (instance instanceof ImmutableObjectsResult) {
            return (ImmutableObjectsResult)instance;
        }
        return ImmutableObjectsResult.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="ObjectsActions.ObjectsResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_STATUS = 1L;
        private long initBits = 1L;
        @Nullable
        private Repo repo;
        @Nullable
        private T objects;
        @Nullable
        private ObjectsActions.ObjectsStatus status;
        private ImmutableList.Builder<Message> messages = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(ObjectsActions.ObjectsResult<T> instance) {
            T objectsValue;
            Objects.requireNonNull(instance, "instance");
            Repo repoValue = instance.getRepo();
            if (repoValue != null) {
                this.repo(repoValue);
            }
            if ((objectsValue = instance.getObjects()) != null) {
                this.objects(objectsValue);
            }
            this.status(instance.getStatus());
            this.addAllMessages(instance.getMessages());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> repo(@Nullable Repo repo) {
            this.repo = repo;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> objects(@Nullable T objects) {
            this.objects = objects;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> status(ObjectsActions.ObjectsStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> addMessages(Message element) {
            this.messages.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> addMessages(Message ... elements) {
            this.messages.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> messages(Iterable<? extends Message> elements) {
            this.messages = ImmutableList.builder();
            return this.addAllMessages(elements);
        }

        @CanIgnoreReturnValue
        public final Builder<T> addAllMessages(Iterable<? extends Message> elements) {
            this.messages.addAll(elements);
            return this;
        }

        public ImmutableObjectsResult<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableObjectsResult<T>(this.repo, this.objects, this.status, (ImmutableList<Message>)this.messages.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build ObjectsResult, some of required attributes are not set " + attributes;
        }
    }
}

