/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.actions.HistoryActions;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HistoryActions.HistoryResult", generator="Immutables")
@Immutable
public final class ImmutableHistoryResult
implements HistoryActions.HistoryResult {
    private final String value;
    private final String commit;
    private final LocalDateTime created;

    private ImmutableHistoryResult(String value, String commit, LocalDateTime created) {
        this.value = value;
        this.commit = commit;
        this.created = created;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getCommit() {
        return this.commit;
    }

    @Override
    public LocalDateTime getCreated() {
        return this.created;
    }

    public final ImmutableHistoryResult withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableHistoryResult(newValue, this.commit, this.created);
    }

    public final ImmutableHistoryResult withCommit(String value) {
        String newValue = Objects.requireNonNull(value, "commit");
        if (this.commit.equals(newValue)) {
            return this;
        }
        return new ImmutableHistoryResult(this.value, newValue, this.created);
    }

    public final ImmutableHistoryResult withCreated(LocalDateTime value) {
        if (this.created == value) {
            return this;
        }
        LocalDateTime newValue = Objects.requireNonNull(value, "created");
        return new ImmutableHistoryResult(this.value, this.commit, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHistoryResult && this.equalTo((ImmutableHistoryResult)another);
    }

    private boolean equalTo(ImmutableHistoryResult another) {
        return this.value.equals(another.value) && this.commit.equals(another.commit) && this.created.equals(another.created);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.commit.hashCode();
        h += (h << 5) + this.created.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"HistoryResult").omitNullValues().add("value", (Object)this.value).add("commit", (Object)this.commit).add("created", (Object)this.created).toString();
    }

    public static ImmutableHistoryResult copyOf(HistoryActions.HistoryResult instance) {
        if (instance instanceof ImmutableHistoryResult) {
            return (ImmutableHistoryResult)instance;
        }
        return ImmutableHistoryResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HistoryActions.HistoryResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_COMMIT = 2L;
        private static final long INIT_BIT_CREATED = 4L;
        private long initBits = 7L;
        @Nullable
        private String value;
        @Nullable
        private String commit;
        @Nullable
        private LocalDateTime created;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HistoryActions.HistoryResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.getValue());
            this.commit(instance.getCommit());
            this.created(instance.getCreated());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commit(String commit) {
            this.commit = Objects.requireNonNull(commit, "commit");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder created(LocalDateTime created) {
            this.created = Objects.requireNonNull(created, "created");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableHistoryResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHistoryResult(this.value, this.commit, this.created);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commit");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("created");
            }
            return "Cannot build HistoryResult, some of required attributes are not set " + attributes;
        }
    }
}

