/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.actions.CommitActions;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Objects;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitActions.CommitResult", generator="Immutables")
@Immutable
public final class ImmutableCommitResult
implements CommitActions.CommitResult {
    private final String gid;
    @Nullable
    private final Objects.Commit commit;
    private final CommitActions.CommitStatus status;
    private final ImmutableList<Message> messages;

    private ImmutableCommitResult(String gid, @Nullable Objects.Commit commit, CommitActions.CommitStatus status, ImmutableList<Message> messages) {
        this.gid = gid;
        this.commit = commit;
        this.status = status;
        this.messages = messages;
    }

    @Override
    public String getGid() {
        return this.gid;
    }

    @Override
    @Nullable
    public Objects.Commit getCommit() {
        return this.commit;
    }

    @Override
    public CommitActions.CommitStatus getStatus() {
        return this.status;
    }

    public ImmutableList<Message> getMessages() {
        return this.messages;
    }

    public final ImmutableCommitResult withGid(String value) {
        String newValue = Objects.requireNonNull(value, "gid");
        if (this.gid.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitResult(newValue, this.commit, this.status, this.messages);
    }

    public final ImmutableCommitResult withCommit(@Nullable Objects.Commit value) {
        if (this.commit == value) {
            return this;
        }
        return new ImmutableCommitResult(this.gid, value, this.status, this.messages);
    }

    public final ImmutableCommitResult withStatus(CommitActions.CommitStatus value) {
        if (this.status == value) {
            return this;
        }
        CommitActions.CommitStatus newValue = Objects.requireNonNull(value, "status");
        if (this.status.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableCommitResult(this.gid, this.commit, newValue, this.messages);
    }

    public final ImmutableCommitResult withMessages(Message ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitResult(this.gid, this.commit, this.status, (ImmutableList<Message>)newValue);
    }

    public final ImmutableCommitResult withMessages(Iterable<? extends Message> elements) {
        if (this.messages == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitResult(this.gid, this.commit, this.status, (ImmutableList<Message>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitResult && this.equalTo((ImmutableCommitResult)another);
    }

    private boolean equalTo(ImmutableCommitResult another) {
        return this.gid.equals(another.gid) && Objects.equals(this.commit, another.commit) && this.status.equals((Object)another.status) && this.messages.equals(another.messages);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.gid.hashCode();
        h += (h << 5) + Objects.hashCode(this.commit);
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + this.messages.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitResult").omitNullValues().add("gid", (Object)this.gid).add("commit", (Object)this.commit).add("status", (Object)this.status).add("messages", this.messages).toString();
    }

    public static ImmutableCommitResult copyOf(CommitActions.CommitResult instance) {
        if (instance instanceof ImmutableCommitResult) {
            return (ImmutableCommitResult)instance;
        }
        return ImmutableCommitResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitActions.CommitResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GID = 1L;
        private static final long INIT_BIT_STATUS = 2L;
        private long initBits = 3L;
        @Nullable
        private String gid;
        @Nullable
        private Objects.Commit commit;
        @Nullable
        private CommitActions.CommitStatus status;
        private ImmutableList.Builder<Message> messages = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitActions.CommitResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.gid(instance.getGid());
            Objects.Commit commitValue = instance.getCommit();
            if (commitValue != null) {
                this.commit(commitValue);
            }
            this.status(instance.getStatus());
            this.addAllMessages(instance.getMessages());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gid(String gid) {
            this.gid = Objects.requireNonNull(gid, "gid");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commit(@Nullable Objects.Commit commit) {
            this.commit = commit;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder status(CommitActions.CommitStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMessages(Message element) {
            this.messages.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMessages(Message ... elements) {
            this.messages.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder messages(Iterable<? extends Message> elements) {
            this.messages = ImmutableList.builder();
            return this.addAllMessages(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMessages(Iterable<? extends Message> elements) {
            this.messages.addAll(elements);
            return this;
        }

        public ImmutableCommitResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitResult(this.gid, this.commit, this.status, (ImmutableList<Message>)this.messages.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("gid");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build CommitResult, some of required attributes are not set " + attributes;
        }
    }
}

