/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ObjectsActions.CommitObjects", generator="Immutables")
@Immutable
public final class ImmutableCommitObjects
implements ObjectsActions.CommitObjects {
    private final Repo repo;
    private final Objects.Commit commit;
    private final Objects.Tree tree;
    private final ImmutableMap<String, Objects.Blob> blobs;

    private ImmutableCommitObjects(Repo repo, Objects.Commit commit, Objects.Tree tree, ImmutableMap<String, Objects.Blob> blobs) {
        this.repo = repo;
        this.commit = commit;
        this.tree = tree;
        this.blobs = blobs;
    }

    @Override
    public Repo getRepo() {
        return this.repo;
    }

    @Override
    public Objects.Commit getCommit() {
        return this.commit;
    }

    @Override
    public Objects.Tree getTree() {
        return this.tree;
    }

    public ImmutableMap<String, Objects.Blob> getBlobs() {
        return this.blobs;
    }

    public final ImmutableCommitObjects withRepo(Repo value) {
        if (this.repo == value) {
            return this;
        }
        Repo newValue = Objects.requireNonNull(value, "repo");
        return new ImmutableCommitObjects(newValue, this.commit, this.tree, this.blobs);
    }

    public final ImmutableCommitObjects withCommit(Objects.Commit value) {
        if (this.commit == value) {
            return this;
        }
        Objects.Commit newValue = Objects.requireNonNull(value, "commit");
        return new ImmutableCommitObjects(this.repo, newValue, this.tree, this.blobs);
    }

    public final ImmutableCommitObjects withTree(Objects.Tree value) {
        if (this.tree == value) {
            return this;
        }
        Objects.Tree newValue = Objects.requireNonNull(value, "tree");
        return new ImmutableCommitObjects(this.repo, this.commit, newValue, this.blobs);
    }

    public final ImmutableCommitObjects withBlobs(Map<String, ? extends Objects.Blob> entries) {
        if (this.blobs == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCommitObjects(this.repo, this.commit, this.tree, (ImmutableMap<String, Objects.Blob>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitObjects && this.equalTo((ImmutableCommitObjects)another);
    }

    private boolean equalTo(ImmutableCommitObjects another) {
        return this.repo.equals(another.repo) && this.commit.equals(another.commit) && this.tree.equals(another.tree) && this.blobs.equals(another.blobs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.repo.hashCode();
        h += (h << 5) + this.commit.hashCode();
        h += (h << 5) + this.tree.hashCode();
        h += (h << 5) + this.blobs.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitObjects").omitNullValues().add("repo", (Object)this.repo).add("commit", (Object)this.commit).add("tree", (Object)this.tree).add("blobs", this.blobs).toString();
    }

    public static ImmutableCommitObjects copyOf(ObjectsActions.CommitObjects instance) {
        if (instance instanceof ImmutableCommitObjects) {
            return (ImmutableCommitObjects)instance;
        }
        return ImmutableCommitObjects.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ObjectsActions.CommitObjects", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REPO = 1L;
        private static final long INIT_BIT_COMMIT = 2L;
        private static final long INIT_BIT_TREE = 4L;
        private long initBits = 7L;
        @Nullable
        private Repo repo;
        @Nullable
        private Objects.Commit commit;
        @Nullable
        private Objects.Tree tree;
        private ImmutableMap.Builder<String, Objects.Blob> blobs = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ObjectsActions.CommitObjects instance) {
            Objects.requireNonNull(instance, "instance");
            this.repo(instance.getRepo());
            this.commit(instance.getCommit());
            this.tree(instance.getTree());
            this.putAllBlobs(instance.getBlobs());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repo(Repo repo) {
            this.repo = Objects.requireNonNull(repo, "repo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commit(Objects.Commit commit) {
            this.commit = Objects.requireNonNull(commit, "commit");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tree(Objects.Tree tree) {
            this.tree = Objects.requireNonNull(tree, "tree");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putBlobs(String key, Objects.Blob value) {
            this.blobs.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putBlobs(Map.Entry<String, ? extends Objects.Blob> entry) {
            this.blobs.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blobs(Map<String, ? extends Objects.Blob> entries) {
            this.blobs = ImmutableMap.builder();
            return this.putAllBlobs(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllBlobs(Map<String, ? extends Objects.Blob> entries) {
            this.blobs.putAll(entries);
            return this;
        }

        public ImmutableCommitObjects build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitObjects(this.repo, this.commit, this.tree, (ImmutableMap<String, Objects.Blob>)this.blobs.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("repo");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commit");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("tree");
            }
            return "Cannot build CommitObjects, some of required attributes are not set " + attributes;
        }
    }
}

