/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ObjectsActions.BlobObjects", generator="Immutables")
@Immutable
public final class ImmutableBlobObjects
implements ObjectsActions.BlobObjects {
    private final Repo repo;
    private final Objects.Commit commit;
    private final Objects.Tree tree;
    private final ImmutableList<Objects.Blob> blob;

    private ImmutableBlobObjects(Repo repo, Objects.Commit commit, Objects.Tree tree, ImmutableList<Objects.Blob> blob) {
        this.repo = repo;
        this.commit = commit;
        this.tree = tree;
        this.blob = blob;
    }

    @Override
    public Repo getRepo() {
        return this.repo;
    }

    @Override
    public Objects.Commit getCommit() {
        return this.commit;
    }

    @Override
    public Objects.Tree getTree() {
        return this.tree;
    }

    public ImmutableList<Objects.Blob> getBlob() {
        return this.blob;
    }

    public final ImmutableBlobObjects withRepo(Repo value) {
        if (this.repo == value) {
            return this;
        }
        Repo newValue = Objects.requireNonNull(value, "repo");
        return new ImmutableBlobObjects(newValue, this.commit, this.tree, this.blob);
    }

    public final ImmutableBlobObjects withCommit(Objects.Commit value) {
        if (this.commit == value) {
            return this;
        }
        Objects.Commit newValue = Objects.requireNonNull(value, "commit");
        return new ImmutableBlobObjects(this.repo, newValue, this.tree, this.blob);
    }

    public final ImmutableBlobObjects withTree(Objects.Tree value) {
        if (this.tree == value) {
            return this;
        }
        Objects.Tree newValue = Objects.requireNonNull(value, "tree");
        return new ImmutableBlobObjects(this.repo, this.commit, newValue, this.blob);
    }

    public final ImmutableBlobObjects withBlob(Objects.Blob ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableBlobObjects(this.repo, this.commit, this.tree, (ImmutableList<Objects.Blob>)newValue);
    }

    public final ImmutableBlobObjects withBlob(Iterable<? extends Objects.Blob> elements) {
        if (this.blob == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableBlobObjects(this.repo, this.commit, this.tree, (ImmutableList<Objects.Blob>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBlobObjects && this.equalTo((ImmutableBlobObjects)another);
    }

    private boolean equalTo(ImmutableBlobObjects another) {
        return this.repo.equals(another.repo) && this.commit.equals(another.commit) && this.tree.equals(another.tree) && this.blob.equals(another.blob);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.repo.hashCode();
        h += (h << 5) + this.commit.hashCode();
        h += (h << 5) + this.tree.hashCode();
        h += (h << 5) + this.blob.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BlobObjects").omitNullValues().add("repo", (Object)this.repo).add("commit", (Object)this.commit).add("tree", (Object)this.tree).add("blob", this.blob).toString();
    }

    public static ImmutableBlobObjects copyOf(ObjectsActions.BlobObjects instance) {
        if (instance instanceof ImmutableBlobObjects) {
            return (ImmutableBlobObjects)instance;
        }
        return ImmutableBlobObjects.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ObjectsActions.BlobObjects", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REPO = 1L;
        private static final long INIT_BIT_COMMIT = 2L;
        private static final long INIT_BIT_TREE = 4L;
        private long initBits = 7L;
        @Nullable
        private Repo repo;
        @Nullable
        private Objects.Commit commit;
        @Nullable
        private Objects.Tree tree;
        private ImmutableList.Builder<Objects.Blob> blob = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ObjectsActions.BlobObjects instance) {
            Objects.requireNonNull(instance, "instance");
            this.repo(instance.getRepo());
            this.commit(instance.getCommit());
            this.tree(instance.getTree());
            this.addAllBlob(instance.getBlob());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repo(Repo repo) {
            this.repo = Objects.requireNonNull(repo, "repo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commit(Objects.Commit commit) {
            this.commit = Objects.requireNonNull(commit, "commit");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tree(Objects.Tree tree) {
            this.tree = Objects.requireNonNull(tree, "tree");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addBlob(Objects.Blob element) {
            this.blob.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addBlob(Objects.Blob ... elements) {
            this.blob.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blob(Iterable<? extends Objects.Blob> elements) {
            this.blob = ImmutableList.builder();
            return this.addAllBlob(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllBlob(Iterable<? extends Objects.Blob> elements) {
            this.blob.addAll(elements);
            return this;
        }

        public ImmutableBlobObjects build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBlobObjects(this.repo, this.commit, this.tree, (ImmutableList<Objects.Blob>)this.blob.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("repo");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commit");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("tree");
            }
            return "Cannot build BlobObjects, some of required attributes are not set " + attributes;
        }
    }
}

