/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.thena.docdb.api.actions.ObjectsActions;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ObjectsActions.BlobObject", generator="Immutables")
@Immutable
public final class ImmutableBlobObject
implements ObjectsActions.BlobObject {
    private final Repo repo;
    private final Objects.Commit commit;
    private final Objects.Tree tree;
    private final Objects.Blob blob;

    private ImmutableBlobObject(Repo repo, Objects.Commit commit, Objects.Tree tree, Objects.Blob blob) {
        this.repo = repo;
        this.commit = commit;
        this.tree = tree;
        this.blob = blob;
    }

    @Override
    public Repo getRepo() {
        return this.repo;
    }

    @Override
    public Objects.Commit getCommit() {
        return this.commit;
    }

    @Override
    public Objects.Tree getTree() {
        return this.tree;
    }

    @Override
    public Objects.Blob getBlob() {
        return this.blob;
    }

    public final ImmutableBlobObject withRepo(Repo value) {
        if (this.repo == value) {
            return this;
        }
        Repo newValue = Objects.requireNonNull(value, "repo");
        return new ImmutableBlobObject(newValue, this.commit, this.tree, this.blob);
    }

    public final ImmutableBlobObject withCommit(Objects.Commit value) {
        if (this.commit == value) {
            return this;
        }
        Objects.Commit newValue = Objects.requireNonNull(value, "commit");
        return new ImmutableBlobObject(this.repo, newValue, this.tree, this.blob);
    }

    public final ImmutableBlobObject withTree(Objects.Tree value) {
        if (this.tree == value) {
            return this;
        }
        Objects.Tree newValue = Objects.requireNonNull(value, "tree");
        return new ImmutableBlobObject(this.repo, this.commit, newValue, this.blob);
    }

    public final ImmutableBlobObject withBlob(Objects.Blob value) {
        if (this.blob == value) {
            return this;
        }
        Objects.Blob newValue = Objects.requireNonNull(value, "blob");
        return new ImmutableBlobObject(this.repo, this.commit, this.tree, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBlobObject && this.equalTo((ImmutableBlobObject)another);
    }

    private boolean equalTo(ImmutableBlobObject another) {
        return this.repo.equals(another.repo) && this.commit.equals(another.commit) && this.tree.equals(another.tree) && this.blob.equals(another.blob);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.repo.hashCode();
        h += (h << 5) + this.commit.hashCode();
        h += (h << 5) + this.tree.hashCode();
        h += (h << 5) + this.blob.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BlobObject").omitNullValues().add("repo", (Object)this.repo).add("commit", (Object)this.commit).add("tree", (Object)this.tree).add("blob", (Object)this.blob).toString();
    }

    public static ImmutableBlobObject copyOf(ObjectsActions.BlobObject instance) {
        if (instance instanceof ImmutableBlobObject) {
            return (ImmutableBlobObject)instance;
        }
        return ImmutableBlobObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ObjectsActions.BlobObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REPO = 1L;
        private static final long INIT_BIT_COMMIT = 2L;
        private static final long INIT_BIT_TREE = 4L;
        private static final long INIT_BIT_BLOB = 8L;
        private long initBits = 15L;
        @Nullable
        private Repo repo;
        @Nullable
        private Objects.Commit commit;
        @Nullable
        private Objects.Tree tree;
        @Nullable
        private Objects.Blob blob;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ObjectsActions.BlobObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.repo(instance.getRepo());
            this.commit(instance.getCommit());
            this.tree(instance.getTree());
            this.blob(instance.getBlob());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repo(Repo repo) {
            this.repo = Objects.requireNonNull(repo, "repo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commit(Objects.Commit commit) {
            this.commit = Objects.requireNonNull(commit, "commit");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tree(Objects.Tree tree) {
            this.tree = Objects.requireNonNull(tree, "tree");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blob(Objects.Blob blob) {
            this.blob = Objects.requireNonNull(blob, "blob");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableBlobObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBlobObject(this.repo, this.commit, this.tree, this.blob);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("repo");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commit");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("tree");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("blob");
            }
            return "Cannot build BlobObject, some of required attributes are not set " + attributes;
        }
    }
}

