/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.docdb.api.actions;

import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Objects;
import io.smallrye.mutiny.Uni;
import java.util.List;
import javax.annotation.Nullable;
import org.immutables.value.Value;

public interface CommitActions {
    public HeadCommitBuilder head();

    public MergeBuilder merge();

    public RebaseBuilder rebase();

    @Value.Immutable
    public static interface CommitResult {
        public String getGid();

        @Nullable
        public Objects.Commit getCommit();

        public CommitStatus getStatus();

        public List<Message> getMessages();
    }

    public static enum CommitStatus {
        OK,
        ERROR,
        CONFLICT;

    }

    public static interface HeadCommitBuilder {
        public HeadCommitBuilder id(String var1);

        public HeadCommitBuilder parent(String var1);

        public HeadCommitBuilder parentIsLatest();

        public HeadCommitBuilder head(String var1, String var2);

        public HeadCommitBuilder append(String var1, String var2);

        public HeadCommitBuilder remove(String var1);

        public HeadCommitBuilder author(String var1);

        public HeadCommitBuilder message(String var1);

        public Uni<CommitResult> build();
    }

    public static interface MergeBuilder {
        public MergeBuilder repo(String var1);

        public MergeBuilder from(String var1);

        public MergeBuilder to(String var1);

        public MergeBuilder author(String var1);

        public MergeBuilder message(String var1);

        public Uni<CommitResult> build();
    }

    public static interface RebaseBuilder {
        public RebaseBuilder author(String var1);

        public RebaseBuilder message(String var1);

        public RebaseBuilder id(String var1);

        public RebaseBuilder head(String var1, @Nullable String var2);

        public Uni<CommitResult> build();
    }
}

