package io.resys.thena.docdb.sql;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SqlBuilder.SqlTuple}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSqlTuple.builder()}.
 */
@Generated(from = "SqlBuilder.SqlTuple", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSqlTuple implements SqlBuilder.SqlTuple {
  private final String value;
  private final Tuple props;

  private ImmutableSqlTuple(String value, Tuple props) {
    this.value = value;
    this.props = props;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code props} attribute
   */
  @Override
  public Tuple getProps() {
    return props;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SqlBuilder.SqlTuple#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSqlTuple withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableSqlTuple(newValue, this.props);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SqlBuilder.SqlTuple#getProps() props} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for props
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSqlTuple withProps(Tuple value) {
    if (this.props == value) return this;
    Tuple newValue = Objects.requireNonNull(value, "props");
    return new ImmutableSqlTuple(this.value, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSqlTuple} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSqlTuple
        && equalTo((ImmutableSqlTuple) another);
  }

  private boolean equalTo(ImmutableSqlTuple another) {
    return value.equals(another.value)
        && props.equals(another.props);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code props}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    h += (h << 5) + props.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SqlTuple} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SqlTuple")
        .omitNullValues()
        .add("value", value)
        .add("props", props)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SqlBuilder.SqlTuple} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SqlTuple instance
   */
  public static ImmutableSqlTuple copyOf(SqlBuilder.SqlTuple instance) {
    if (instance instanceof ImmutableSqlTuple) {
      return (ImmutableSqlTuple) instance;
    }
    return ImmutableSqlTuple.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSqlTuple ImmutableSqlTuple}.
   * <pre>
   * ImmutableSqlTuple.builder()
   *    .value(String) // required {@link SqlBuilder.SqlTuple#getValue() value}
   *    .props(io.vertx.mutiny.sqlclient.Tuple) // required {@link SqlBuilder.SqlTuple#getProps() props}
   *    .build();
   * </pre>
   * @return A new ImmutableSqlTuple builder
   */
  public static ImmutableSqlTuple.Builder builder() {
    return new ImmutableSqlTuple.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSqlTuple ImmutableSqlTuple}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SqlBuilder.SqlTuple", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private static final long INIT_BIT_PROPS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String value;
    private @Nullable Tuple props;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SqlTuple} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SqlBuilder.SqlTuple instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.getValue());
      props(instance.getProps());
      return this;
    }

    /**
     * Initializes the value for the {@link SqlBuilder.SqlTuple#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link SqlBuilder.SqlTuple#getProps() props} attribute.
     * @param props The value for props 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder props(Tuple props) {
      this.props = Objects.requireNonNull(props, "props");
      initBits &= ~INIT_BIT_PROPS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSqlTuple ImmutableSqlTuple}.
     * @return An immutable instance of SqlTuple
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSqlTuple build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSqlTuple(value, props);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_PROPS) != 0) attributes.add("props");
      return "Cannot build SqlTuple, some of required attributes are not set " + attributes;
    }
  }
}
