package io.resys.thena.docdb.spi;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.docdb.api.models.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ClientInsertBuilder.UpsertResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUpsertResult.builder()}.
 */
@Generated(from = "ClientInsertBuilder.UpsertResult", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUpsertResult implements ClientInsertBuilder.UpsertResult {
  private final String id;
  private final boolean isModified;
  private final Message message;
  private final Object target;
  private final ClientInsertBuilder.UpsertStatus status;

  private ImmutableUpsertResult(
      String id,
      boolean isModified,
      Message message,
      Object target,
      ClientInsertBuilder.UpsertStatus status) {
    this.id = id;
    this.isModified = isModified;
    this.message = message;
    this.target = target;
    this.status = status;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code isModified} attribute
   */
  @Override
  public boolean isModified() {
    return isModified;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @Override
  public Message getMessage() {
    return message;
  }

  /**
   * @return The value of the {@code target} attribute
   */
  @Override
  public Object getTarget() {
    return target;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @Override
  public ClientInsertBuilder.UpsertStatus getStatus() {
    return status;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClientInsertBuilder.UpsertResult#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpsertResult withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableUpsertResult(newValue, this.isModified, this.message, this.target, this.status);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClientInsertBuilder.UpsertResult#isModified() isModified} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isModified
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpsertResult withIsModified(boolean value) {
    if (this.isModified == value) return this;
    return new ImmutableUpsertResult(this.id, value, this.message, this.target, this.status);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClientInsertBuilder.UpsertResult#getMessage() message} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpsertResult withMessage(Message value) {
    if (this.message == value) return this;
    Message newValue = Objects.requireNonNull(value, "message");
    return new ImmutableUpsertResult(this.id, this.isModified, newValue, this.target, this.status);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClientInsertBuilder.UpsertResult#getTarget() target} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for target
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpsertResult withTarget(Object value) {
    if (this.target == value) return this;
    Object newValue = Objects.requireNonNull(value, "target");
    return new ImmutableUpsertResult(this.id, this.isModified, this.message, newValue, this.status);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClientInsertBuilder.UpsertResult#getStatus() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpsertResult withStatus(ClientInsertBuilder.UpsertStatus value) {
    if (this.status == value) return this;
    ClientInsertBuilder.UpsertStatus newValue = Objects.requireNonNull(value, "status");
    if (this.status.equals(newValue)) return this;
    return new ImmutableUpsertResult(this.id, this.isModified, this.message, this.target, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUpsertResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUpsertResult
        && equalTo((ImmutableUpsertResult) another);
  }

  private boolean equalTo(ImmutableUpsertResult another) {
    return id.equals(another.id)
        && isModified == another.isModified
        && message.equals(another.message)
        && target.equals(another.target)
        && status.equals(another.status);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code isModified}, {@code message}, {@code target}, {@code status}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Booleans.hashCode(isModified);
    h += (h << 5) + message.hashCode();
    h += (h << 5) + target.hashCode();
    h += (h << 5) + status.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpsertResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UpsertResult")
        .omitNullValues()
        .add("id", id)
        .add("isModified", isModified)
        .add("message", message)
        .add("target", target)
        .add("status", status)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ClientInsertBuilder.UpsertResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UpsertResult instance
   */
  public static ImmutableUpsertResult copyOf(ClientInsertBuilder.UpsertResult instance) {
    if (instance instanceof ImmutableUpsertResult) {
      return (ImmutableUpsertResult) instance;
    }
    return ImmutableUpsertResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUpsertResult ImmutableUpsertResult}.
   * <pre>
   * ImmutableUpsertResult.builder()
   *    .id(String) // required {@link ClientInsertBuilder.UpsertResult#getId() id}
   *    .isModified(boolean) // required {@link ClientInsertBuilder.UpsertResult#isModified() isModified}
   *    .message(io.resys.thena.docdb.api.models.Message) // required {@link ClientInsertBuilder.UpsertResult#getMessage() message}
   *    .target(Object) // required {@link ClientInsertBuilder.UpsertResult#getTarget() target}
   *    .status(io.resys.thena.docdb.spi.ClientInsertBuilder.UpsertStatus) // required {@link ClientInsertBuilder.UpsertResult#getStatus() status}
   *    .build();
   * </pre>
   * @return A new ImmutableUpsertResult builder
   */
  public static ImmutableUpsertResult.Builder builder() {
    return new ImmutableUpsertResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUpsertResult ImmutableUpsertResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ClientInsertBuilder.UpsertResult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_IS_MODIFIED = 0x2L;
    private static final long INIT_BIT_MESSAGE = 0x4L;
    private static final long INIT_BIT_TARGET = 0x8L;
    private static final long INIT_BIT_STATUS = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String id;
    private boolean isModified;
    private @Nullable Message message;
    private @Nullable Object target;
    private @Nullable ClientInsertBuilder.UpsertStatus status;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpsertResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ClientInsertBuilder.UpsertResult instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      isModified(instance.isModified());
      message(instance.getMessage());
      target(instance.getTarget());
      status(instance.getStatus());
      return this;
    }

    /**
     * Initializes the value for the {@link ClientInsertBuilder.UpsertResult#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ClientInsertBuilder.UpsertResult#isModified() isModified} attribute.
     * @param isModified The value for isModified 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isModified(boolean isModified) {
      this.isModified = isModified;
      initBits &= ~INIT_BIT_IS_MODIFIED;
      return this;
    }

    /**
     * Initializes the value for the {@link ClientInsertBuilder.UpsertResult#getMessage() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder message(Message message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link ClientInsertBuilder.UpsertResult#getTarget() target} attribute.
     * @param target The value for target 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder target(Object target) {
      this.target = Objects.requireNonNull(target, "target");
      initBits &= ~INIT_BIT_TARGET;
      return this;
    }

    /**
     * Initializes the value for the {@link ClientInsertBuilder.UpsertResult#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder status(ClientInsertBuilder.UpsertStatus status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUpsertResult ImmutableUpsertResult}.
     * @return An immutable instance of UpsertResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUpsertResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUpsertResult(id, isModified, message, target, status);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_IS_MODIFIED) != 0) attributes.add("isModified");
      if ((initBits & INIT_BIT_MESSAGE) != 0) attributes.add("message");
      if ((initBits & INIT_BIT_TARGET) != 0) attributes.add("target");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build UpsertResult, some of required attributes are not set " + attributes;
    }
  }
}
