package io.resys.thena.docdb.spi;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ClientQuery.DeleteResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeleteResult.builder()}.
 */
@Generated(from = "ClientQuery.DeleteResult", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDeleteResult implements ClientQuery.DeleteResult {
  private final long deletedCount;

  private ImmutableDeleteResult(long deletedCount) {
    this.deletedCount = deletedCount;
  }

  /**
   * @return The value of the {@code deletedCount} attribute
   */
  @Override
  public long getDeletedCount() {
    return deletedCount;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClientQuery.DeleteResult#getDeletedCount() deletedCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deletedCount
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeleteResult withDeletedCount(long value) {
    if (this.deletedCount == value) return this;
    return new ImmutableDeleteResult(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeleteResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeleteResult
        && equalTo((ImmutableDeleteResult) another);
  }

  private boolean equalTo(ImmutableDeleteResult another) {
    return deletedCount == another.deletedCount;
  }

  /**
   * Computes a hash code from attributes: {@code deletedCount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Longs.hashCode(deletedCount);
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DeleteResult")
        .omitNullValues()
        .add("deletedCount", deletedCount)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ClientQuery.DeleteResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeleteResult instance
   */
  public static ImmutableDeleteResult copyOf(ClientQuery.DeleteResult instance) {
    if (instance instanceof ImmutableDeleteResult) {
      return (ImmutableDeleteResult) instance;
    }
    return ImmutableDeleteResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeleteResult ImmutableDeleteResult}.
   * <pre>
   * ImmutableDeleteResult.builder()
   *    .deletedCount(long) // required {@link ClientQuery.DeleteResult#getDeletedCount() deletedCount}
   *    .build();
   * </pre>
   * @return A new ImmutableDeleteResult builder
   */
  public static ImmutableDeleteResult.Builder builder() {
    return new ImmutableDeleteResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeleteResult ImmutableDeleteResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ClientQuery.DeleteResult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DELETED_COUNT = 0x1L;
    private long initBits = 0x1L;

    private long deletedCount;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ClientQuery.DeleteResult instance) {
      Objects.requireNonNull(instance, "instance");
      deletedCount(instance.getDeletedCount());
      return this;
    }

    /**
     * Initializes the value for the {@link ClientQuery.DeleteResult#getDeletedCount() deletedCount} attribute.
     * @param deletedCount The value for deletedCount 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder deletedCount(long deletedCount) {
      this.deletedCount = deletedCount;
      initBits &= ~INIT_BIT_DELETED_COUNT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeleteResult ImmutableDeleteResult}.
     * @return An immutable instance of DeleteResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeleteResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDeleteResult(deletedCount);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DELETED_COUNT) != 0) attributes.add("deletedCount");
      return "Cannot build DeleteResult, some of required attributes are not set " + attributes;
    }
  }
}
