package io.resys.thena.docdb.file.tables;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TreeItemTable.TreeItemTableRow}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTreeItemTableRow.builder()}.
 */
@Generated(from = "TreeItemTable.TreeItemTableRow", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTreeItemTableRow
    implements TreeItemTable.TreeItemTableRow {
  private final String id;
  private final String name;
  private final String blob;
  private final String tree;

  private ImmutableTreeItemTableRow(String id, String name, String blob, String tree) {
    this.id = id;
    this.name = name;
    this.blob = blob;
    this.tree = tree;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code blob} attribute
   */
  @JsonProperty("blob")
  @Override
  public String getBlob() {
    return blob;
  }

  /**
   * @return The value of the {@code tree} attribute
   */
  @JsonProperty("tree")
  @Override
  public String getTree() {
    return tree;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TreeItemTable.TreeItemTableRow#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTreeItemTableRow withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableTreeItemTableRow(newValue, this.name, this.blob, this.tree);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TreeItemTable.TreeItemTableRow#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTreeItemTableRow withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableTreeItemTableRow(this.id, newValue, this.blob, this.tree);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TreeItemTable.TreeItemTableRow#getBlob() blob} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for blob
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTreeItemTableRow withBlob(String value) {
    String newValue = Objects.requireNonNull(value, "blob");
    if (this.blob.equals(newValue)) return this;
    return new ImmutableTreeItemTableRow(this.id, this.name, newValue, this.tree);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TreeItemTable.TreeItemTableRow#getTree() tree} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tree
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTreeItemTableRow withTree(String value) {
    String newValue = Objects.requireNonNull(value, "tree");
    if (this.tree.equals(newValue)) return this;
    return new ImmutableTreeItemTableRow(this.id, this.name, this.blob, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTreeItemTableRow} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTreeItemTableRow
        && equalTo((ImmutableTreeItemTableRow) another);
  }

  private boolean equalTo(ImmutableTreeItemTableRow another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && blob.equals(another.blob)
        && tree.equals(another.tree);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code blob}, {@code tree}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + blob.hashCode();
    h += (h << 5) + tree.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TreeItemTableRow} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TreeItemTableRow")
        .omitNullValues()
        .add("id", id)
        .add("name", name)
        .add("blob", blob)
        .add("tree", tree)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TreeItemTable.TreeItemTableRow", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements TreeItemTable.TreeItemTableRow {
    @Nullable String id;
    @Nullable String name;
    @Nullable String blob;
    @Nullable String tree;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("blob")
    public void setBlob(String blob) {
      this.blob = blob;
    }
    @JsonProperty("tree")
    public void setTree(String tree) {
      this.tree = tree;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getBlob() { throw new UnsupportedOperationException(); }
    @Override
    public String getTree() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTreeItemTableRow fromJson(Json json) {
    ImmutableTreeItemTableRow.Builder builder = ImmutableTreeItemTableRow.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.blob != null) {
      builder.blob(json.blob);
    }
    if (json.tree != null) {
      builder.tree(json.tree);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TreeItemTable.TreeItemTableRow} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TreeItemTableRow instance
   */
  public static ImmutableTreeItemTableRow copyOf(TreeItemTable.TreeItemTableRow instance) {
    if (instance instanceof ImmutableTreeItemTableRow) {
      return (ImmutableTreeItemTableRow) instance;
    }
    return ImmutableTreeItemTableRow.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTreeItemTableRow ImmutableTreeItemTableRow}.
   * <pre>
   * ImmutableTreeItemTableRow.builder()
   *    .id(String) // required {@link TreeItemTable.TreeItemTableRow#getId() id}
   *    .name(String) // required {@link TreeItemTable.TreeItemTableRow#getName() name}
   *    .blob(String) // required {@link TreeItemTable.TreeItemTableRow#getBlob() blob}
   *    .tree(String) // required {@link TreeItemTable.TreeItemTableRow#getTree() tree}
   *    .build();
   * </pre>
   * @return A new ImmutableTreeItemTableRow builder
   */
  public static ImmutableTreeItemTableRow.Builder builder() {
    return new ImmutableTreeItemTableRow.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTreeItemTableRow ImmutableTreeItemTableRow}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TreeItemTable.TreeItemTableRow", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_BLOB = 0x4L;
    private static final long INIT_BIT_TREE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable String blob;
    private @Nullable String tree;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TreeItemTableRow} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TreeItemTable.TreeItemTableRow instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      name(instance.getName());
      blob(instance.getBlob());
      tree(instance.getTree());
      return this;
    }

    /**
     * Initializes the value for the {@link TreeItemTable.TreeItemTableRow#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link TreeItemTable.TreeItemTableRow#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link TreeItemTable.TreeItemTableRow#getBlob() blob} attribute.
     * @param blob The value for blob 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("blob")
    public final Builder blob(String blob) {
      this.blob = Objects.requireNonNull(blob, "blob");
      initBits &= ~INIT_BIT_BLOB;
      return this;
    }

    /**
     * Initializes the value for the {@link TreeItemTable.TreeItemTableRow#getTree() tree} attribute.
     * @param tree The value for tree 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("tree")
    public final Builder tree(String tree) {
      this.tree = Objects.requireNonNull(tree, "tree");
      initBits &= ~INIT_BIT_TREE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTreeItemTableRow ImmutableTreeItemTableRow}.
     * @return An immutable instance of TreeItemTableRow
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTreeItemTableRow build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTreeItemTableRow(id, name, blob, tree);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_BLOB) != 0) attributes.add("blob");
      if ((initBits & INIT_BIT_TREE) != 0) attributes.add("tree");
      return "Cannot build TreeItemTableRow, some of required attributes are not set " + attributes;
    }
  }
}
