package io.resys.thena.docdb.file.tables;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TagTable.TagTableRow}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTagTableRow.builder()}.
 */
@Generated(from = "TagTable.TagTableRow", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTagTableRow implements TagTable.TagTableRow {
  private final String id;
  private final String datetime;
  private final String author;
  private final String message;
  private final String commit;

  private ImmutableTagTableRow(
      String id,
      String datetime,
      String author,
      String message,
      String commit) {
    this.id = id;
    this.datetime = datetime;
    this.author = author;
    this.message = message;
    this.commit = commit;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code datetime} attribute
   */
  @JsonProperty("datetime")
  @Override
  public String getDatetime() {
    return datetime;
  }

  /**
   * @return The value of the {@code author} attribute
   */
  @JsonProperty("author")
  @Override
  public String getAuthor() {
    return author;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @JsonProperty("message")
  @Override
  public String getMessage() {
    return message;
  }

  /**
   * @return The value of the {@code commit} attribute
   */
  @JsonProperty("commit")
  @Override
  public String getCommit() {
    return commit;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TagTable.TagTableRow#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTagTableRow withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableTagTableRow(newValue, this.datetime, this.author, this.message, this.commit);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TagTable.TagTableRow#getDatetime() datetime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for datetime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTagTableRow withDatetime(String value) {
    String newValue = Objects.requireNonNull(value, "datetime");
    if (this.datetime.equals(newValue)) return this;
    return new ImmutableTagTableRow(this.id, newValue, this.author, this.message, this.commit);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TagTable.TagTableRow#getAuthor() author} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for author
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTagTableRow withAuthor(String value) {
    String newValue = Objects.requireNonNull(value, "author");
    if (this.author.equals(newValue)) return this;
    return new ImmutableTagTableRow(this.id, this.datetime, newValue, this.message, this.commit);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TagTable.TagTableRow#getMessage() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTagTableRow withMessage(String value) {
    String newValue = Objects.requireNonNull(value, "message");
    if (this.message.equals(newValue)) return this;
    return new ImmutableTagTableRow(this.id, this.datetime, this.author, newValue, this.commit);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TagTable.TagTableRow#getCommit() commit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTagTableRow withCommit(String value) {
    String newValue = Objects.requireNonNull(value, "commit");
    if (this.commit.equals(newValue)) return this;
    return new ImmutableTagTableRow(this.id, this.datetime, this.author, this.message, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTagTableRow} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTagTableRow
        && equalTo((ImmutableTagTableRow) another);
  }

  private boolean equalTo(ImmutableTagTableRow another) {
    return id.equals(another.id)
        && datetime.equals(another.datetime)
        && author.equals(another.author)
        && message.equals(another.message)
        && commit.equals(another.commit);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code datetime}, {@code author}, {@code message}, {@code commit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + datetime.hashCode();
    h += (h << 5) + author.hashCode();
    h += (h << 5) + message.hashCode();
    h += (h << 5) + commit.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TagTableRow} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TagTableRow")
        .omitNullValues()
        .add("id", id)
        .add("datetime", datetime)
        .add("author", author)
        .add("message", message)
        .add("commit", commit)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "TagTable.TagTableRow", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements TagTable.TagTableRow {
    @Nullable String id;
    @Nullable String datetime;
    @Nullable String author;
    @Nullable String message;
    @Nullable String commit;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("datetime")
    public void setDatetime(String datetime) {
      this.datetime = datetime;
    }
    @JsonProperty("author")
    public void setAuthor(String author) {
      this.author = author;
    }
    @JsonProperty("message")
    public void setMessage(String message) {
      this.message = message;
    }
    @JsonProperty("commit")
    public void setCommit(String commit) {
      this.commit = commit;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getDatetime() { throw new UnsupportedOperationException(); }
    @Override
    public String getAuthor() { throw new UnsupportedOperationException(); }
    @Override
    public String getMessage() { throw new UnsupportedOperationException(); }
    @Override
    public String getCommit() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTagTableRow fromJson(Json json) {
    ImmutableTagTableRow.Builder builder = ImmutableTagTableRow.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.datetime != null) {
      builder.datetime(json.datetime);
    }
    if (json.author != null) {
      builder.author(json.author);
    }
    if (json.message != null) {
      builder.message(json.message);
    }
    if (json.commit != null) {
      builder.commit(json.commit);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link TagTable.TagTableRow} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TagTableRow instance
   */
  public static ImmutableTagTableRow copyOf(TagTable.TagTableRow instance) {
    if (instance instanceof ImmutableTagTableRow) {
      return (ImmutableTagTableRow) instance;
    }
    return ImmutableTagTableRow.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTagTableRow ImmutableTagTableRow}.
   * <pre>
   * ImmutableTagTableRow.builder()
   *    .id(String) // required {@link TagTable.TagTableRow#getId() id}
   *    .datetime(String) // required {@link TagTable.TagTableRow#getDatetime() datetime}
   *    .author(String) // required {@link TagTable.TagTableRow#getAuthor() author}
   *    .message(String) // required {@link TagTable.TagTableRow#getMessage() message}
   *    .commit(String) // required {@link TagTable.TagTableRow#getCommit() commit}
   *    .build();
   * </pre>
   * @return A new ImmutableTagTableRow builder
   */
  public static ImmutableTagTableRow.Builder builder() {
    return new ImmutableTagTableRow.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTagTableRow ImmutableTagTableRow}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TagTable.TagTableRow", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_DATETIME = 0x2L;
    private static final long INIT_BIT_AUTHOR = 0x4L;
    private static final long INIT_BIT_MESSAGE = 0x8L;
    private static final long INIT_BIT_COMMIT = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String id;
    private @Nullable String datetime;
    private @Nullable String author;
    private @Nullable String message;
    private @Nullable String commit;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TagTableRow} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TagTable.TagTableRow instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      datetime(instance.getDatetime());
      author(instance.getAuthor());
      message(instance.getMessage());
      commit(instance.getCommit());
      return this;
    }

    /**
     * Initializes the value for the {@link TagTable.TagTableRow#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link TagTable.TagTableRow#getDatetime() datetime} attribute.
     * @param datetime The value for datetime 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("datetime")
    public final Builder datetime(String datetime) {
      this.datetime = Objects.requireNonNull(datetime, "datetime");
      initBits &= ~INIT_BIT_DATETIME;
      return this;
    }

    /**
     * Initializes the value for the {@link TagTable.TagTableRow#getAuthor() author} attribute.
     * @param author The value for author 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("author")
    public final Builder author(String author) {
      this.author = Objects.requireNonNull(author, "author");
      initBits &= ~INIT_BIT_AUTHOR;
      return this;
    }

    /**
     * Initializes the value for the {@link TagTable.TagTableRow#getMessage() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("message")
    public final Builder message(String message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link TagTable.TagTableRow#getCommit() commit} attribute.
     * @param commit The value for commit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("commit")
    public final Builder commit(String commit) {
      this.commit = Objects.requireNonNull(commit, "commit");
      initBits &= ~INIT_BIT_COMMIT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTagTableRow ImmutableTagTableRow}.
     * @return An immutable instance of TagTableRow
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTagTableRow build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTagTableRow(id, datetime, author, message, commit);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_DATETIME) != 0) attributes.add("datetime");
      if ((initBits & INIT_BIT_AUTHOR) != 0) attributes.add("author");
      if ((initBits & INIT_BIT_MESSAGE) != 0) attributes.add("message");
      if ((initBits & INIT_BIT_COMMIT) != 0) attributes.add("commit");
      return "Cannot build TagTableRow, some of required attributes are not set " + attributes;
    }
  }
}
