package io.resys.thena.docdb.file.tables;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RepoTable.RepoTableRow}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRepoTableRow.builder()}.
 */
@Generated(from = "RepoTable.RepoTableRow", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRepoTableRow implements RepoTable.RepoTableRow {
  private final String id;
  private final String rev;
  private final String prefix;
  private final String name;

  private ImmutableRepoTableRow(String id, String rev, String prefix, String name) {
    this.id = id;
    this.rev = rev;
    this.prefix = prefix;
    this.name = name;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @JsonProperty("rev")
  @Override
  public String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code prefix} attribute
   */
  @JsonProperty("prefix")
  @Override
  public String getPrefix() {
    return prefix;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepoTable.RepoTableRow#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepoTableRow withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableRepoTableRow(newValue, this.rev, this.prefix, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepoTable.RepoTableRow#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepoTableRow withRev(String value) {
    String newValue = Objects.requireNonNull(value, "rev");
    if (this.rev.equals(newValue)) return this;
    return new ImmutableRepoTableRow(this.id, newValue, this.prefix, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepoTable.RepoTableRow#getPrefix() prefix} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for prefix
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepoTableRow withPrefix(String value) {
    String newValue = Objects.requireNonNull(value, "prefix");
    if (this.prefix.equals(newValue)) return this;
    return new ImmutableRepoTableRow(this.id, this.rev, newValue, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepoTable.RepoTableRow#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepoTableRow withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableRepoTableRow(this.id, this.rev, this.prefix, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRepoTableRow} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRepoTableRow
        && equalTo((ImmutableRepoTableRow) another);
  }

  private boolean equalTo(ImmutableRepoTableRow another) {
    return id.equals(another.id)
        && rev.equals(another.rev)
        && prefix.equals(another.prefix)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code prefix}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + rev.hashCode();
    h += (h << 5) + prefix.hashCode();
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RepoTableRow} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RepoTableRow")
        .omitNullValues()
        .add("id", id)
        .add("rev", rev)
        .add("prefix", prefix)
        .add("name", name)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RepoTable.RepoTableRow", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements RepoTable.RepoTableRow {
    @Nullable String id;
    @Nullable String rev;
    @Nullable String prefix;
    @Nullable String name;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("rev")
    public void setRev(String rev) {
      this.rev = rev;
    }
    @JsonProperty("prefix")
    public void setPrefix(String prefix) {
      this.prefix = prefix;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRev() { throw new UnsupportedOperationException(); }
    @Override
    public String getPrefix() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRepoTableRow fromJson(Json json) {
    ImmutableRepoTableRow.Builder builder = ImmutableRepoTableRow.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.rev != null) {
      builder.rev(json.rev);
    }
    if (json.prefix != null) {
      builder.prefix(json.prefix);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RepoTable.RepoTableRow} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RepoTableRow instance
   */
  public static ImmutableRepoTableRow copyOf(RepoTable.RepoTableRow instance) {
    if (instance instanceof ImmutableRepoTableRow) {
      return (ImmutableRepoTableRow) instance;
    }
    return ImmutableRepoTableRow.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRepoTableRow ImmutableRepoTableRow}.
   * <pre>
   * ImmutableRepoTableRow.builder()
   *    .id(String) // required {@link RepoTable.RepoTableRow#getId() id}
   *    .rev(String) // required {@link RepoTable.RepoTableRow#getRev() rev}
   *    .prefix(String) // required {@link RepoTable.RepoTableRow#getPrefix() prefix}
   *    .name(String) // required {@link RepoTable.RepoTableRow#getName() name}
   *    .build();
   * </pre>
   * @return A new ImmutableRepoTableRow builder
   */
  public static ImmutableRepoTableRow.Builder builder() {
    return new ImmutableRepoTableRow.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRepoTableRow ImmutableRepoTableRow}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RepoTable.RepoTableRow", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_REV = 0x2L;
    private static final long INIT_BIT_PREFIX = 0x4L;
    private static final long INIT_BIT_NAME = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String rev;
    private @Nullable String prefix;
    private @Nullable String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RepoTableRow} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RepoTable.RepoTableRow instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      rev(instance.getRev());
      prefix(instance.getPrefix());
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link RepoTable.RepoTableRow#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link RepoTable.RepoTableRow#getRev() rev} attribute.
     * @param rev The value for rev 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("rev")
    public final Builder rev(String rev) {
      this.rev = Objects.requireNonNull(rev, "rev");
      initBits &= ~INIT_BIT_REV;
      return this;
    }

    /**
     * Initializes the value for the {@link RepoTable.RepoTableRow#getPrefix() prefix} attribute.
     * @param prefix The value for prefix 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("prefix")
    public final Builder prefix(String prefix) {
      this.prefix = Objects.requireNonNull(prefix, "prefix");
      initBits &= ~INIT_BIT_PREFIX;
      return this;
    }

    /**
     * Initializes the value for the {@link RepoTable.RepoTableRow#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRepoTableRow ImmutableRepoTableRow}.
     * @return An immutable instance of RepoTableRow
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRepoTableRow build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRepoTableRow(id, rev, prefix, name);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_REV) != 0) attributes.add("rev");
      if ((initBits & INIT_BIT_PREFIX) != 0) attributes.add("prefix");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build RepoTableRow, some of required attributes are not set " + attributes;
    }
  }
}
