package io.resys.thena.docdb.file.tables;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RefTable.RefTableRow}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRefTableRow.builder()}.
 */
@Generated(from = "RefTable.RefTableRow", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRefTableRow implements RefTable.RefTableRow {
  private final String name;
  private final String commit;

  private ImmutableRefTableRow(String name, String commit) {
    this.name = name;
    this.commit = commit;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code commit} attribute
   */
  @JsonProperty("commit")
  @Override
  public String getCommit() {
    return commit;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RefTable.RefTableRow#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRefTableRow withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableRefTableRow(newValue, this.commit);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RefTable.RefTableRow#getCommit() commit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRefTableRow withCommit(String value) {
    String newValue = Objects.requireNonNull(value, "commit");
    if (this.commit.equals(newValue)) return this;
    return new ImmutableRefTableRow(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRefTableRow} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRefTableRow
        && equalTo((ImmutableRefTableRow) another);
  }

  private boolean equalTo(ImmutableRefTableRow another) {
    return name.equals(another.name)
        && commit.equals(another.commit);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code commit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + commit.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RefTableRow} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RefTableRow")
        .omitNullValues()
        .add("name", name)
        .add("commit", commit)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RefTable.RefTableRow", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements RefTable.RefTableRow {
    @Nullable String name;
    @Nullable String commit;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("commit")
    public void setCommit(String commit) {
      this.commit = commit;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getCommit() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRefTableRow fromJson(Json json) {
    ImmutableRefTableRow.Builder builder = ImmutableRefTableRow.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.commit != null) {
      builder.commit(json.commit);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RefTable.RefTableRow} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RefTableRow instance
   */
  public static ImmutableRefTableRow copyOf(RefTable.RefTableRow instance) {
    if (instance instanceof ImmutableRefTableRow) {
      return (ImmutableRefTableRow) instance;
    }
    return ImmutableRefTableRow.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRefTableRow ImmutableRefTableRow}.
   * <pre>
   * ImmutableRefTableRow.builder()
   *    .name(String) // required {@link RefTable.RefTableRow#getName() name}
   *    .commit(String) // required {@link RefTable.RefTableRow#getCommit() commit}
   *    .build();
   * </pre>
   * @return A new ImmutableRefTableRow builder
   */
  public static ImmutableRefTableRow.Builder builder() {
    return new ImmutableRefTableRow.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRefTableRow ImmutableRefTableRow}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RefTable.RefTableRow", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_COMMIT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private @Nullable String commit;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RefTableRow} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RefTable.RefTableRow instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      commit(instance.getCommit());
      return this;
    }

    /**
     * Initializes the value for the {@link RefTable.RefTableRow#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link RefTable.RefTableRow#getCommit() commit} attribute.
     * @param commit The value for commit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("commit")
    public final Builder commit(String commit) {
      this.commit = Objects.requireNonNull(commit, "commit");
      initBits &= ~INIT_BIT_COMMIT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRefTableRow ImmutableRefTableRow}.
     * @return An immutable instance of RefTableRow
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRefTableRow build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRefTableRow(name, commit);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_COMMIT) != 0) attributes.add("commit");
      return "Cannot build RefTableRow, some of required attributes are not set " + attributes;
    }
  }
}
