package io.resys.thena.docdb.file.tables;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Table.FileTupleList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFileTupleList.builder()}.
 */
@Generated(from = "Table.FileTupleList", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFileTupleList implements Table.FileTupleList {
  private final String value;
  private final Function<Table.Connection, List<? extends Table.Row>> command;
  private final ImmutableList<Tuple> props;

  private ImmutableFileTupleList(
      String value,
      Function<Table.Connection, List<? extends Table.Row>> command,
      ImmutableList<Tuple> props) {
    this.value = value;
    this.command = command;
    this.props = props;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code command} attribute
   */
  @Override
  public Function<Table.Connection, List<? extends Table.Row>> getCommand() {
    return command;
  }

  /**
   * @return The value of the {@code props} attribute
   */
  @Override
  public ImmutableList<Tuple> getProps() {
    return props;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table.FileTupleList#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileTupleList withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableFileTupleList(newValue, this.command, this.props);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table.FileTupleList#getCommand() command} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for command
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileTupleList withCommand(Function<Table.Connection, List<? extends Table.Row>> value) {
    if (this.command == value) return this;
    Function<Table.Connection, List<? extends Table.Row>> newValue = Objects.requireNonNull(value, "command");
    return new ImmutableFileTupleList(this.value, newValue, this.props);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Table.FileTupleList#getProps() props}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFileTupleList withProps(Tuple... elements) {
    ImmutableList<Tuple> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFileTupleList(this.value, this.command, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Table.FileTupleList#getProps() props}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of props elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFileTupleList withProps(Iterable<? extends Tuple> elements) {
    if (this.props == elements) return this;
    ImmutableList<Tuple> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFileTupleList(this.value, this.command, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFileTupleList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFileTupleList
        && equalTo((ImmutableFileTupleList) another);
  }

  private boolean equalTo(ImmutableFileTupleList another) {
    return value.equals(another.value)
        && command.equals(another.command)
        && props.equals(another.props);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code command}, {@code props}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    h += (h << 5) + command.hashCode();
    h += (h << 5) + props.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FileTupleList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FileTupleList")
        .omitNullValues()
        .add("value", value)
        .add("command", command)
        .add("props", props)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Table.FileTupleList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FileTupleList instance
   */
  public static ImmutableFileTupleList copyOf(Table.FileTupleList instance) {
    if (instance instanceof ImmutableFileTupleList) {
      return (ImmutableFileTupleList) instance;
    }
    return ImmutableFileTupleList.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFileTupleList ImmutableFileTupleList}.
   * <pre>
   * ImmutableFileTupleList.builder()
   *    .value(String) // required {@link Table.FileTupleList#getValue() value}
   *    .command(function.Function&amp;lt;io.resys.thena.docdb.file.tables.Table.Connection, List&amp;lt;? extends io.resys.thena.docdb.file.tables.Table.Row&amp;gt;&amp;gt;) // required {@link Table.FileTupleList#getCommand() command}
   *    .addProps|addAllProps(io.vertx.mutiny.sqlclient.Tuple) // {@link Table.FileTupleList#getProps() props} elements
   *    .build();
   * </pre>
   * @return A new ImmutableFileTupleList builder
   */
  public static ImmutableFileTupleList.Builder builder() {
    return new ImmutableFileTupleList.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFileTupleList ImmutableFileTupleList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Table.FileTupleList", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private static final long INIT_BIT_COMMAND = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String value;
    private @Nullable Function<Table.Connection, List<? extends Table.Row>> command;
    private ImmutableList.Builder<Tuple> props = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.thena.docdb.file.tables.Table.FileCommand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Table.FileCommand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.thena.docdb.file.tables.Table.FileTupleList} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Table.FileTupleList instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Table.FileCommand) {
        Table.FileCommand instance = (Table.FileCommand) object;
        value(instance.getValue());
        command(instance.getCommand());
      }
      if (object instanceof Table.FileTupleList) {
        Table.FileTupleList instance = (Table.FileTupleList) object;
        addAllProps(instance.getProps());
      }
    }

    /**
     * Initializes the value for the {@link Table.FileTupleList#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link Table.FileTupleList#getCommand() command} attribute.
     * @param command The value for command 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder command(Function<Table.Connection, List<? extends Table.Row>> command) {
      this.command = Objects.requireNonNull(command, "command");
      initBits &= ~INIT_BIT_COMMAND;
      return this;
    }

    /**
     * Adds one element to {@link Table.FileTupleList#getProps() props} list.
     * @param element A props element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addProps(Tuple element) {
      this.props.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Table.FileTupleList#getProps() props} list.
     * @param elements An array of props elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addProps(Tuple... elements) {
      this.props.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Table.FileTupleList#getProps() props} list.
     * @param elements An iterable of props elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder props(Iterable<? extends Tuple> elements) {
      this.props = ImmutableList.builder();
      return addAllProps(elements);
    }

    /**
     * Adds elements to {@link Table.FileTupleList#getProps() props} list.
     * @param elements An iterable of props elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllProps(Iterable<? extends Tuple> elements) {
      this.props.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableFileTupleList ImmutableFileTupleList}.
     * @return An immutable instance of FileTupleList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFileTupleList build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFileTupleList(value, command, props.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_COMMAND) != 0) attributes.add("command");
      return "Cannot build FileTupleList, some of required attributes are not set " + attributes;
    }
  }
}
