package io.resys.thena.docdb.file.tables;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Table.FileTuple}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFileTuple.builder()}.
 */
@Generated(from = "Table.FileTuple", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFileTuple implements Table.FileTuple {
  private final String value;
  private final Function<Table.Connection, List<? extends Table.Row>> command;
  private final Tuple props;

  private ImmutableFileTuple(
      String value,
      Function<Table.Connection, List<? extends Table.Row>> command,
      Tuple props) {
    this.value = value;
    this.command = command;
    this.props = props;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code command} attribute
   */
  @Override
  public Function<Table.Connection, List<? extends Table.Row>> getCommand() {
    return command;
  }

  /**
   * @return The value of the {@code props} attribute
   */
  @Override
  public Tuple getProps() {
    return props;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table.FileTuple#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileTuple withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableFileTuple(newValue, this.command, this.props);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table.FileTuple#getCommand() command} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for command
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileTuple withCommand(Function<Table.Connection, List<? extends Table.Row>> value) {
    if (this.command == value) return this;
    Function<Table.Connection, List<? extends Table.Row>> newValue = Objects.requireNonNull(value, "command");
    return new ImmutableFileTuple(this.value, newValue, this.props);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table.FileTuple#getProps() props} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for props
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileTuple withProps(Tuple value) {
    if (this.props == value) return this;
    Tuple newValue = Objects.requireNonNull(value, "props");
    return new ImmutableFileTuple(this.value, this.command, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFileTuple} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFileTuple
        && equalTo((ImmutableFileTuple) another);
  }

  private boolean equalTo(ImmutableFileTuple another) {
    return value.equals(another.value)
        && command.equals(another.command)
        && props.equals(another.props);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code command}, {@code props}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    h += (h << 5) + command.hashCode();
    h += (h << 5) + props.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FileTuple} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FileTuple")
        .omitNullValues()
        .add("value", value)
        .add("command", command)
        .add("props", props)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Table.FileTuple} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FileTuple instance
   */
  public static ImmutableFileTuple copyOf(Table.FileTuple instance) {
    if (instance instanceof ImmutableFileTuple) {
      return (ImmutableFileTuple) instance;
    }
    return ImmutableFileTuple.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFileTuple ImmutableFileTuple}.
   * <pre>
   * ImmutableFileTuple.builder()
   *    .value(String) // required {@link Table.FileTuple#getValue() value}
   *    .command(function.Function&amp;lt;io.resys.thena.docdb.file.tables.Table.Connection, List&amp;lt;? extends io.resys.thena.docdb.file.tables.Table.Row&amp;gt;&amp;gt;) // required {@link Table.FileTuple#getCommand() command}
   *    .props(io.vertx.mutiny.sqlclient.Tuple) // required {@link Table.FileTuple#getProps() props}
   *    .build();
   * </pre>
   * @return A new ImmutableFileTuple builder
   */
  public static ImmutableFileTuple.Builder builder() {
    return new ImmutableFileTuple.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFileTuple ImmutableFileTuple}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Table.FileTuple", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private static final long INIT_BIT_COMMAND = 0x2L;
    private static final long INIT_BIT_PROPS = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String value;
    private @Nullable Function<Table.Connection, List<? extends Table.Row>> command;
    private @Nullable Tuple props;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.thena.docdb.file.tables.Table.FileCommand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Table.FileCommand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.thena.docdb.file.tables.Table.FileTuple} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Table.FileTuple instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Table.FileCommand) {
        Table.FileCommand instance = (Table.FileCommand) object;
        value(instance.getValue());
        command(instance.getCommand());
      }
      if (object instanceof Table.FileTuple) {
        Table.FileTuple instance = (Table.FileTuple) object;
        props(instance.getProps());
      }
    }

    /**
     * Initializes the value for the {@link Table.FileTuple#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link Table.FileTuple#getCommand() command} attribute.
     * @param command The value for command 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder command(Function<Table.Connection, List<? extends Table.Row>> command) {
      this.command = Objects.requireNonNull(command, "command");
      initBits &= ~INIT_BIT_COMMAND;
      return this;
    }

    /**
     * Initializes the value for the {@link Table.FileTuple#getProps() props} attribute.
     * @param props The value for props 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder props(Tuple props) {
      this.props = Objects.requireNonNull(props, "props");
      initBits &= ~INIT_BIT_PROPS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFileTuple ImmutableFileTuple}.
     * @return An immutable instance of FileTuple
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFileTuple build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFileTuple(value, command, props);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_COMMAND) != 0) attributes.add("command");
      if ((initBits & INIT_BIT_PROPS) != 0) attributes.add("props");
      return "Cannot build FileTuple, some of required attributes are not set " + attributes;
    }
  }
}
