package io.resys.thena.docdb.file.tables;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Table.FileStatement}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFileStatement.builder()}.
 */
@Generated(from = "Table.FileStatement", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFileStatement implements Table.FileStatement {
  private final String value;
  private final Function<Table.Connection, List<? extends Table.Row>> command;

  private ImmutableFileStatement(
      String value,
      Function<Table.Connection, List<? extends Table.Row>> command) {
    this.value = value;
    this.command = command;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code command} attribute
   */
  @Override
  public Function<Table.Connection, List<? extends Table.Row>> getCommand() {
    return command;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table.FileStatement#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileStatement withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableFileStatement(newValue, this.command);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table.FileStatement#getCommand() command} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for command
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileStatement withCommand(Function<Table.Connection, List<? extends Table.Row>> value) {
    if (this.command == value) return this;
    Function<Table.Connection, List<? extends Table.Row>> newValue = Objects.requireNonNull(value, "command");
    return new ImmutableFileStatement(this.value, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFileStatement} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFileStatement
        && equalTo((ImmutableFileStatement) another);
  }

  private boolean equalTo(ImmutableFileStatement another) {
    return value.equals(another.value)
        && command.equals(another.command);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code command}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    h += (h << 5) + command.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FileStatement} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FileStatement")
        .omitNullValues()
        .add("value", value)
        .add("command", command)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Table.FileStatement} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FileStatement instance
   */
  public static ImmutableFileStatement copyOf(Table.FileStatement instance) {
    if (instance instanceof ImmutableFileStatement) {
      return (ImmutableFileStatement) instance;
    }
    return ImmutableFileStatement.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFileStatement ImmutableFileStatement}.
   * <pre>
   * ImmutableFileStatement.builder()
   *    .value(String) // required {@link Table.FileStatement#getValue() value}
   *    .command(function.Function&amp;lt;io.resys.thena.docdb.file.tables.Table.Connection, List&amp;lt;? extends io.resys.thena.docdb.file.tables.Table.Row&amp;gt;&amp;gt;) // required {@link Table.FileStatement#getCommand() command}
   *    .build();
   * </pre>
   * @return A new ImmutableFileStatement builder
   */
  public static ImmutableFileStatement.Builder builder() {
    return new ImmutableFileStatement.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFileStatement ImmutableFileStatement}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Table.FileStatement", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private static final long INIT_BIT_COMMAND = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String value;
    private @Nullable Function<Table.Connection, List<? extends Table.Row>> command;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.thena.docdb.file.tables.Table.FileCommand} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Table.FileCommand instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.thena.docdb.file.tables.Table.FileStatement} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Table.FileStatement instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Table.FileCommand) {
        Table.FileCommand instance = (Table.FileCommand) object;
        value(instance.getValue());
        command(instance.getCommand());
      }
    }

    /**
     * Initializes the value for the {@link Table.FileStatement#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link Table.FileStatement#getCommand() command} attribute.
     * @param command The value for command 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder command(Function<Table.Connection, List<? extends Table.Row>> command) {
      this.command = Objects.requireNonNull(command, "command");
      initBits &= ~INIT_BIT_COMMAND;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFileStatement ImmutableFileStatement}.
     * @return An immutable instance of FileStatement
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFileStatement build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFileStatement(value, command);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_COMMAND) != 0) attributes.add("command");
      return "Cannot build FileStatement, some of required attributes are not set " + attributes;
    }
  }
}
