package io.resys.thena.docdb.file.tables;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.docdb.api.models.Repo;
import io.resys.thena.docdb.spi.ClientCollections;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Table.FileClientWrapper}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFileClientWrapper.builder()}.
 */
@Generated(from = "Table.FileClientWrapper", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFileClientWrapper
    implements Table.FileClientWrapper {
  private final Repo repo;
  private final Table.FilePool client;
  private final ClientCollections names;

  private ImmutableFileClientWrapper(
      Repo repo,
      Table.FilePool client,
      ClientCollections names) {
    this.repo = repo;
    this.client = client;
    this.names = names;
  }

  /**
   * @return The value of the {@code repo} attribute
   */
  @Override
  public Repo getRepo() {
    return repo;
  }

  /**
   * @return The value of the {@code client} attribute
   */
  @Override
  public Table.FilePool getClient() {
    return client;
  }

  /**
   * @return The value of the {@code names} attribute
   */
  @Override
  public ClientCollections getNames() {
    return names;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table.FileClientWrapper#getRepo() repo} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repo
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileClientWrapper withRepo(Repo value) {
    if (this.repo == value) return this;
    Repo newValue = Objects.requireNonNull(value, "repo");
    return new ImmutableFileClientWrapper(newValue, this.client, this.names);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table.FileClientWrapper#getClient() client} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for client
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileClientWrapper withClient(Table.FilePool value) {
    if (this.client == value) return this;
    Table.FilePool newValue = Objects.requireNonNull(value, "client");
    return new ImmutableFileClientWrapper(this.repo, newValue, this.names);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table.FileClientWrapper#getNames() names} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for names
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFileClientWrapper withNames(ClientCollections value) {
    if (this.names == value) return this;
    ClientCollections newValue = Objects.requireNonNull(value, "names");
    return new ImmutableFileClientWrapper(this.repo, this.client, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFileClientWrapper} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFileClientWrapper
        && equalTo((ImmutableFileClientWrapper) another);
  }

  private boolean equalTo(ImmutableFileClientWrapper another) {
    return repo.equals(another.repo)
        && client.equals(another.client)
        && names.equals(another.names);
  }

  /**
   * Computes a hash code from attributes: {@code repo}, {@code client}, {@code names}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + repo.hashCode();
    h += (h << 5) + client.hashCode();
    h += (h << 5) + names.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FileClientWrapper} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FileClientWrapper")
        .omitNullValues()
        .add("repo", repo)
        .add("client", client)
        .add("names", names)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Table.FileClientWrapper} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FileClientWrapper instance
   */
  public static ImmutableFileClientWrapper copyOf(Table.FileClientWrapper instance) {
    if (instance instanceof ImmutableFileClientWrapper) {
      return (ImmutableFileClientWrapper) instance;
    }
    return ImmutableFileClientWrapper.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFileClientWrapper ImmutableFileClientWrapper}.
   * <pre>
   * ImmutableFileClientWrapper.builder()
   *    .repo(io.resys.thena.docdb.api.models.Repo) // required {@link Table.FileClientWrapper#getRepo() repo}
   *    .client(io.resys.thena.docdb.file.tables.Table.FilePool) // required {@link Table.FileClientWrapper#getClient() client}
   *    .names(io.resys.thena.docdb.spi.ClientCollections) // required {@link Table.FileClientWrapper#getNames() names}
   *    .build();
   * </pre>
   * @return A new ImmutableFileClientWrapper builder
   */
  public static ImmutableFileClientWrapper.Builder builder() {
    return new ImmutableFileClientWrapper.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFileClientWrapper ImmutableFileClientWrapper}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Table.FileClientWrapper", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_REPO = 0x1L;
    private static final long INIT_BIT_CLIENT = 0x2L;
    private static final long INIT_BIT_NAMES = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Repo repo;
    private @Nullable Table.FilePool client;
    private @Nullable ClientCollections names;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FileClientWrapper} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Table.FileClientWrapper instance) {
      Objects.requireNonNull(instance, "instance");
      repo(instance.getRepo());
      client(instance.getClient());
      names(instance.getNames());
      return this;
    }

    /**
     * Initializes the value for the {@link Table.FileClientWrapper#getRepo() repo} attribute.
     * @param repo The value for repo 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repo(Repo repo) {
      this.repo = Objects.requireNonNull(repo, "repo");
      initBits &= ~INIT_BIT_REPO;
      return this;
    }

    /**
     * Initializes the value for the {@link Table.FileClientWrapper#getClient() client} attribute.
     * @param client The value for client 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder client(Table.FilePool client) {
      this.client = Objects.requireNonNull(client, "client");
      initBits &= ~INIT_BIT_CLIENT;
      return this;
    }

    /**
     * Initializes the value for the {@link Table.FileClientWrapper#getNames() names} attribute.
     * @param names The value for names 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder names(ClientCollections names) {
      this.names = Objects.requireNonNull(names, "names");
      initBits &= ~INIT_BIT_NAMES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFileClientWrapper ImmutableFileClientWrapper}.
     * @return An immutable instance of FileClientWrapper
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFileClientWrapper build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFileClientWrapper(repo, client, names);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REPO) != 0) attributes.add("repo");
      if ((initBits & INIT_BIT_CLIENT) != 0) attributes.add("client");
      if ((initBits & INIT_BIT_NAMES) != 0) attributes.add("names");
      return "Cannot build FileClientWrapper, some of required attributes are not set " + attributes;
    }
  }
}
