package io.resys.thena.docdb.file.tables;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BlobTable.BlobTableRow}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBlobTableRow.builder()}.
 */
@Generated(from = "BlobTable.BlobTableRow", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBlobTableRow implements BlobTable.BlobTableRow {
  private final String id;
  private final String value;

  private ImmutableBlobTableRow(String id, String value) {
    this.id = id;
    this.value = value;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlobTable.BlobTableRow#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlobTableRow withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableBlobTableRow(newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BlobTable.BlobTableRow#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlobTableRow withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableBlobTableRow(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBlobTableRow} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBlobTableRow
        && equalTo((ImmutableBlobTableRow) another);
  }

  private boolean equalTo(ImmutableBlobTableRow another) {
    return id.equals(another.id)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BlobTableRow} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("BlobTableRow")
        .omitNullValues()
        .add("id", id)
        .add("value", value)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "BlobTable.BlobTableRow", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements BlobTable.BlobTableRow {
    @Nullable String id;
    @Nullable String value;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableBlobTableRow fromJson(Json json) {
    ImmutableBlobTableRow.Builder builder = ImmutableBlobTableRow.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link BlobTable.BlobTableRow} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BlobTableRow instance
   */
  public static ImmutableBlobTableRow copyOf(BlobTable.BlobTableRow instance) {
    if (instance instanceof ImmutableBlobTableRow) {
      return (ImmutableBlobTableRow) instance;
    }
    return ImmutableBlobTableRow.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBlobTableRow ImmutableBlobTableRow}.
   * <pre>
   * ImmutableBlobTableRow.builder()
   *    .id(String) // required {@link BlobTable.BlobTableRow#getId() id}
   *    .value(String) // required {@link BlobTable.BlobTableRow#getValue() value}
   *    .build();
   * </pre>
   * @return A new ImmutableBlobTableRow builder
   */
  public static ImmutableBlobTableRow.Builder builder() {
    return new ImmutableBlobTableRow.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBlobTableRow ImmutableBlobTableRow}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BlobTable.BlobTableRow", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BlobTableRow} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BlobTable.BlobTableRow instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      value(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link BlobTable.BlobTableRow#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link BlobTable.BlobTableRow#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBlobTableRow ImmutableBlobTableRow}.
     * @return An immutable instance of BlobTableRow
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBlobTableRow build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBlobTableRow(id, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build BlobTableRow, some of required attributes are not set " + attributes;
    }
  }
}
