package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Objects.TreeValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTreeValue.builder()}.
 */
@Generated(from = "Objects.TreeValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTreeValue implements Objects.TreeValue {
  private final String name;
  private final String blob;

  private ImmutableTreeValue(String name, String blob) {
    this.name = name;
    this.blob = blob;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code blob} attribute
   */
  @Override
  public String getBlob() {
    return blob;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.TreeValue#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTreeValue withName(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableTreeValue(newValue, this.blob);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.TreeValue#getBlob() blob} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for blob
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTreeValue withBlob(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "blob");
    if (this.blob.equals(newValue)) return this;
    return new ImmutableTreeValue(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTreeValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTreeValue
        && equalTo((ImmutableTreeValue) another);
  }

  private boolean equalTo(ImmutableTreeValue another) {
    return name.equals(another.name)
        && blob.equals(another.blob);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code blob}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + blob.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TreeValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TreeValue")
        .omitNullValues()
        .add("name", name)
        .add("blob", blob)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Objects.TreeValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TreeValue instance
   */
  public static ImmutableTreeValue copyOf(Objects.TreeValue instance) {
    if (instance instanceof ImmutableTreeValue) {
      return (ImmutableTreeValue) instance;
    }
    return ImmutableTreeValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTreeValue ImmutableTreeValue}.
   * <pre>
   * ImmutableTreeValue.builder()
   *    .name(String) // required {@link Objects.TreeValue#getName() name}
   *    .blob(String) // required {@link Objects.TreeValue#getBlob() blob}
   *    .build();
   * </pre>
   * @return A new ImmutableTreeValue builder
   */
  public static ImmutableTreeValue.Builder builder() {
    return new ImmutableTreeValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTreeValue ImmutableTreeValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Objects.TreeValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_BLOB = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private @Nullable String blob;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TreeValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Objects.TreeValue instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      blob(instance.getBlob());
      return this;
    }

    /**
     * Initializes the value for the {@link Objects.TreeValue#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = java.util.Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Objects.TreeValue#getBlob() blob} attribute.
     * @param blob The value for blob 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blob(String blob) {
      this.blob = java.util.Objects.requireNonNull(blob, "blob");
      initBits &= ~INIT_BIT_BLOB;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTreeValue ImmutableTreeValue}.
     * @return An immutable instance of TreeValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTreeValue build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTreeValue(name, blob);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_BLOB) != 0) attributes.add("blob");
      return "Cannot build TreeValue, some of required attributes are not set " + attributes;
    }
  }
}
