package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Objects.Tag}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTag.builder()}.
 */
@Generated(from = "Objects.Tag", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTag implements Objects.Tag {
  private final String name;
  private final String commit;
  private final LocalDateTime dateTime;
  private final String author;
  private final String message;

  private ImmutableTag(
      String name,
      String commit,
      LocalDateTime dateTime,
      String author,
      String message) {
    this.name = name;
    this.commit = commit;
    this.dateTime = dateTime;
    this.author = author;
    this.message = message;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code commit} attribute
   */
  @Override
  public String getCommit() {
    return commit;
  }

  /**
   * @return The value of the {@code dateTime} attribute
   */
  @Override
  public LocalDateTime getDateTime() {
    return dateTime;
  }

  /**
   * @return The value of the {@code author} attribute
   */
  @Override
  public String getAuthor() {
    return author;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @Override
  public String getMessage() {
    return message;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.Tag#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTag withName(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableTag(newValue, this.commit, this.dateTime, this.author, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.Tag#getCommit() commit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTag withCommit(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "commit");
    if (this.commit.equals(newValue)) return this;
    return new ImmutableTag(this.name, newValue, this.dateTime, this.author, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.Tag#getDateTime() dateTime} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dateTime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTag withDateTime(LocalDateTime value) {
    if (this.dateTime == value) return this;
    LocalDateTime newValue = java.util.Objects.requireNonNull(value, "dateTime");
    return new ImmutableTag(this.name, this.commit, newValue, this.author, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.Tag#getAuthor() author} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for author
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTag withAuthor(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "author");
    if (this.author.equals(newValue)) return this;
    return new ImmutableTag(this.name, this.commit, this.dateTime, newValue, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.Tag#getMessage() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTag withMessage(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "message");
    if (this.message.equals(newValue)) return this;
    return new ImmutableTag(this.name, this.commit, this.dateTime, this.author, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTag} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTag
        && equalTo((ImmutableTag) another);
  }

  private boolean equalTo(ImmutableTag another) {
    return name.equals(another.name)
        && commit.equals(another.commit)
        && dateTime.equals(another.dateTime)
        && author.equals(another.author)
        && message.equals(another.message);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code commit}, {@code dateTime}, {@code author}, {@code message}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + commit.hashCode();
    h += (h << 5) + dateTime.hashCode();
    h += (h << 5) + author.hashCode();
    h += (h << 5) + message.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Tag} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Tag")
        .omitNullValues()
        .add("name", name)
        .add("commit", commit)
        .add("dateTime", dateTime)
        .add("author", author)
        .add("message", message)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Objects.Tag} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Tag instance
   */
  public static ImmutableTag copyOf(Objects.Tag instance) {
    if (instance instanceof ImmutableTag) {
      return (ImmutableTag) instance;
    }
    return ImmutableTag.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTag ImmutableTag}.
   * <pre>
   * ImmutableTag.builder()
   *    .name(String) // required {@link Objects.Tag#getName() name}
   *    .commit(String) // required {@link Objects.Tag#getCommit() commit}
   *    .dateTime(java.time.LocalDateTime) // required {@link Objects.Tag#getDateTime() dateTime}
   *    .author(String) // required {@link Objects.Tag#getAuthor() author}
   *    .message(String) // required {@link Objects.Tag#getMessage() message}
   *    .build();
   * </pre>
   * @return A new ImmutableTag builder
   */
  public static ImmutableTag.Builder builder() {
    return new ImmutableTag.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTag ImmutableTag}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Objects.Tag", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_COMMIT = 0x2L;
    private static final long INIT_BIT_DATE_TIME = 0x4L;
    private static final long INIT_BIT_AUTHOR = 0x8L;
    private static final long INIT_BIT_MESSAGE = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String name;
    private @Nullable String commit;
    private @Nullable LocalDateTime dateTime;
    private @Nullable String author;
    private @Nullable String message;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.thena.docdb.api.models.Objects.IsName} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Objects.IsName instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.thena.docdb.api.models.Objects.Tag} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Objects.Tag instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Objects.IsName) {
        Objects.IsName instance = (Objects.IsName) object;
        name(instance.getName());
      }
      if (object instanceof Objects.Tag) {
        Objects.Tag instance = (Objects.Tag) object;
        dateTime(instance.getDateTime());
        commit(instance.getCommit());
        message(instance.getMessage());
        author(instance.getAuthor());
      }
    }

    /**
     * Initializes the value for the {@link Objects.Tag#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = java.util.Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Objects.Tag#getCommit() commit} attribute.
     * @param commit The value for commit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commit(String commit) {
      this.commit = java.util.Objects.requireNonNull(commit, "commit");
      initBits &= ~INIT_BIT_COMMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link Objects.Tag#getDateTime() dateTime} attribute.
     * @param dateTime The value for dateTime 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder dateTime(LocalDateTime dateTime) {
      this.dateTime = java.util.Objects.requireNonNull(dateTime, "dateTime");
      initBits &= ~INIT_BIT_DATE_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link Objects.Tag#getAuthor() author} attribute.
     * @param author The value for author 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder author(String author) {
      this.author = java.util.Objects.requireNonNull(author, "author");
      initBits &= ~INIT_BIT_AUTHOR;
      return this;
    }

    /**
     * Initializes the value for the {@link Objects.Tag#getMessage() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder message(String message) {
      this.message = java.util.Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTag ImmutableTag}.
     * @return An immutable instance of Tag
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTag build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTag(name, commit, dateTime, author, message);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_COMMIT) != 0) attributes.add("commit");
      if ((initBits & INIT_BIT_DATE_TIME) != 0) attributes.add("dateTime");
      if ((initBits & INIT_BIT_AUTHOR) != 0) attributes.add("author");
      if ((initBits & INIT_BIT_MESSAGE) != 0) attributes.add("message");
      return "Cannot build Tag, some of required attributes are not set " + attributes;
    }
  }
}
