package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Repo.RepoHeadState}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRepoHeadState.builder()}.
 */
@Generated(from = "Repo.RepoHeadState", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRepoHeadState implements Repo.RepoHeadState {
  private final String gid;
  private final String repoId;
  private final String headName;
  private final String commit;
  private final Repo.HeadStateKind kind;

  private ImmutableRepoHeadState(
      String gid,
      String repoId,
      String headName,
      String commit,
      Repo.HeadStateKind kind) {
    this.gid = gid;
    this.repoId = repoId;
    this.headName = headName;
    this.commit = commit;
    this.kind = kind;
  }

  /**
   * @return The value of the {@code gid} attribute
   */
  @Override
  public String getGid() {
    return gid;
  }

  /**
   * @return The value of the {@code repoId} attribute
   */
  @Override
  public String getRepoId() {
    return repoId;
  }

  /**
   * @return The value of the {@code headName} attribute
   */
  @Override
  public String getHeadName() {
    return headName;
  }

  /**
   * @return The value of the {@code commit} attribute
   */
  @Override
  public String getCommit() {
    return commit;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @Override
  public Repo.HeadStateKind getKind() {
    return kind;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Repo.RepoHeadState#getGid() gid} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gid
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepoHeadState withGid(String value) {
    String newValue = Objects.requireNonNull(value, "gid");
    if (this.gid.equals(newValue)) return this;
    return new ImmutableRepoHeadState(newValue, this.repoId, this.headName, this.commit, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Repo.RepoHeadState#getRepoId() repoId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repoId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepoHeadState withRepoId(String value) {
    String newValue = Objects.requireNonNull(value, "repoId");
    if (this.repoId.equals(newValue)) return this;
    return new ImmutableRepoHeadState(this.gid, newValue, this.headName, this.commit, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Repo.RepoHeadState#getHeadName() headName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for headName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepoHeadState withHeadName(String value) {
    String newValue = Objects.requireNonNull(value, "headName");
    if (this.headName.equals(newValue)) return this;
    return new ImmutableRepoHeadState(this.gid, this.repoId, newValue, this.commit, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Repo.RepoHeadState#getCommit() commit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepoHeadState withCommit(String value) {
    String newValue = Objects.requireNonNull(value, "commit");
    if (this.commit.equals(newValue)) return this;
    return new ImmutableRepoHeadState(this.gid, this.repoId, this.headName, newValue, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Repo.RepoHeadState#getKind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepoHeadState withKind(Repo.HeadStateKind value) {
    if (this.kind == value) return this;
    Repo.HeadStateKind newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutableRepoHeadState(this.gid, this.repoId, this.headName, this.commit, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRepoHeadState} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRepoHeadState
        && equalTo((ImmutableRepoHeadState) another);
  }

  private boolean equalTo(ImmutableRepoHeadState another) {
    return gid.equals(another.gid)
        && repoId.equals(another.repoId)
        && headName.equals(another.headName)
        && commit.equals(another.commit)
        && kind.equals(another.kind);
  }

  /**
   * Computes a hash code from attributes: {@code gid}, {@code repoId}, {@code headName}, {@code commit}, {@code kind}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + gid.hashCode();
    h += (h << 5) + repoId.hashCode();
    h += (h << 5) + headName.hashCode();
    h += (h << 5) + commit.hashCode();
    h += (h << 5) + kind.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RepoHeadState} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RepoHeadState")
        .omitNullValues()
        .add("gid", gid)
        .add("repoId", repoId)
        .add("headName", headName)
        .add("commit", commit)
        .add("kind", kind)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Repo.RepoHeadState} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RepoHeadState instance
   */
  public static ImmutableRepoHeadState copyOf(Repo.RepoHeadState instance) {
    if (instance instanceof ImmutableRepoHeadState) {
      return (ImmutableRepoHeadState) instance;
    }
    return ImmutableRepoHeadState.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRepoHeadState ImmutableRepoHeadState}.
   * <pre>
   * ImmutableRepoHeadState.builder()
   *    .gid(String) // required {@link Repo.RepoHeadState#getGid() gid}
   *    .repoId(String) // required {@link Repo.RepoHeadState#getRepoId() repoId}
   *    .headName(String) // required {@link Repo.RepoHeadState#getHeadName() headName}
   *    .commit(String) // required {@link Repo.RepoHeadState#getCommit() commit}
   *    .kind(io.resys.thena.docdb.api.models.Repo.HeadStateKind) // required {@link Repo.RepoHeadState#getKind() kind}
   *    .build();
   * </pre>
   * @return A new ImmutableRepoHeadState builder
   */
  public static ImmutableRepoHeadState.Builder builder() {
    return new ImmutableRepoHeadState.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRepoHeadState ImmutableRepoHeadState}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Repo.RepoHeadState", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_GID = 0x1L;
    private static final long INIT_BIT_REPO_ID = 0x2L;
    private static final long INIT_BIT_HEAD_NAME = 0x4L;
    private static final long INIT_BIT_COMMIT = 0x8L;
    private static final long INIT_BIT_KIND = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String gid;
    private @Nullable String repoId;
    private @Nullable String headName;
    private @Nullable String commit;
    private @Nullable Repo.HeadStateKind kind;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RepoHeadState} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Repo.RepoHeadState instance) {
      Objects.requireNonNull(instance, "instance");
      gid(instance.getGid());
      repoId(instance.getRepoId());
      headName(instance.getHeadName());
      commit(instance.getCommit());
      kind(instance.getKind());
      return this;
    }

    /**
     * Initializes the value for the {@link Repo.RepoHeadState#getGid() gid} attribute.
     * @param gid The value for gid 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder gid(String gid) {
      this.gid = Objects.requireNonNull(gid, "gid");
      initBits &= ~INIT_BIT_GID;
      return this;
    }

    /**
     * Initializes the value for the {@link Repo.RepoHeadState#getRepoId() repoId} attribute.
     * @param repoId The value for repoId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repoId(String repoId) {
      this.repoId = Objects.requireNonNull(repoId, "repoId");
      initBits &= ~INIT_BIT_REPO_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Repo.RepoHeadState#getHeadName() headName} attribute.
     * @param headName The value for headName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder headName(String headName) {
      this.headName = Objects.requireNonNull(headName, "headName");
      initBits &= ~INIT_BIT_HEAD_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Repo.RepoHeadState#getCommit() commit} attribute.
     * @param commit The value for commit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commit(String commit) {
      this.commit = Objects.requireNonNull(commit, "commit");
      initBits &= ~INIT_BIT_COMMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link Repo.RepoHeadState#getKind() kind} attribute.
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder kind(Repo.HeadStateKind kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      initBits &= ~INIT_BIT_KIND;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRepoHeadState ImmutableRepoHeadState}.
     * @return An immutable instance of RepoHeadState
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRepoHeadState build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRepoHeadState(gid, repoId, headName, commit, kind);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GID) != 0) attributes.add("gid");
      if ((initBits & INIT_BIT_REPO_ID) != 0) attributes.add("repoId");
      if ((initBits & INIT_BIT_HEAD_NAME) != 0) attributes.add("headName");
      if ((initBits & INIT_BIT_COMMIT) != 0) attributes.add("commit");
      if ((initBits & INIT_BIT_KIND) != 0) attributes.add("kind");
      return "Cannot build RepoHeadState, some of required attributes are not set " + attributes;
    }
  }
}
