package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Repo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRepo.builder()}.
 */
@Generated(from = "Repo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRepo implements Repo {
  private final String id;
  private final String rev;
  private final String prefix;
  private final String name;

  private ImmutableRepo(String id, String rev, String prefix, String name) {
    this.id = id;
    this.rev = rev;
    this.prefix = prefix;
    this.name = name;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @Override
  public String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code prefix} attribute
   */
  @Override
  public String getPrefix() {
    return prefix;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Repo#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepo withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableRepo(newValue, this.rev, this.prefix, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Repo#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepo withRev(String value) {
    String newValue = Objects.requireNonNull(value, "rev");
    if (this.rev.equals(newValue)) return this;
    return new ImmutableRepo(this.id, newValue, this.prefix, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Repo#getPrefix() prefix} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for prefix
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepo withPrefix(String value) {
    String newValue = Objects.requireNonNull(value, "prefix");
    if (this.prefix.equals(newValue)) return this;
    return new ImmutableRepo(this.id, this.rev, newValue, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Repo#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepo withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableRepo(this.id, this.rev, this.prefix, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRepo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRepo
        && equalTo((ImmutableRepo) another);
  }

  private boolean equalTo(ImmutableRepo another) {
    return id.equals(another.id)
        && rev.equals(another.rev)
        && prefix.equals(another.prefix)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code prefix}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + rev.hashCode();
    h += (h << 5) + prefix.hashCode();
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Repo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Repo")
        .omitNullValues()
        .add("id", id)
        .add("rev", rev)
        .add("prefix", prefix)
        .add("name", name)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Repo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Repo instance
   */
  public static ImmutableRepo copyOf(Repo instance) {
    if (instance instanceof ImmutableRepo) {
      return (ImmutableRepo) instance;
    }
    return ImmutableRepo.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRepo ImmutableRepo}.
   * <pre>
   * ImmutableRepo.builder()
   *    .id(String) // required {@link Repo#getId() id}
   *    .rev(String) // required {@link Repo#getRev() rev}
   *    .prefix(String) // required {@link Repo#getPrefix() prefix}
   *    .name(String) // required {@link Repo#getName() name}
   *    .build();
   * </pre>
   * @return A new ImmutableRepo builder
   */
  public static ImmutableRepo.Builder builder() {
    return new ImmutableRepo.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRepo ImmutableRepo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Repo", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_REV = 0x2L;
    private static final long INIT_BIT_PREFIX = 0x4L;
    private static final long INIT_BIT_NAME = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String rev;
    private @Nullable String prefix;
    private @Nullable String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Repo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Repo instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      rev(instance.getRev());
      prefix(instance.getPrefix());
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link Repo#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Repo#getRev() rev} attribute.
     * @param rev The value for rev 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder rev(String rev) {
      this.rev = Objects.requireNonNull(rev, "rev");
      initBits &= ~INIT_BIT_REV;
      return this;
    }

    /**
     * Initializes the value for the {@link Repo#getPrefix() prefix} attribute.
     * @param prefix The value for prefix 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder prefix(String prefix) {
      this.prefix = Objects.requireNonNull(prefix, "prefix");
      initBits &= ~INIT_BIT_PREFIX;
      return this;
    }

    /**
     * Initializes the value for the {@link Repo#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRepo ImmutableRepo}.
     * @return An immutable instance of Repo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRepo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRepo(id, rev, prefix, name);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_REV) != 0) attributes.add("rev");
      if ((initBits & INIT_BIT_PREFIX) != 0) attributes.add("prefix");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Repo, some of required attributes are not set " + attributes;
    }
  }
}
