package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Objects.Ref}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRef.builder()}.
 */
@Generated(from = "Objects.Ref", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRef implements Objects.Ref {
  private final String name;
  private final String commit;

  private ImmutableRef(String name, String commit) {
    this.name = name;
    this.commit = commit;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code commit} attribute
   */
  @Override
  public String getCommit() {
    return commit;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.Ref#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRef withName(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableRef(newValue, this.commit);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Objects.Ref#getCommit() commit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRef withCommit(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "commit");
    if (this.commit.equals(newValue)) return this;
    return new ImmutableRef(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRef} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRef
        && equalTo((ImmutableRef) another);
  }

  private boolean equalTo(ImmutableRef another) {
    return name.equals(another.name)
        && commit.equals(another.commit);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code commit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + commit.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Ref} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Ref")
        .omitNullValues()
        .add("name", name)
        .add("commit", commit)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Objects.Ref} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Ref instance
   */
  public static ImmutableRef copyOf(Objects.Ref instance) {
    if (instance instanceof ImmutableRef) {
      return (ImmutableRef) instance;
    }
    return ImmutableRef.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRef ImmutableRef}.
   * <pre>
   * ImmutableRef.builder()
   *    .name(String) // required {@link Objects.Ref#getName() name}
   *    .commit(String) // required {@link Objects.Ref#getCommit() commit}
   *    .build();
   * </pre>
   * @return A new ImmutableRef builder
   */
  public static ImmutableRef.Builder builder() {
    return new ImmutableRef.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRef ImmutableRef}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Objects.Ref", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_COMMIT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private @Nullable String commit;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.thena.docdb.api.models.Objects.IsName} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Objects.IsName instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.thena.docdb.api.models.Objects.Ref} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Objects.Ref instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Objects.IsName) {
        Objects.IsName instance = (Objects.IsName) object;
        name(instance.getName());
      }
      if (object instanceof Objects.Ref) {
        Objects.Ref instance = (Objects.Ref) object;
        commit(instance.getCommit());
      }
    }

    /**
     * Initializes the value for the {@link Objects.Ref#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = java.util.Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Objects.Ref#getCommit() commit} attribute.
     * @param commit The value for commit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commit(String commit) {
      this.commit = java.util.Objects.requireNonNull(commit, "commit");
      initBits &= ~INIT_BIT_COMMIT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRef ImmutableRef}.
     * @return An immutable instance of Ref
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRef build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRef(name, commit);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_COMMIT) != 0) attributes.add("commit");
      return "Cannot build Ref, some of required attributes are not set " + attributes;
    }
  }
}
