package io.resys.thena.docdb.api.models;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Diff.DiffAction}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDiffAction.builder()}.
 */
@Generated(from = "Diff.DiffAction", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDiffAction implements Diff.DiffAction {
  private final Diff.DiffActionType type;
  private final @Nullable Diff.DiffBlob value;
  private final @Nullable Diff.DiffBlob target;

  private ImmutableDiffAction(
      Diff.DiffActionType type,
      @Nullable Diff.DiffBlob value,
      @Nullable Diff.DiffBlob target) {
    this.type = type;
    this.value = value;
    this.target = target;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public Diff.DiffActionType getType() {
    return type;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public @Nullable Diff.DiffBlob getValue() {
    return value;
  }

  /**
   * @return The value of the {@code target} attribute
   */
  @Override
  public @Nullable Diff.DiffBlob getTarget() {
    return target;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Diff.DiffAction#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiffAction withType(Diff.DiffActionType value) {
    if (this.type == value) return this;
    Diff.DiffActionType newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableDiffAction(newValue, this.value, this.target);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Diff.DiffAction#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiffAction withValue(@Nullable Diff.DiffBlob value) {
    if (this.value == value) return this;
    return new ImmutableDiffAction(this.type, value, this.target);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Diff.DiffAction#getTarget() target} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for target (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDiffAction withTarget(@Nullable Diff.DiffBlob value) {
    if (this.target == value) return this;
    return new ImmutableDiffAction(this.type, this.value, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDiffAction} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDiffAction
        && equalTo((ImmutableDiffAction) another);
  }

  private boolean equalTo(ImmutableDiffAction another) {
    return type.equals(another.type)
        && Objects.equals(value, another.value)
        && Objects.equals(target, another.target);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code value}, {@code target}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(value);
    h += (h << 5) + Objects.hashCode(target);
    return h;
  }

  /**
   * Prints the immutable value {@code DiffAction} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DiffAction")
        .omitNullValues()
        .add("type", type)
        .add("value", value)
        .add("target", target)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Diff.DiffAction} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DiffAction instance
   */
  public static ImmutableDiffAction copyOf(Diff.DiffAction instance) {
    if (instance instanceof ImmutableDiffAction) {
      return (ImmutableDiffAction) instance;
    }
    return ImmutableDiffAction.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDiffAction ImmutableDiffAction}.
   * <pre>
   * ImmutableDiffAction.builder()
   *    .type(io.resys.thena.docdb.api.models.Diff.DiffActionType) // required {@link Diff.DiffAction#getType() type}
   *    .value(io.resys.thena.docdb.api.models.Diff.DiffBlob | null) // nullable {@link Diff.DiffAction#getValue() value}
   *    .target(io.resys.thena.docdb.api.models.Diff.DiffBlob | null) // nullable {@link Diff.DiffAction#getTarget() target}
   *    .build();
   * </pre>
   * @return A new ImmutableDiffAction builder
   */
  public static ImmutableDiffAction.Builder builder() {
    return new ImmutableDiffAction.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDiffAction ImmutableDiffAction}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Diff.DiffAction", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Diff.DiffActionType type;
    private @Nullable Diff.DiffBlob value;
    private @Nullable Diff.DiffBlob target;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DiffAction} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Diff.DiffAction instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.getType());
      @Nullable Diff.DiffBlob valueValue = instance.getValue();
      if (valueValue != null) {
        value(valueValue);
      }
      @Nullable Diff.DiffBlob targetValue = instance.getTarget();
      if (targetValue != null) {
        target(targetValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Diff.DiffAction#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(Diff.DiffActionType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Diff.DiffAction#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(@Nullable Diff.DiffBlob value) {
      this.value = value;
      return this;
    }

    /**
     * Initializes the value for the {@link Diff.DiffAction#getTarget() target} attribute.
     * @param target The value for target (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder target(@Nullable Diff.DiffBlob target) {
      this.target = target;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDiffAction ImmutableDiffAction}.
     * @return An immutable instance of DiffAction
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDiffAction build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDiffAction(type, value, target);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build DiffAction, some of required attributes are not set " + attributes;
    }
  }
}
