package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Repo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RepoActions.RepoResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRepoResult.builder()}.
 */
@Generated(from = "RepoActions.RepoResult", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRepoResult implements RepoActions.RepoResult {
  private final @Nullable Repo repo;
  private final RepoActions.RepoStatus status;
  private final ImmutableList<Message> messages;

  private ImmutableRepoResult(
      @Nullable Repo repo,
      RepoActions.RepoStatus status,
      ImmutableList<Message> messages) {
    this.repo = repo;
    this.status = status;
    this.messages = messages;
  }

  /**
   * @return The value of the {@code repo} attribute
   */
  @Override
  public @Nullable Repo getRepo() {
    return repo;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @Override
  public RepoActions.RepoStatus getStatus() {
    return status;
  }

  /**
   * @return The value of the {@code messages} attribute
   */
  @Override
  public ImmutableList<Message> getMessages() {
    return messages;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepoActions.RepoResult#getRepo() repo} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repo (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepoResult withRepo(@Nullable Repo value) {
    if (this.repo == value) return this;
    return new ImmutableRepoResult(value, this.status, this.messages);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepoActions.RepoResult#getStatus() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepoResult withStatus(RepoActions.RepoStatus value) {
    if (this.status == value) return this;
    RepoActions.RepoStatus newValue = Objects.requireNonNull(value, "status");
    if (this.status.equals(newValue)) return this;
    return new ImmutableRepoResult(this.repo, newValue, this.messages);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RepoActions.RepoResult#getMessages() messages}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepoResult withMessages(Message... elements) {
    ImmutableList<Message> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRepoResult(this.repo, this.status, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RepoActions.RepoResult#getMessages() messages}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of messages elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepoResult withMessages(Iterable<? extends Message> elements) {
    if (this.messages == elements) return this;
    ImmutableList<Message> newValue = ImmutableList.copyOf(elements);
    return new ImmutableRepoResult(this.repo, this.status, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRepoResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRepoResult
        && equalTo((ImmutableRepoResult) another);
  }

  private boolean equalTo(ImmutableRepoResult another) {
    return Objects.equals(repo, another.repo)
        && status.equals(another.status)
        && messages.equals(another.messages);
  }

  /**
   * Computes a hash code from attributes: {@code repo}, {@code status}, {@code messages}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repo);
    h += (h << 5) + status.hashCode();
    h += (h << 5) + messages.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RepoResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RepoResult")
        .omitNullValues()
        .add("repo", repo)
        .add("status", status)
        .add("messages", messages)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link RepoActions.RepoResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RepoResult instance
   */
  public static ImmutableRepoResult copyOf(RepoActions.RepoResult instance) {
    if (instance instanceof ImmutableRepoResult) {
      return (ImmutableRepoResult) instance;
    }
    return ImmutableRepoResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRepoResult ImmutableRepoResult}.
   * <pre>
   * ImmutableRepoResult.builder()
   *    .repo(io.resys.thena.docdb.api.models.Repo | null) // nullable {@link RepoActions.RepoResult#getRepo() repo}
   *    .status(io.resys.thena.docdb.api.actions.RepoActions.RepoStatus) // required {@link RepoActions.RepoResult#getStatus() status}
   *    .addMessages|addAllMessages(io.resys.thena.docdb.api.models.Message) // {@link RepoActions.RepoResult#getMessages() messages} elements
   *    .build();
   * </pre>
   * @return A new ImmutableRepoResult builder
   */
  public static ImmutableRepoResult.Builder builder() {
    return new ImmutableRepoResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRepoResult ImmutableRepoResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RepoActions.RepoResult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_STATUS = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Repo repo;
    private @Nullable RepoActions.RepoStatus status;
    private ImmutableList.Builder<Message> messages = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RepoResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RepoActions.RepoResult instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Repo repoValue = instance.getRepo();
      if (repoValue != null) {
        repo(repoValue);
      }
      status(instance.getStatus());
      addAllMessages(instance.getMessages());
      return this;
    }

    /**
     * Initializes the value for the {@link RepoActions.RepoResult#getRepo() repo} attribute.
     * @param repo The value for repo (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repo(@Nullable Repo repo) {
      this.repo = repo;
      return this;
    }

    /**
     * Initializes the value for the {@link RepoActions.RepoResult#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder status(RepoActions.RepoStatus status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Adds one element to {@link RepoActions.RepoResult#getMessages() messages} list.
     * @param element A messages element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMessages(Message element) {
      this.messages.add(element);
      return this;
    }

    /**
     * Adds elements to {@link RepoActions.RepoResult#getMessages() messages} list.
     * @param elements An array of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMessages(Message... elements) {
      this.messages.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link RepoActions.RepoResult#getMessages() messages} list.
     * @param elements An iterable of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder messages(Iterable<? extends Message> elements) {
      this.messages = ImmutableList.builder();
      return addAllMessages(elements);
    }

    /**
     * Adds elements to {@link RepoActions.RepoResult#getMessages() messages} list.
     * @param elements An iterable of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMessages(Iterable<? extends Message> elements) {
      this.messages.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableRepoResult ImmutableRepoResult}.
     * @return An immutable instance of RepoResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRepoResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRepoResult(repo, status, messages.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build RepoResult, some of required attributes are not set " + attributes;
    }
  }
}
