package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.docdb.api.models.Message;
import io.resys.thena.docdb.api.models.Objects;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CommitActions.CommitResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommitResult.builder()}.
 */
@Generated(from = "CommitActions.CommitResult", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCommitResult
    implements CommitActions.CommitResult {
  private final String gid;
  private final @Nullable Objects.Commit commit;
  private final CommitActions.CommitStatus status;
  private final ImmutableList<Message> messages;

  private ImmutableCommitResult(
      String gid,
      @Nullable Objects.Commit commit,
      CommitActions.CommitStatus status,
      ImmutableList<Message> messages) {
    this.gid = gid;
    this.commit = commit;
    this.status = status;
    this.messages = messages;
  }

  /**
   * @return The value of the {@code gid} attribute
   */
  @Override
  public String getGid() {
    return gid;
  }

  /**
   * @return The value of the {@code commit} attribute
   */
  @Override
  public @Nullable Objects.Commit getCommit() {
    return commit;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @Override
  public CommitActions.CommitStatus getStatus() {
    return status;
  }

  /**
   * @return The value of the {@code messages} attribute
   */
  @Override
  public ImmutableList<Message> getMessages() {
    return messages;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitActions.CommitResult#getGid() gid} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gid
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitResult withGid(String value) {
    String newValue = java.util.Objects.requireNonNull(value, "gid");
    if (this.gid.equals(newValue)) return this;
    return new ImmutableCommitResult(newValue, this.commit, this.status, this.messages);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitActions.CommitResult#getCommit() commit} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitResult withCommit(@Nullable Objects.Commit value) {
    if (this.commit == value) return this;
    return new ImmutableCommitResult(this.gid, value, this.status, this.messages);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitActions.CommitResult#getStatus() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitResult withStatus(CommitActions.CommitStatus value) {
    if (this.status == value) return this;
    CommitActions.CommitStatus newValue = java.util.Objects.requireNonNull(value, "status");
    if (this.status.equals(newValue)) return this;
    return new ImmutableCommitResult(this.gid, this.commit, newValue, this.messages);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitActions.CommitResult#getMessages() messages}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitResult withMessages(Message... elements) {
    ImmutableList<Message> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCommitResult(this.gid, this.commit, this.status, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitActions.CommitResult#getMessages() messages}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of messages elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitResult withMessages(Iterable<? extends Message> elements) {
    if (this.messages == elements) return this;
    ImmutableList<Message> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCommitResult(this.gid, this.commit, this.status, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommitResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommitResult
        && equalTo((ImmutableCommitResult) another);
  }

  private boolean equalTo(ImmutableCommitResult another) {
    return gid.equals(another.gid)
        && java.util.Objects.equals(commit, another.commit)
        && status.equals(another.status)
        && messages.equals(another.messages);
  }

  /**
   * Computes a hash code from attributes: {@code gid}, {@code commit}, {@code status}, {@code messages}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + gid.hashCode();
    h += (h << 5) + java.util.Objects.hashCode(commit);
    h += (h << 5) + status.hashCode();
    h += (h << 5) + messages.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CommitResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CommitResult")
        .omitNullValues()
        .add("gid", gid)
        .add("commit", commit)
        .add("status", status)
        .add("messages", messages)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CommitActions.CommitResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommitResult instance
   */
  public static ImmutableCommitResult copyOf(CommitActions.CommitResult instance) {
    if (instance instanceof ImmutableCommitResult) {
      return (ImmutableCommitResult) instance;
    }
    return ImmutableCommitResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommitResult ImmutableCommitResult}.
   * <pre>
   * ImmutableCommitResult.builder()
   *    .gid(String) // required {@link CommitActions.CommitResult#getGid() gid}
   *    .commit(io.resys.thena.docdb.api.models.Objects.Commit | null) // nullable {@link CommitActions.CommitResult#getCommit() commit}
   *    .status(io.resys.thena.docdb.api.actions.CommitActions.CommitStatus) // required {@link CommitActions.CommitResult#getStatus() status}
   *    .addMessages|addAllMessages(io.resys.thena.docdb.api.models.Message) // {@link CommitActions.CommitResult#getMessages() messages} elements
   *    .build();
   * </pre>
   * @return A new ImmutableCommitResult builder
   */
  public static ImmutableCommitResult.Builder builder() {
    return new ImmutableCommitResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommitResult ImmutableCommitResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CommitActions.CommitResult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_GID = 0x1L;
    private static final long INIT_BIT_STATUS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String gid;
    private @Nullable Objects.Commit commit;
    private @Nullable CommitActions.CommitStatus status;
    private ImmutableList.Builder<Message> messages = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CommitResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CommitActions.CommitResult instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      gid(instance.getGid());
      @Nullable Objects.Commit commitValue = instance.getCommit();
      if (commitValue != null) {
        commit(commitValue);
      }
      status(instance.getStatus());
      addAllMessages(instance.getMessages());
      return this;
    }

    /**
     * Initializes the value for the {@link CommitActions.CommitResult#getGid() gid} attribute.
     * @param gid The value for gid 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder gid(String gid) {
      this.gid = java.util.Objects.requireNonNull(gid, "gid");
      initBits &= ~INIT_BIT_GID;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitActions.CommitResult#getCommit() commit} attribute.
     * @param commit The value for commit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commit(@Nullable Objects.Commit commit) {
      this.commit = commit;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitActions.CommitResult#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder status(CommitActions.CommitStatus status) {
      this.status = java.util.Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Adds one element to {@link CommitActions.CommitResult#getMessages() messages} list.
     * @param element A messages element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMessages(Message element) {
      this.messages.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CommitActions.CommitResult#getMessages() messages} list.
     * @param elements An array of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMessages(Message... elements) {
      this.messages.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CommitActions.CommitResult#getMessages() messages} list.
     * @param elements An iterable of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder messages(Iterable<? extends Message> elements) {
      this.messages = ImmutableList.builder();
      return addAllMessages(elements);
    }

    /**
     * Adds elements to {@link CommitActions.CommitResult#getMessages() messages} list.
     * @param elements An iterable of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMessages(Iterable<? extends Message> elements) {
      this.messages.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommitResult ImmutableCommitResult}.
     * @return An immutable instance of CommitResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommitResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCommitResult(gid, commit, status, messages.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GID) != 0) attributes.add("gid");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build CommitResult, some of required attributes are not set " + attributes;
    }
  }
}
