package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CheckoutActions.CheckoutResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCheckoutResult.builder()}.
 */
@Generated(from = "CheckoutActions.CheckoutResult", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCheckoutResult
    implements CheckoutActions.CheckoutResult {
  private final String gid;
  private final String repo;
  private final String commit;
  private final LocalDateTime modified;
  private final String name;
  private final String value;

  private ImmutableCheckoutResult(
      String gid,
      String repo,
      String commit,
      LocalDateTime modified,
      String name,
      String value) {
    this.gid = gid;
    this.repo = repo;
    this.commit = commit;
    this.modified = modified;
    this.name = name;
    this.value = value;
  }

  /**
   * @return The value of the {@code gid} attribute
   */
  @Override
  public String getGid() {
    return gid;
  }

  /**
   * @return The value of the {@code repo} attribute
   */
  @Override
  public String getRepo() {
    return repo;
  }

  /**
   * @return The value of the {@code commit} attribute
   */
  @Override
  public String getCommit() {
    return commit;
  }

  /**
   * @return The value of the {@code modified} attribute
   */
  @Override
  public LocalDateTime getModified() {
    return modified;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckoutActions.CheckoutResult#getGid() gid} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for gid
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckoutResult withGid(String value) {
    String newValue = Objects.requireNonNull(value, "gid");
    if (this.gid.equals(newValue)) return this;
    return new ImmutableCheckoutResult(newValue, this.repo, this.commit, this.modified, this.name, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckoutActions.CheckoutResult#getRepo() repo} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repo
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckoutResult withRepo(String value) {
    String newValue = Objects.requireNonNull(value, "repo");
    if (this.repo.equals(newValue)) return this;
    return new ImmutableCheckoutResult(this.gid, newValue, this.commit, this.modified, this.name, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckoutActions.CheckoutResult#getCommit() commit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckoutResult withCommit(String value) {
    String newValue = Objects.requireNonNull(value, "commit");
    if (this.commit.equals(newValue)) return this;
    return new ImmutableCheckoutResult(this.gid, this.repo, newValue, this.modified, this.name, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckoutActions.CheckoutResult#getModified() modified} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modified
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckoutResult withModified(LocalDateTime value) {
    if (this.modified == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "modified");
    return new ImmutableCheckoutResult(this.gid, this.repo, this.commit, newValue, this.name, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckoutActions.CheckoutResult#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckoutResult withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableCheckoutResult(this.gid, this.repo, this.commit, this.modified, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckoutActions.CheckoutResult#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckoutResult withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableCheckoutResult(this.gid, this.repo, this.commit, this.modified, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCheckoutResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCheckoutResult
        && equalTo((ImmutableCheckoutResult) another);
  }

  private boolean equalTo(ImmutableCheckoutResult another) {
    return gid.equals(another.gid)
        && repo.equals(another.repo)
        && commit.equals(another.commit)
        && modified.equals(another.modified)
        && name.equals(another.name)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code gid}, {@code repo}, {@code commit}, {@code modified}, {@code name}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + gid.hashCode();
    h += (h << 5) + repo.hashCode();
    h += (h << 5) + commit.hashCode();
    h += (h << 5) + modified.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CheckoutResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CheckoutResult")
        .omitNullValues()
        .add("gid", gid)
        .add("repo", repo)
        .add("commit", commit)
        .add("modified", modified)
        .add("name", name)
        .add("value", value)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CheckoutActions.CheckoutResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CheckoutResult instance
   */
  public static ImmutableCheckoutResult copyOf(CheckoutActions.CheckoutResult instance) {
    if (instance instanceof ImmutableCheckoutResult) {
      return (ImmutableCheckoutResult) instance;
    }
    return ImmutableCheckoutResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCheckoutResult ImmutableCheckoutResult}.
   * <pre>
   * ImmutableCheckoutResult.builder()
   *    .gid(String) // required {@link CheckoutActions.CheckoutResult#getGid() gid}
   *    .repo(String) // required {@link CheckoutActions.CheckoutResult#getRepo() repo}
   *    .commit(String) // required {@link CheckoutActions.CheckoutResult#getCommit() commit}
   *    .modified(java.time.LocalDateTime) // required {@link CheckoutActions.CheckoutResult#getModified() modified}
   *    .name(String) // required {@link CheckoutActions.CheckoutResult#getName() name}
   *    .value(String) // required {@link CheckoutActions.CheckoutResult#getValue() value}
   *    .build();
   * </pre>
   * @return A new ImmutableCheckoutResult builder
   */
  public static ImmutableCheckoutResult.Builder builder() {
    return new ImmutableCheckoutResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCheckoutResult ImmutableCheckoutResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CheckoutActions.CheckoutResult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_GID = 0x1L;
    private static final long INIT_BIT_REPO = 0x2L;
    private static final long INIT_BIT_COMMIT = 0x4L;
    private static final long INIT_BIT_MODIFIED = 0x8L;
    private static final long INIT_BIT_NAME = 0x10L;
    private static final long INIT_BIT_VALUE = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable String gid;
    private @Nullable String repo;
    private @Nullable String commit;
    private @Nullable LocalDateTime modified;
    private @Nullable String name;
    private @Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckoutResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CheckoutActions.CheckoutResult instance) {
      Objects.requireNonNull(instance, "instance");
      gid(instance.getGid());
      repo(instance.getRepo());
      commit(instance.getCommit());
      modified(instance.getModified());
      name(instance.getName());
      value(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link CheckoutActions.CheckoutResult#getGid() gid} attribute.
     * @param gid The value for gid 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder gid(String gid) {
      this.gid = Objects.requireNonNull(gid, "gid");
      initBits &= ~INIT_BIT_GID;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckoutActions.CheckoutResult#getRepo() repo} attribute.
     * @param repo The value for repo 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repo(String repo) {
      this.repo = Objects.requireNonNull(repo, "repo");
      initBits &= ~INIT_BIT_REPO;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckoutActions.CheckoutResult#getCommit() commit} attribute.
     * @param commit The value for commit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commit(String commit) {
      this.commit = Objects.requireNonNull(commit, "commit");
      initBits &= ~INIT_BIT_COMMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckoutActions.CheckoutResult#getModified() modified} attribute.
     * @param modified The value for modified 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder modified(LocalDateTime modified) {
      this.modified = Objects.requireNonNull(modified, "modified");
      initBits &= ~INIT_BIT_MODIFIED;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckoutActions.CheckoutResult#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckoutActions.CheckoutResult#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCheckoutResult ImmutableCheckoutResult}.
     * @return An immutable instance of CheckoutResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCheckoutResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCheckoutResult(gid, repo, commit, modified, name, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GID) != 0) attributes.add("gid");
      if ((initBits & INIT_BIT_REPO) != 0) attributes.add("repo");
      if ((initBits & INIT_BIT_COMMIT) != 0) attributes.add("commit");
      if ((initBits & INIT_BIT_MODIFIED) != 0) attributes.add("modified");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build CheckoutResult, some of required attributes are not set " + attributes;
    }
  }
}
