package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ObjectsActions.BlobObjects}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBlobObjects.builder()}.
 */
@Generated(from = "ObjectsActions.BlobObjects", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBlobObjects implements ObjectsActions.BlobObjects {
  private final Repo repo;
  private final Objects.Commit commit;
  private final Objects.Tree tree;
  private final ImmutableList<Objects.Blob> blob;

  private ImmutableBlobObjects(
      Repo repo,
      Objects.Commit commit,
      Objects.Tree tree,
      ImmutableList<Objects.Blob> blob) {
    this.repo = repo;
    this.commit = commit;
    this.tree = tree;
    this.blob = blob;
  }

  /**
   * @return The value of the {@code repo} attribute
   */
  @Override
  public Repo getRepo() {
    return repo;
  }

  /**
   * @return The value of the {@code commit} attribute
   */
  @Override
  public Objects.Commit getCommit() {
    return commit;
  }

  /**
   * @return The value of the {@code tree} attribute
   */
  @Override
  public Objects.Tree getTree() {
    return tree;
  }

  /**
   * @return The value of the {@code blob} attribute
   */
  @Override
  public ImmutableList<Objects.Blob> getBlob() {
    return blob;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ObjectsActions.BlobObjects#getRepo() repo} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repo
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlobObjects withRepo(Repo value) {
    if (this.repo == value) return this;
    Repo newValue = java.util.Objects.requireNonNull(value, "repo");
    return new ImmutableBlobObjects(newValue, this.commit, this.tree, this.blob);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ObjectsActions.BlobObjects#getCommit() commit} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlobObjects withCommit(Objects.Commit value) {
    if (this.commit == value) return this;
    Objects.Commit newValue = java.util.Objects.requireNonNull(value, "commit");
    return new ImmutableBlobObjects(this.repo, newValue, this.tree, this.blob);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ObjectsActions.BlobObjects#getTree() tree} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tree
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlobObjects withTree(Objects.Tree value) {
    if (this.tree == value) return this;
    Objects.Tree newValue = java.util.Objects.requireNonNull(value, "tree");
    return new ImmutableBlobObjects(this.repo, this.commit, newValue, this.blob);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ObjectsActions.BlobObjects#getBlob() blob}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBlobObjects withBlob(Objects.Blob... elements) {
    ImmutableList<Objects.Blob> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBlobObjects(this.repo, this.commit, this.tree, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ObjectsActions.BlobObjects#getBlob() blob}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of blob elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBlobObjects withBlob(Iterable<? extends Objects.Blob> elements) {
    if (this.blob == elements) return this;
    ImmutableList<Objects.Blob> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBlobObjects(this.repo, this.commit, this.tree, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBlobObjects} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBlobObjects
        && equalTo((ImmutableBlobObjects) another);
  }

  private boolean equalTo(ImmutableBlobObjects another) {
    return repo.equals(another.repo)
        && commit.equals(another.commit)
        && tree.equals(another.tree)
        && blob.equals(another.blob);
  }

  /**
   * Computes a hash code from attributes: {@code repo}, {@code commit}, {@code tree}, {@code blob}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + repo.hashCode();
    h += (h << 5) + commit.hashCode();
    h += (h << 5) + tree.hashCode();
    h += (h << 5) + blob.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BlobObjects} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("BlobObjects")
        .omitNullValues()
        .add("repo", repo)
        .add("commit", commit)
        .add("tree", tree)
        .add("blob", blob)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ObjectsActions.BlobObjects} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BlobObjects instance
   */
  public static ImmutableBlobObjects copyOf(ObjectsActions.BlobObjects instance) {
    if (instance instanceof ImmutableBlobObjects) {
      return (ImmutableBlobObjects) instance;
    }
    return ImmutableBlobObjects.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBlobObjects ImmutableBlobObjects}.
   * <pre>
   * ImmutableBlobObjects.builder()
   *    .repo(io.resys.thena.docdb.api.models.Repo) // required {@link ObjectsActions.BlobObjects#getRepo() repo}
   *    .commit(io.resys.thena.docdb.api.models.Objects.Commit) // required {@link ObjectsActions.BlobObjects#getCommit() commit}
   *    .tree(io.resys.thena.docdb.api.models.Objects.Tree) // required {@link ObjectsActions.BlobObjects#getTree() tree}
   *    .addBlob|addAllBlob(io.resys.thena.docdb.api.models.Objects.Blob) // {@link ObjectsActions.BlobObjects#getBlob() blob} elements
   *    .build();
   * </pre>
   * @return A new ImmutableBlobObjects builder
   */
  public static ImmutableBlobObjects.Builder builder() {
    return new ImmutableBlobObjects.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBlobObjects ImmutableBlobObjects}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ObjectsActions.BlobObjects", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_REPO = 0x1L;
    private static final long INIT_BIT_COMMIT = 0x2L;
    private static final long INIT_BIT_TREE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Repo repo;
    private @Nullable Objects.Commit commit;
    private @Nullable Objects.Tree tree;
    private ImmutableList.Builder<Objects.Blob> blob = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BlobObjects} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ObjectsActions.BlobObjects instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      repo(instance.getRepo());
      commit(instance.getCommit());
      tree(instance.getTree());
      addAllBlob(instance.getBlob());
      return this;
    }

    /**
     * Initializes the value for the {@link ObjectsActions.BlobObjects#getRepo() repo} attribute.
     * @param repo The value for repo 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repo(Repo repo) {
      this.repo = java.util.Objects.requireNonNull(repo, "repo");
      initBits &= ~INIT_BIT_REPO;
      return this;
    }

    /**
     * Initializes the value for the {@link ObjectsActions.BlobObjects#getCommit() commit} attribute.
     * @param commit The value for commit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commit(Objects.Commit commit) {
      this.commit = java.util.Objects.requireNonNull(commit, "commit");
      initBits &= ~INIT_BIT_COMMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link ObjectsActions.BlobObjects#getTree() tree} attribute.
     * @param tree The value for tree 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tree(Objects.Tree tree) {
      this.tree = java.util.Objects.requireNonNull(tree, "tree");
      initBits &= ~INIT_BIT_TREE;
      return this;
    }

    /**
     * Adds one element to {@link ObjectsActions.BlobObjects#getBlob() blob} list.
     * @param element A blob element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBlob(Objects.Blob element) {
      this.blob.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ObjectsActions.BlobObjects#getBlob() blob} list.
     * @param elements An array of blob elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBlob(Objects.Blob... elements) {
      this.blob.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ObjectsActions.BlobObjects#getBlob() blob} list.
     * @param elements An iterable of blob elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blob(Iterable<? extends Objects.Blob> elements) {
      this.blob = ImmutableList.builder();
      return addAllBlob(elements);
    }

    /**
     * Adds elements to {@link ObjectsActions.BlobObjects#getBlob() blob} list.
     * @param elements An iterable of blob elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllBlob(Iterable<? extends Objects.Blob> elements) {
      this.blob.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableBlobObjects ImmutableBlobObjects}.
     * @return An immutable instance of BlobObjects
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBlobObjects build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBlobObjects(repo, commit, tree, blob.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REPO) != 0) attributes.add("repo");
      if ((initBits & INIT_BIT_COMMIT) != 0) attributes.add("commit");
      if ((initBits & INIT_BIT_TREE) != 0) attributes.add("tree");
      return "Cannot build BlobObjects, some of required attributes are not set " + attributes;
    }
  }
}
