/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.quarkus.composer.pg.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.WebJarUtil;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.resys.hdes.client.spi.Serializers;
import io.resys.hdes.client.spi.web.HdesWebConfig;
import io.resys.hdes.quarkus.composer.pg.ComposerBeansProducer;
import io.resys.hdes.quarkus.composer.pg.ComposerRecorder;
import io.resys.hdes.quarkus.composer.pg.ComposerRuntimeConfig;
import io.resys.hdes.quarkus.composer.pg.deployment.ComposerBuildItem;
import io.resys.hdes.quarkus.composer.pg.deployment.ComposerCompiletimeConfig;
import io.resys.hdes.quarkus.composer.pg.deployment.ComposerFrontendBuildItem;
import io.resys.hdes.quarkus.composer.pg.deployment.IndexFactory;
import io.vertx.core.Handler;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Hex;

public class ComposerProcessor {
    private static final String WEBJAR_GROUP_ID = "io.resys.hdes";
    private static final String WEBJAR_ARTIFACT_ID = "hdes-composer-ui";
    private static final String WEBJAR_PREFIX = "META-INF/resources/webjars/hdes-composer-ui/";
    private static final String FINAL_DESTINATION = "META-INF/portal-files";
    @Inject
    private LaunchModeBuildItem launch;
    ComposerCompiletimeConfig config;

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("hdes-composer-pg");
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void frontendConfig(ComposerRecorder recorder, HttpRootPathBuildItem httpRoot, BuildProducer<RouteBuildItem> routes, ComposerFrontendBuildItem buildItem, BodyHandlerBuildItem body) throws Exception {
        String frontendPath = httpRoot.resolvePath(this.config.frontendPath);
        Handler router = recorder.frontendRouter(buildItem.getUiFinalDestination(), buildItem.getUiPath(), buildItem.getHash());
        routes.produce((BuildItem)httpRoot.routeBuilder().route(frontendPath).handler(router).displayOnNotFoundPage().build());
        routes.produce((BuildItem)httpRoot.routeBuilder().route(frontendPath + "/").handler(router).displayOnNotFoundPage().build());
        routes.produce((BuildItem)httpRoot.routeBuilder().route(frontendPath + "/*").handler(router).displayOnNotFoundPage().build());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void runtimeConfig(ComposerRuntimeConfig config, ComposerBuildItem buildItem, ComposerRecorder recorder, BeanContainerBuildItem beanContainer, ShutdownContextBuildItem shutdown) {
        recorder.configureRuntimeConfig(config);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void router(ComposerBuildItem buildItem, ComposerRecorder recorder, HttpRootPathBuildItem httpRoot, BuildProducer<RouteBuildItem> routes, BodyHandlerBuildItem body, ComposerCompiletimeConfig config) throws Exception {
        Handler bodyHandler = body.getHandler();
        Handler router = recorder.backendRouter();
        Consumer<String> addRoute = path -> {
            routes.produce((BuildItem)httpRoot.routeBuilder().routeFunction(path, recorder.routeFunction(bodyHandler)).handler(router).displayOnNotFoundPage().build());
            routes.produce((BuildItem)httpRoot.routeBuilder().routeFunction(path + "/", recorder.routeFunction(bodyHandler)).handler(router).displayOnNotFoundPage().build());
        };
        addRoute.accept(buildItem.getConfig().getServicePath());
        addRoute.accept(buildItem.getConfig().getCommandsPath());
        addRoute.accept(buildItem.getConfig().getCopyasPath());
        addRoute.accept(buildItem.getConfig().getDebugsPath());
        addRoute.accept(buildItem.getConfig().getExportsPath());
        addRoute.accept(buildItem.getConfig().getHistoryPath());
        addRoute.accept(buildItem.getConfig().getImportsPath());
        addRoute.accept(buildItem.getConfig().getModelsPath());
        addRoute.accept(buildItem.getConfig().getResourcesPath());
        routes.produce((BuildItem)httpRoot.routeBuilder().routeFunction(buildItem.getConfig().getHistoryPath() + "/:id", recorder.idRouteFunctionGet(bodyHandler)).handler(router).displayOnNotFoundPage().build());
        routes.produce((BuildItem)httpRoot.routeBuilder().routeFunction(buildItem.getConfig().getResourcesPath() + "/:id", recorder.idRouteFunctionGet(bodyHandler)).handler(router).displayOnNotFoundPage().build());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void deploymentConfig(ComposerBuildItem buildItem, ComposerRecorder recorder, BuildProducer<AdditionalBeanBuildItem> buildItems, BuildProducer<BeanContainerListenerBuildItem> beans) {
        buildItems.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(ComposerBeansProducer.class).build());
        beans.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.configureBuildtimeConfig(buildItem.getConfig().getServicePath(), buildItem.getConfig().getModelsPath(), buildItem.getConfig().getExportsPath(), buildItem.getConfig().getCommandsPath(), buildItem.getConfig().getDebugsPath(), buildItem.getConfig().getImportsPath(), buildItem.getConfig().getCopyasPath(), buildItem.getConfig().getResourcesPath(), buildItem.getConfig().getHistoryPath())));
    }

    @BuildStep
    public ReflectiveClassBuildItem reflection() throws SecurityException, ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<String> names = new ArrayList<String>();
        for (Class clazz : Serializers.VALUES) {
            Class<?>[] declaredClasses = classLoader.loadClass(clazz.getName()).getDeclaredClasses();
            names.add(clazz.getName());
            for (Class<?> decl : declaredClasses) {
                names.add(decl.getName());
            }
        }
        return new ReflectiveClassBuildItem(true, true, names.toArray(new String[0]));
    }

    @BuildStep
    public void buildItem(BuildProducer<ComposerBuildItem> buildProducer, HttpRootPathBuildItem httpRootPathBuildItem, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints) throws Exception {
        String servicePath = "/" + ComposerProcessor.cleanPath(this.config.servicePath);
        HdesWebConfig webConfig = HdesWebConfig.builder().servicePath(servicePath).modelsPath(servicePath + "/dataModels").exportsPath(servicePath + "/exports").commandsPath(servicePath + "/commands").debugsPath(servicePath + "/debugs").importsPath(servicePath + "/importTag").copyasPath(servicePath + "/copyas").resourcesPath(servicePath + "/resources").historyPath(servicePath + "/history").build();
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(httpRootPathBuildItem.resolvePath(servicePath), "Hdes Composer Backend"));
        buildProducer.produce((BuildItem)new ComposerBuildItem(webConfig));
    }

    @BuildStep
    public void frontendBuildItem(ComposerBuildItem composerBuildItem, BuildProducer<ComposerFrontendBuildItem> buildProducer, BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<NativeImageResourceBuildItem> nativeImage, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, LiveReloadBuildItem liveReloadBuildItem, HttpRootPathBuildItem httpRootPathBuildItem, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints) throws Exception {
        if (!this.config.frontend.booleanValue()) {
            return;
        }
        String hash = Hex.encodeHexString((byte[])LocalDateTime.now().toString().getBytes(StandardCharsets.UTF_8), (boolean)true);
        AppArtifact artifact = WebJarUtil.getAppArtifact((CurateOutcomeBuildItem)curateOutcomeBuildItem, (String)WEBJAR_GROUP_ID, (String)WEBJAR_ARTIFACT_ID);
        if (this.launch.getLaunchMode().isDevOrTest()) {
            Path tempPath = WebJarUtil.copyResourcesForDevOrTest((LiveReloadBuildItem)liveReloadBuildItem, (CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)this.launch, (AppArtifact)artifact, (String)(WEBJAR_PREFIX + artifact.getVersion()), (boolean)false);
            Path index = tempPath.resolve("index.html");
            String frontendPath = httpRootPathBuildItem.resolvePath(this.config.frontendPath);
            WebJarUtil.updateFile((Path)index, (byte[])IndexFactory.builder().frontend(frontendPath).server(httpRootPathBuildItem.resolvePath(composerBuildItem.getConfig().getServicePath())).index(index).build());
            buildProducer.produce((BuildItem)new ComposerFrontendBuildItem(tempPath.toAbsolutePath().toString(), frontendPath, hash));
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(httpRootPathBuildItem.resolvePath(frontendPath), "Hdes Composer Frontend"));
            if (liveReloadBuildItem.isLiveReload() && !liveReloadBuildItem.getChangedResources().isEmpty()) {
                WebJarUtil.hotReloadBrandingChanges((CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)this.launch, (AppArtifact)artifact, (Set)liveReloadBuildItem.getChangedResources());
            }
        } else {
            String frontendPath = httpRootPathBuildItem.resolvePath(this.config.frontendPath);
            Map files = WebJarUtil.copyResourcesForProduction((CurateOutcomeBuildItem)curateOutcomeBuildItem, (AppArtifact)artifact, (String)(WEBJAR_PREFIX + artifact.getVersion()));
            boolean indexReplaced = false;
            for (Map.Entry file : files.entrySet()) {
                byte[] content;
                Object fileName = (String)file.getKey();
                if (((String)fileName).endsWith("index.html")) {
                    content = IndexFactory.builder().frontend(frontendPath).server(httpRootPathBuildItem.resolvePath(composerBuildItem.getConfig().getServicePath())).index((byte[])file.getValue()).build();
                    indexReplaced = true;
                } else {
                    content = (byte[])file.getValue();
                }
                fileName = "META-INF/portal-files/" + (String)fileName;
                generatedResources.produce((BuildItem)new GeneratedResourceBuildItem((String)fileName, content));
                nativeImage.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fileName}));
            }
            if (!indexReplaced) {
                throw new ConfigurationError("Failed to create composer frontend index.html, " + "artifact = " + artifact + System.lineSeparator() + "," + "path = " + frontendPath + "!" + "final destination = " + FINAL_DESTINATION + "!");
            }
            buildProducer.produce((BuildItem)new ComposerFrontendBuildItem(FINAL_DESTINATION, frontendPath, hash));
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(httpRootPathBuildItem.resolvePath(frontendPath), "Hdes Composer Frontend"));
        }
    }

    private static String cleanPath(String value) {
        return ComposerBeansProducer.cleanPath((String)value);
    }
}

