/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.ui.quarkus.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.index.ResolvedArtifact;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.resys.hdes.ui.quarkus.deployment.HdesArtifactResolver;
import io.resys.hdes.ui.quarkus.runtime.HdesDefsHandler;
import io.resys.hdes.ui.quarkus.runtime.HdesUIBackendProducer;
import io.resys.hdes.ui.quarkus.runtime.HdesUiRecorder;
import io.vertx.core.Handler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.inject.Inject;
import org.jboss.logging.Logger;

public class HdesUiProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)HdesUiProcessor.class.getName());
    private static final String WEBJAR_GROUP_ID = "io.resys.hdes";
    private static final String WEBJAR_ARTIFACT_ID = "hdes-ui-frontend";
    private static final String WEBJAR_PREFIX = "META-INF/resources/webjars/hdes-ui-frontend";
    private static final String FINAL_DESTINATION = "META-INF/hdes-ui-files";
    private static final String FEATURE_BUILD_ITEM = "hdes-ui";
    private static final String TEMP_DIR = "hdes-ui-" + System.nanoTime();
    @Inject
    private LaunchModeBuildItem launch;
    HdesUiConfig hdesUiConfig;

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> feature) {
        if (this.hdesUiConfig.enable) {
            feature.produce((BuildItem)new FeatureBuildItem(FEATURE_BUILD_ITEM));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerHdesUIBackendExtension(HdesUiRecorder recorder, BuildProducer<RouteBuildItem> routes, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints, BuildProducer<AdditionalBeanBuildItem> buildItems, BuildProducer<BeanContainerListenerBuildItem> beans) {
        if (!this.hdesUiConfig.enable) {
            return;
        }
        if ("/".equals(this.hdesUiConfig.path)) {
            throw new ConfigurationError("quarkus.hdes-ui.path was set to \"/\", this is not allowed as it blocks the application from serving anything else.");
        }
        buildItems.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(HdesUIBackendProducer.class).build());
        beans.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.listener()));
        String path = this.hdesUiConfig.path + "/services";
        String defsPath = path + "/defs";
        routes.produce((BuildItem)new RouteBuildItem(defsPath, (Handler)new HdesDefsHandler(), HandlerType.BLOCKING));
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(defsPath));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void registerHdesUiServletExtension(HdesUiRecorder recorder, BuildProducer<RouteBuildItem> routes, BeanContainerBuildItem container, BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<NativeImageResourceBuildItem> nativeImageResourceBuildItemBuildProducer, LiveReloadBuildItem liveReloadBuildItem, HttpRootPathBuildItem httpRootPathBuildItem, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints) throws Exception {
        Handler handler;
        if (!this.hdesUiConfig.enable) {
            return;
        }
        if ("/".equals(this.hdesUiConfig.path)) {
            throw new ConfigurationError("quarkus.hdes-ui.path was set to \"/\", this is not allowed as it blocks the application from serving anything else.");
        }
        String path = httpRootPathBuildItem.adjustPath(this.hdesUiConfig.path);
        if (this.launch.getLaunchMode().isDevOrTest()) {
            boolean extract;
            HdesUICache cached = (HdesUICache)liveReloadBuildItem.getContextObject(HdesUICache.class);
            boolean bl = extract = cached == null;
            if (cached != null && !cached.path.equals(path)) {
                cached.run();
                extract = true;
                cached.setPath(path);
            }
            if (cached == null) {
                cached = new HdesUICache().setPath(path);
                liveReloadBuildItem.setContextObject(HdesUICache.class, (Object)cached);
                Runtime.getRuntime().addShutdownHook(new Thread((Runnable)cached, "Hdes UI Shutdown Hook"));
            }
            if (extract) {
                Path tempDir = Files.createTempDirectory(TEMP_DIR, new FileAttribute[0]).toRealPath(new LinkOption[0]);
                cached.setDir(tempDir.toAbsolutePath().toString());
                this.processArtifact(path, item -> {
                    try {
                        Path newFile = tempDir.resolve(item.getName());
                        newFile.toFile().getParentFile().mkdirs();
                        Files.copy(new ByteArrayInputStream(item.getClassData()), newFile, new CopyOption[0]);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("Error when creating Hdes UI file " + e.getMessage()), (Throwable)e);
                    }
                });
            }
            handler = recorder.handler(cached.dir, httpRootPathBuildItem.adjustPath(this.hdesUiConfig.path));
            displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(this.hdesUiConfig.path + "/"));
        } else {
            this.processArtifact(path, item -> {
                String fileName = "META-INF/hdes-ui-files/" + item.getName();
                generatedResources.produce((BuildItem)new GeneratedResourceBuildItem(fileName, item.getClassData()));
                nativeImageResourceBuildItemBuildProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fileName}));
            });
            handler = recorder.handler(FINAL_DESTINATION, httpRootPathBuildItem.adjustPath(this.hdesUiConfig.path));
        }
        routes.produce((BuildItem)new RouteBuildItem(this.hdesUiConfig.path, handler));
        routes.produce((BuildItem)new RouteBuildItem(this.hdesUiConfig.path + "/*", handler));
    }

    private void processArtifact(String path, Consumer<GeneratedResourceBuildItem> consumer) throws IOException {
        HdesArtifactResolver resolver = new HdesArtifactResolver();
        ResolvedArtifact artifact = resolver.getArtifact(WEBJAR_GROUP_ID, WEBJAR_ARTIFACT_ID, null);
        try (JarFile jarFile = new JarFile(artifact.getArtifactPath().toFile());){
            Enumeration<JarEntry> entries = jarFile.entries();
            String jarPrefix = String.format("%s/%s/", WEBJAR_PREFIX, artifact.getVersion());
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(jarPrefix) || entry.isDirectory()) continue;
                InputStream inputStream = jarFile.getInputStream(entry);
                try {
                    String jarName = entry.getName().replace(jarPrefix, "");
                    byte[] content = FileUtil.readFileContents((InputStream)inputStream);
                    if (entry.getName().endsWith("index.html")) {
                        content = this.addConfig(new String(content, StandardCharsets.UTF_8), path).getBytes(StandardCharsets.UTF_8);
                    }
                    consumer.accept(new GeneratedResourceBuildItem(jarName, content));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
    }

    public String addConfig(String original, String config) {
        return original.replaceFirst("\\_HDES\\_UI\\_CONFIG=\\{\\}", "_HDES_UI_CONFIG={/*empty config*/};");
    }

    private static final class HdesUICache
    implements Runnable {
        private String path;
        private String dir;

        private HdesUICache() {
        }

        public HdesUICache setPath(String path) {
            this.path = path;
            return this;
        }

        public HdesUICache setDir(String dir) {
            this.dir = dir;
            return this;
        }

        @Override
        public void run() {
            try {
                FileUtil.deleteDirectory((Path)Paths.get(this.dir, new String[0]));
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error when cleaning Hdes UI temp dir " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @ConfigRoot
    static final class HdesUiConfig {
        @ConfigItem(defaultValue="/hdes-ui")
        String path;
        @ConfigItem(defaultValue="true")
        boolean enable;

        HdesUiConfig() {
        }
    }
}

