/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.ui.quarkus.deployment;

import io.quarkus.deployment.index.ArtifactResolver;
import io.quarkus.deployment.index.ResolvedArtifact;
import io.resys.hdes.ui.quarkus.runtime.HdesBackendRecorder;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;

public class HdesArtifactResolver
implements ArtifactResolver {
    private static final String META_INF_MANIFEST_MF = "META-INF/MANIFEST.MF";
    private final List<StoredUrl> pathList = new ArrayList<StoredUrl>();

    public HdesArtifactResolver() {
        ClassLoader cl = HdesBackendRecorder.class.getClassLoader();
        try {
            Enumeration<URL> res = cl.getResources(META_INF_MANIFEST_MF);
            while (res.hasMoreElements()) {
                URL jarUrl = res.nextElement();
                Object path = jarUrl.getPath();
                if (!((String)path).contains("hdes")) continue;
                if (((String)path).startsWith(File.separator)) {
                    Path target;
                    Path jarPath = Path.of((String)path, new String[0]);
                    Path classes = jarPath.getParent().getParent();
                    if (!classes.endsWith("classes") || !(target = classes.getParent()).endsWith("target")) continue;
                    for (File file : target.toFile().listFiles((dir, name) -> name.endsWith(".jar"))) {
                        path = "file:" + file.toPath().toAbsolutePath().toString();
                    }
                    this.pathList.add(new StoredUrl(Paths.get(new URI((String)path))));
                    continue;
                }
                if (!((String)path).startsWith("file:")) continue;
                this.pathList.add(new StoredUrl(Paths.get(new URI(((String)path).substring(0, ((String)path).length() - META_INF_MANIFEST_MF.length() - 2)))));
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public ResolvedArtifact getArtifact(String groupId, String artifactId, String classifier) {
        String filePatten = artifactId + "-(\\d.*)\\.jar";
        Function<StoredUrl, ResolvedArtifact> resolver = this.createMavenResolver(groupId, artifactId);
        for (StoredUrl url : this.pathList) {
            ResolvedArtifact result;
            if (!url.fileName.matches(filePatten) || (result = resolver.apply(url)) == null) continue;
            return result;
        }
        throw new RuntimeException("Could not resolve artifact " + groupId + ":" + artifactId + ":" + classifier);
    }

    public Function<StoredUrl, ResolvedArtifact> createMavenResolver(String groupId, String artifactId) {
        return url -> {
            String[] groupParts = groupId.split("\\.");
            if (url.path.getNameCount() < groupParts.length + 2) {
                return null;
            }
            boolean matches = true;
            if (!url.path.getParent().getFileName().getName(0).toString().equals("target")) {
                for (int i = 0; i < groupParts.length; ++i) {
                    String up = url.path.getName(url.path.getNameCount() - groupParts.length - 3 + i).toString();
                    if (up.equals(groupParts[i])) continue;
                    matches = false;
                    break;
                }
            }
            if (matches) {
                try {
                    int start = url.fileName.lastIndexOf(artifactId) + artifactId.length() + 1;
                    int end = url.fileName.lastIndexOf(".jar");
                    String version = url.fileName.substring(start, end);
                    return new ResolvedArtifact(groupId, artifactId, version, null, url.path);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        };
    }

    static class StoredUrl {
        final Path path;
        final String fileName;

        private StoredUrl(Path path) {
            this.path = path;
            this.fileName = path.getFileName().toString();
        }

        public String toString() {
            return "StoredUrl{path=" + this.path + "}";
        }
    }
}

