package io.resys.hdes.client.spi;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.hdes.client.api.ast.AstBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GitConfig.GitFileReload}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGitFileReload.builder()}.
 */
@Generated(from = "GitConfig.GitFileReload", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGitFileReload implements GitConfig.GitFileReload {
  private final String treeValue;
  private final String id;
  private final AstBody.AstBodyType bodyType;
  private final @Nullable GitConfig.GitFile file;

  private ImmutableGitFileReload(
      String treeValue,
      String id,
      AstBody.AstBodyType bodyType,
      @Nullable GitConfig.GitFile file) {
    this.treeValue = treeValue;
    this.id = id;
    this.bodyType = bodyType;
    this.file = file;
  }

  /**
   * @return The value of the {@code treeValue} attribute
   */
  @Override
  public String getTreeValue() {
    return treeValue;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code bodyType} attribute
   */
  @Override
  public AstBody.AstBodyType getBodyType() {
    return bodyType;
  }

  /**
   * @return The value of the {@code file} attribute
   */
  @Override
  public Optional<GitConfig.GitFile> getFile() {
    return Optional.ofNullable(file);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitFileReload#getTreeValue() treeValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for treeValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitFileReload withTreeValue(String value) {
    String newValue = Objects.requireNonNull(value, "treeValue");
    if (this.treeValue.equals(newValue)) return this;
    return new ImmutableGitFileReload(newValue, this.id, this.bodyType, this.file);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitFileReload#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitFileReload withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableGitFileReload(this.treeValue, newValue, this.bodyType, this.file);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitFileReload#getBodyType() bodyType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bodyType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitFileReload withBodyType(AstBody.AstBodyType value) {
    if (this.bodyType == value) return this;
    AstBody.AstBodyType newValue = Objects.requireNonNull(value, "bodyType");
    if (this.bodyType.equals(newValue)) return this;
    return new ImmutableGitFileReload(this.treeValue, this.id, newValue, this.file);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link GitConfig.GitFileReload#getFile() file} attribute.
   * @param value The value for file
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGitFileReload withFile(GitConfig.GitFile value) {
    @Nullable GitConfig.GitFile newValue = Objects.requireNonNull(value, "file");
    if (this.file == newValue) return this;
    return new ImmutableGitFileReload(this.treeValue, this.id, this.bodyType, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link GitConfig.GitFileReload#getFile() file} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for file
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableGitFileReload withFile(Optional<? extends GitConfig.GitFile> optional) {
    @Nullable GitConfig.GitFile value = optional.orElse(null);
    if (this.file == value) return this;
    return new ImmutableGitFileReload(this.treeValue, this.id, this.bodyType, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGitFileReload} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGitFileReload
        && equalTo((ImmutableGitFileReload) another);
  }

  private boolean equalTo(ImmutableGitFileReload another) {
    return treeValue.equals(another.treeValue)
        && id.equals(another.id)
        && bodyType.equals(another.bodyType)
        && Objects.equals(file, another.file);
  }

  /**
   * Computes a hash code from attributes: {@code treeValue}, {@code id}, {@code bodyType}, {@code file}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + treeValue.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + bodyType.hashCode();
    h += (h << 5) + Objects.hashCode(file);
    return h;
  }

  /**
   * Prints the immutable value {@code GitFileReload} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GitFileReload")
        .omitNullValues()
        .add("treeValue", treeValue)
        .add("id", id)
        .add("bodyType", bodyType)
        .add("file", file)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GitConfig.GitFileReload} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GitFileReload instance
   */
  public static ImmutableGitFileReload copyOf(GitConfig.GitFileReload instance) {
    if (instance instanceof ImmutableGitFileReload) {
      return (ImmutableGitFileReload) instance;
    }
    return ImmutableGitFileReload.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGitFileReload ImmutableGitFileReload}.
   * <pre>
   * ImmutableGitFileReload.builder()
   *    .treeValue(String) // required {@link GitConfig.GitFileReload#getTreeValue() treeValue}
   *    .id(String) // required {@link GitConfig.GitFileReload#getId() id}
   *    .bodyType(io.resys.hdes.client.api.ast.AstBody.AstBodyType) // required {@link GitConfig.GitFileReload#getBodyType() bodyType}
   *    .file(io.resys.hdes.client.spi.GitConfig.GitFile) // optional {@link GitConfig.GitFileReload#getFile() file}
   *    .build();
   * </pre>
   * @return A new ImmutableGitFileReload builder
   */
  public static ImmutableGitFileReload.Builder builder() {
    return new ImmutableGitFileReload.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGitFileReload ImmutableGitFileReload}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GitConfig.GitFileReload", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TREE_VALUE = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_BODY_TYPE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String treeValue;
    private @Nullable String id;
    private @Nullable AstBody.AstBodyType bodyType;
    private @Nullable GitConfig.GitFile file;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GitFileReload} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GitConfig.GitFileReload instance) {
      Objects.requireNonNull(instance, "instance");
      treeValue(instance.getTreeValue());
      id(instance.getId());
      bodyType(instance.getBodyType());
      Optional<GitConfig.GitFile> fileOptional = instance.getFile();
      if (fileOptional.isPresent()) {
        file(fileOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitFileReload#getTreeValue() treeValue} attribute.
     * @param treeValue The value for treeValue 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder treeValue(String treeValue) {
      this.treeValue = Objects.requireNonNull(treeValue, "treeValue");
      initBits &= ~INIT_BIT_TREE_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitFileReload#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitFileReload#getBodyType() bodyType} attribute.
     * @param bodyType The value for bodyType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bodyType(AstBody.AstBodyType bodyType) {
      this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
      initBits &= ~INIT_BIT_BODY_TYPE;
      return this;
    }

    /**
     * Initializes the optional value {@link GitConfig.GitFileReload#getFile() file} to file.
     * @param file The value for file
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder file(GitConfig.GitFile file) {
      this.file = Objects.requireNonNull(file, "file");
      return this;
    }

    /**
     * Initializes the optional value {@link GitConfig.GitFileReload#getFile() file} to file.
     * @param file The value for file
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder file(Optional<? extends GitConfig.GitFile> file) {
      this.file = file.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableGitFileReload ImmutableGitFileReload}.
     * @return An immutable instance of GitFileReload
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGitFileReload build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGitFileReload(treeValue, id, bodyType, file);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TREE_VALUE) != 0) attributes.add("treeValue");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_BODY_TYPE) != 0) attributes.add("bodyType");
      return "Cannot build GitFileReload, some of required attributes are not set " + attributes;
    }
  }
}
