/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.client.spi.git;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.resys.hdes.client.api.ast.AstCommand;
import io.resys.hdes.client.spi.GitConfig;
import java.io.IOException;
import java.util.List;

public class GitSerializerImpl
implements GitConfig.GitSerializer {
    private final ObjectMapper objectMapper;
    private final TypeReference<List<AstCommand>> ref = new TypeReference<List<AstCommand>>(){};

    public GitSerializerImpl(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public List<AstCommand> read(String commands) {
        try {
            if (commands.startsWith("{")) {
                JsonNode tree = this.objectMapper.readTree(commands);
                return (List)this.objectMapper.convertValue((Object)tree.get("commands"), this.ref);
            }
            return (List)this.objectMapper.readValue(commands, this.ref);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String write(List<AstCommand> commands) {
        try {
            return this.objectMapper.writeValueAsString(commands);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

