/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.client.spi.git;

import io.resys.hdes.client.api.HdesStore;
import io.resys.hdes.client.api.ast.AstBody;
import io.resys.hdes.client.api.ast.AstCommand;
import io.resys.hdes.client.spi.GitConfig;
import io.resys.hdes.client.spi.ImmutableGitEntry;
import io.resys.hdes.client.spi.ImmutableGitFile;
import io.resys.hdes.client.spi.ImmutableGitFileReload;
import io.resys.hdes.client.spi.staticresources.Sha2;
import io.resys.hdes.client.spi.staticresources.StoreEntityLocation;
import io.resys.hdes.client.spi.util.HdesAssert;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.EmptyCommitException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.ehcache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitFiles {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitFiles.class);
    private static final String SEPARATOR = "/";
    private final GitConfig conn;

    public GitFiles(GitConfig connection) {
        this.conn = connection;
    }

    public List<GitConfig.GitFileReload> push(List<GitConfig.GitFile> gitFiles) {
        Git git = this.conn.getClient();
        Repository repo = git.getRepository();
        TransportConfigCallback callback = this.conn.getCallback();
        HdesStore.HdesCreds creds = (HdesStore.HdesCreds)this.conn.getCreds().get();
        try {
            ObjectId start = repo.resolve("HEAD");
            ((PullCommand)git.pull().setTransportConfigCallback(callback)).call().getFetchResult();
            AddCommand add = git.add();
            for (GitConfig.GitFile gitFile : gitFiles) {
                add = add.addFilepattern(gitFile.getTreeValue());
            }
            add.call();
            git.commit().setAll(true).setAllowEmpty(false).setMessage("Batch import").setAuthor(creds.getUser(), creds.getEmail()).setCommitter(creds.getUser(), creds.getEmail()).call();
            ((PushCommand)git.push().setTransportConfigCallback(callback)).call();
            ObjectId end = repo.resolve("HEAD");
            LOGGER.debug("Pushing changes...");
            return this.diff(start, end);
        }
        catch (CheckoutConflictException e) {
            LOGGER.error("Conflict, resetting... " + e.getMessage(), (Throwable)e);
            try {
                git.reset().setMode(ResetCommand.ResetType.HARD).call();
                ((PullCommand)git.pull().setTransportConfigCallback(callback)).call();
            }
            catch (Exception ex) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (EmptyCommitException e) {
            LOGGER.debug("nothing to commit");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return Collections.emptyList();
    }

    public List<GitConfig.GitFileReload> push(GitConfig.GitFile gitFile) {
        Git git = this.conn.getClient();
        Repository repo = git.getRepository();
        TransportConfigCallback callback = this.conn.getCallback();
        HdesStore.HdesCreds creds = (HdesStore.HdesCreds)this.conn.getCreds().get();
        try {
            ObjectId start = repo.resolve("HEAD");
            ((PullCommand)git.pull().setTransportConfigCallback(callback)).call().getFetchResult();
            git.add().addFilepattern(gitFile.getTreeValue()).call();
            git.commit().setAll(true).setAllowEmpty(false).setMessage("Changes to: " + gitFile.getBodyType() + " file: " + gitFile.getTreeValue()).setAuthor(creds.getUser(), creds.getEmail()).setCommitter(creds.getUser(), creds.getEmail()).call();
            ((PushCommand)git.push().setTransportConfigCallback(callback)).call();
            ObjectId end = repo.resolve("HEAD");
            LOGGER.debug("Pushing changes...");
            return this.diff(start, end);
        }
        catch (CheckoutConflictException e) {
            LOGGER.error("Conflict, resetting... " + e.getMessage(), (Throwable)e);
            try {
                git.reset().setMode(ResetCommand.ResetType.HARD).call();
                ((PullCommand)git.pull().setTransportConfigCallback(callback)).call();
            }
            catch (Exception ex) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (EmptyCommitException e) {
            LOGGER.debug("nothing to commit");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return Collections.emptyList();
    }

    public GitConfig.GitEntry readEntry(GitConfig.GitFile entry) {
        Git git = this.conn.getClient();
        Repository repo = git.getRepository();
        try {
            ObjectId start = repo.resolve("HEAD");
            return this.readEntry(entry, start);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load timestamps for: " + entry.getTreeValue() + "!" + e.getMessage(), e);
        }
    }

    public GitConfig.GitEntry readEntry(GitConfig.GitFile entry, ObjectId start) {
        ImmutableGitEntry immutableGitEntry;
        Git git = this.conn.getClient();
        Repository repo = git.getRepository();
        RevWalk revWalk = new RevWalk(repo);
        try {
            TreeFilter treeFilter = AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings((String[])new String[]{entry.getTreeValue()}), (TreeFilter)TreeFilter.ANY_DIFF);
            String revision = start.getName();
            Timestamp created = Timestamp.valueOf(LocalDateTime.MIN);
            Timestamp modified = Timestamp.valueOf(LocalDateTime.MIN);
            try {
                RevCommit commit = revWalk.parseCommit((AnyObjectId)start);
                revWalk.reset();
                revWalk.markStart(commit);
                revWalk.setTreeFilter(treeFilter);
                revWalk.sort(RevSort.COMMIT_TIME_DESC);
                RevCommit modTree = revWalk.next();
                modified = modTree != null ? new Timestamp((long)modTree.getCommitTime() * 1000L) : new Timestamp(System.currentTimeMillis());
                revision = modTree != null ? modTree.getName() : start.getName();
                revWalk.reset();
                revWalk.markStart(commit);
                revWalk.setTreeFilter(treeFilter);
                revWalk.sort(RevSort.COMMIT_TIME_DESC);
                revWalk.sort(RevSort.REVERSE, true);
                created = new Timestamp(System.currentTimeMillis());
            }
            catch (Exception e) {
                LOGGER.error("Failed to create asset from file: '" + entry.getTreeValue() + "'" + System.lineSeparator() + "because of: " + e.getMessage() + System.lineSeparator() + "with content: " + entry.getBlobValue(), (Throwable)e);
            }
            List<AstCommand> commands = this.conn.getSerializer().read(entry.getBlobValue());
            ImmutableGitEntry result = ImmutableGitEntry.builder().id(entry.getId()).revision(revision).bodyType(entry.getBodyType()).treeValue(entry.getTreeValue()).blobValue(entry.getBlobValue()).created(created).modified(modified).blobHash(Sha2.blob((String)entry.getBlobValue())).commands(commands).build();
            if (LOGGER.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder().append("Loading path: ").append(result.getTreeValue()).append(System.lineSeparator()).append("  - blob murmur3_128: ").append(result.getBlobHash()).append(System.lineSeparator()).append("  - body type: ").append(result.getBodyType()).append(System.lineSeparator()).append("  - created: ").append(result.getCreated()).append(System.lineSeparator()).append("  - modified: ").append(result.getModified()).append(System.lineSeparator()).append("  - revision: ").append(result.getRevision()).append(System.lineSeparator());
                LOGGER.debug(msg.toString());
            }
            immutableGitEntry = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    revWalk.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load timestamps for: " + entry.getTreeValue() + "!" + System.lineSeparator() + e.getMessage(), e);
            }
        }
        revWalk.close();
        return immutableGitEntry;
    }

    public Map.Entry<String, List<GitConfig.GitFileReload>> tag(HdesStore.CreateStoreEntity entity) {
        Git git = this.conn.getClient();
        TransportConfigCallback callback = this.conn.getCallback();
        HdesStore.HdesCreds creds = (HdesStore.HdesCreds)this.conn.getCreds().get();
        Repository repo = git.getRepository();
        try {
            ObjectId start = repo.resolve("HEAD");
            ((PullCommand)git.pull().setTransportConfigCallback(callback)).call().getFetchResult();
            String name = entity.getBody().stream().filter(e -> e.getType() == AstCommand.AstCommandValue.SET_TAG_NAME).findFirst().get().getValue();
            Ref ref = git.tag().setName(name).setAnnotated(true).setMessage("tag created").setTagger(new PersonIdent(creds.getUser(), creds.getEmail())).call();
            ((PushCommand)git.push().setPushTags().setTransportConfigCallback(callback)).call();
            ObjectId end = repo.resolve("HEAD");
            ArrayList<GitConfig.GitFileReload> result = new ArrayList<GitConfig.GitFileReload>(this.diff(start, end));
            result.add(ImmutableGitFileReload.builder().treeValue(ref.getName()).id(name).bodyType(AstBody.AstBodyType.TAG).build());
            return Map.entry(ref.getObjectId().getName(), result);
        }
        catch (Exception e2) {
            LOGGER.error(e2.getMessage(), (Throwable)e2);
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }

    private List<GitConfig.GitFileReload> diff(ObjectId oldHead, ObjectId newHead) {
        ArrayList<ImmutableGitFileReload> arrayList;
        block10: {
            Git git = this.conn.getClient();
            Repository repo = git.getRepository();
            ObjectReader reader = repo.newObjectReader();
            try {
                ArrayList<ImmutableGitFileReload> result = new ArrayList<ImmutableGitFileReload>();
                CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
                oldTreeIter.reset(reader, (AnyObjectId)repo.parseCommit((AnyObjectId)oldHead).getTree());
                CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
                newTreeIter.reset(reader, (AnyObjectId)repo.parseCommit((AnyObjectId)newHead).getTree());
                List diffs = git.diff().setNewTree((AbstractTreeIterator)newTreeIter).setOldTree((AbstractTreeIterator)oldTreeIter).call();
                for (DiffEntry entry : diffs) {
                    Optional<String> oldId = this.getId(entry.getOldPath());
                    Optional<String> id = this.getId(entry.getNewPath());
                    if (id.isEmpty()) {
                        AstBody.AstBodyType bodyType = this.getBodyType(entry.getOldPath());
                        result.add(ImmutableGitFileReload.builder().id(oldId.get()).treeValue(entry.getOldPath()).bodyType(bodyType).build());
                        continue;
                    }
                    String content = this.getContent(entry.getNewPath());
                    AstBody.AstBodyType bodyType = this.getBodyType(entry.getNewPath());
                    String treeValue = entry.getNewPath();
                    ImmutableGitFile gitFile = ImmutableGitFile.builder().id(id.get()).treeValue(treeValue).blobValue(content).bodyType(bodyType).blobHash(Sha2.blob((String)content)).build();
                    result.add(ImmutableGitFileReload.builder().id(id.get()).treeValue(treeValue).file(gitFile).bodyType(bodyType).build());
                }
                arrayList = result;
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            reader.close();
        }
        return arrayList;
    }

    private Optional<String> getId(String path) {
        if (path.indexOf(".json") < 0) {
            return Optional.empty();
        }
        String[] paths = path.split(SEPARATOR);
        String fileName = paths[paths.length - 1];
        String id = fileName.substring(0, fileName.indexOf("."));
        return Optional.of(id);
    }

    private AstBody.AstBodyType getBodyType(String path) {
        if (path.contains("/dt/")) {
            return AstBody.AstBodyType.DT;
        }
        if (path.contains("/flow/")) {
            return AstBody.AstBodyType.FLOW;
        }
        if (path.contains("/flowtask/")) {
            return AstBody.AstBodyType.FLOW_TASK;
        }
        if (path.contains("/tag/")) {
            return AstBody.AstBodyType.TAG;
        }
        if (path.contains("/branch/")) {
            return AstBody.AstBodyType.BRANCH;
        }
        throw new RuntimeException("Failed to load asset body type: " + path + "!");
    }

    private String getContent(String path) {
        try {
            return IOUtils.toString((InputStream)new FileInputStream(this.conn.getAbsolutePath() + SEPARATOR + path), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load asset content from: " + path + "!" + e.getMessage(), e);
        }
    }

    public GitConfig.GitFile create(AstBody.AstBodyType bodyType, List<AstCommand> body) throws IOException {
        String id;
        StoreEntityLocation location = this.conn.getLocation();
        String resourceName = location.getAbsolutePath(bodyType, id = UUID.randomUUID().toString());
        String assetName = resourceName.startsWith("file:") ? resourceName.substring(5) : resourceName;
        File outputFile = new File(assetName);
        if (outputFile.exists()) {
            throw new RuntimeException("Can't create asset: '" + assetName + "' because it's already created!");
        }
        outputFile.getParentFile().mkdirs();
        boolean created = outputFile.createNewFile();
        HdesAssert.isTrue((boolean)created, () -> "Failed to create new file: " + assetName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created new file: " + outputFile.getCanonicalPath());
        }
        String blob = this.conn.getSerializer().write(body);
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
            IOUtils.copy((InputStream)new ByteArrayInputStream(blob.getBytes(StandardCharsets.UTF_8)), (OutputStream)fileOutputStream);
        }
        return ImmutableGitFile.builder().id(id).treeValue(location.resolveTreeValue(this.conn.getAssetsPath(), bodyType, id)).blobValue(blob).blobHash(Sha2.blob((String)blob)).bodyType(bodyType).build();
    }

    public GitConfig.GitFile update(String id, AstBody.AstBodyType bodyType, List<AstCommand> body) throws IOException {
        StoreEntityLocation location = this.conn.getLocation();
        String resourceName = location.getAbsolutePath(bodyType, id);
        String assetName = resourceName.startsWith("file:") ? resourceName.substring(5) : resourceName;
        File outputFile = new File(assetName);
        if (!outputFile.exists()) {
            throw new RuntimeException("Can't update asset: '" + assetName + "' because it does not exist!");
        }
        String blob = this.conn.getSerializer().write(body);
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
            IOUtils.copy((InputStream)new ByteArrayInputStream(blob.getBytes(StandardCharsets.UTF_8)), (OutputStream)fileOutputStream);
        }
        return ImmutableGitFile.builder().id(id).treeValue(location.resolveTreeValue(this.conn.getAssetsPath(), bodyType, id)).blobValue(blob).bodyType(bodyType).blobHash(Sha2.blob((String)blob)).build();
    }

    private String getCommitMessage(List<GitConfig.GitEntry> gitFiles) {
        Optional<GitConfig.GitEntry> branchFile = gitFiles.stream().filter(f -> f.getBodyType().equals((Object)AstBody.AstBodyType.BRANCH)).findFirst();
        if (gitFiles.size() == 1 && branchFile.isEmpty()) {
            return "Delete: " + gitFiles.get(0).getBodyType() + " file: " + gitFiles.get(0).getTreeValue();
        }
        String branchName = ((AstCommand)branchFile.get().getCommands().stream().filter(c -> c.getType().equals((Object)AstCommand.AstCommandValue.SET_BRANCH_NAME)).collect(Collectors.toList()).get(0)).getValue();
        return "Delete: BRANCH " + branchName + " and its assets";
    }

    public List<GitConfig.GitFileReload> delete(List<GitConfig.GitEntry> gitFiles) throws IOException {
        Cache cache = this.conn.getCacheManager().getCache(this.conn.getCacheName(), String.class, GitConfig.GitEntry.class);
        Git git = this.conn.getClient();
        TransportConfigCallback callback = this.conn.getCallback();
        HdesStore.HdesCreds creds = (HdesStore.HdesCreds)this.conn.getCreds().get();
        Repository repo = git.getRepository();
        ObjectId start = repo.resolve("HEAD");
        ArrayList<GitConfig.GitFileReload> result = new ArrayList<GitConfig.GitFileReload>();
        try {
            for (GitConfig.GitEntry gitFile : gitFiles) {
                if (gitFile.getBodyType() == AstBody.AstBodyType.TAG) {
                    String filter = "refs/tags/" + gitFile.getCommands().stream().filter(c -> c.getType() == AstCommand.AstCommandValue.SET_TAG_NAME).findFirst().get().getValue();
                    Optional<Ref> target = git.tagList().call().stream().filter(ref -> ref.getName().equals(filter)).findFirst();
                    if (target.isPresent()) {
                        git.tagDelete().setTags(new String[]{target.get().getName()}).call();
                        RefSpec refSpec = new RefSpec().setSource(null).setDestination(target.get().getName());
                        ((PushCommand)git.push().setRefSpecs(new RefSpec[]{refSpec}).setRemote("origin").setTransportConfigCallback(this.conn.getCallback())).call();
                        result.add(ImmutableGitFileReload.builder().id(gitFile.getId()).bodyType(AstBody.AstBodyType.TAG).treeValue(gitFile.getTreeValue()).build());
                    } else {
                        String msg = "Can't find tag: " + filter + "!";
                        LOGGER.error(msg);
                    }
                }
                ((PullCommand)git.pull().setTransportConfigCallback(callback)).call().getFetchResult();
                Object treeValue = gitFile.getTreeValue().startsWith(SEPARATOR) ? gitFile.getTreeValue() : SEPARATOR + gitFile.getTreeValue();
                Object absolutePath = this.conn.getAbsolutePath().startsWith(SEPARATOR) ? this.conn.getAbsolutePath() : SEPARATOR + this.conn.getAbsolutePath();
                String fullPath = (String)absolutePath + (String)treeValue;
                LOGGER.debug("Removing assets from git: " + fullPath);
                File file = new File(URI.create("file:" + fullPath));
                boolean deleted = file.delete();
                if (!deleted) {
                    throw new RuntimeException("Cant delete assets from git: " + fullPath);
                }
                git.add().addFilepattern(gitFile.getTreeValue()).call();
            }
            git.commit().setAll(true).setAllowEmpty(false).setMessage(this.getCommitMessage(gitFiles)).setAuthor(creds.getUser(), creds.getEmail()).setCommitter(creds.getUser(), creds.getEmail()).call();
            ((PushCommand)git.push().setTransportConfigCallback(callback)).call();
        }
        catch (Exception e) {
            LOGGER.error("Failed to delete assets: '" + gitFiles.stream().map(GitConfig.GitEntry::getId).reduce((a, b) -> a + "," + b).get() + "'!" + System.lineSeparator() + e.getMessage(), (Throwable)e);
            try {
                git.reset().setMode(ResetCommand.ResetType.HARD).call();
            }
            catch (GitAPIException e1) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        ObjectId end = repo.resolve("HEAD");
        result.addAll(this.diff(start, end));
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private GitConfig conn;

        public Builder git(GitConfig conn) {
            this.conn = conn;
            return this;
        }

        public GitFiles build() {
            HdesAssert.notNull((Object)this.conn, () -> "git connection must be defined!");
            return new GitFiles(this.conn);
        }
    }
}

