/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.client.spi;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.client.api.HdesStore;
import io.resys.hdes.client.spi.GitConfig;
import io.resys.hdes.client.spi.staticresources.StoreEntityLocation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.ehcache.CacheManager;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GitConfig", generator="Immutables")
@Immutable
public final class ImmutableGitConfig
implements GitConfig {
    private final GitConfig.GitInit init;
    private final StoreEntityLocation location;
    private final GitConfig.GitSerializer serializer;
    private final HdesStore.HdesCredsSupplier creds;
    private final CacheManager cacheManager;
    private final String cacheName;
    private final Integer cacheHeap;
    private final String assetsPath;
    private final Path parentPath;
    private final String absolutePath;
    private final String absoluteAssetsPath;
    private final TransportConfigCallback callback;
    private final Git client;

    private ImmutableGitConfig(GitConfig.GitInit init, StoreEntityLocation location, GitConfig.GitSerializer serializer, HdesStore.HdesCredsSupplier creds, CacheManager cacheManager, String cacheName, Integer cacheHeap, String assetsPath, Path parentPath, String absolutePath, String absoluteAssetsPath, TransportConfigCallback callback, Git client) {
        this.init = init;
        this.location = location;
        this.serializer = serializer;
        this.creds = creds;
        this.cacheManager = cacheManager;
        this.cacheName = cacheName;
        this.cacheHeap = cacheHeap;
        this.assetsPath = assetsPath;
        this.parentPath = parentPath;
        this.absolutePath = absolutePath;
        this.absoluteAssetsPath = absoluteAssetsPath;
        this.callback = callback;
        this.client = client;
    }

    @Override
    public GitConfig.GitInit getInit() {
        return this.init;
    }

    @Override
    public StoreEntityLocation getLocation() {
        return this.location;
    }

    @Override
    public GitConfig.GitSerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public HdesStore.HdesCredsSupplier getCreds() {
        return this.creds;
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public Integer getCacheHeap() {
        return this.cacheHeap;
    }

    @Override
    public String getAssetsPath() {
        return this.assetsPath;
    }

    @Override
    public Path getParentPath() {
        return this.parentPath;
    }

    @Override
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    public String getAbsoluteAssetsPath() {
        return this.absoluteAssetsPath;
    }

    @Override
    public TransportConfigCallback getCallback() {
        return this.callback;
    }

    @Override
    public Git getClient() {
        return this.client;
    }

    public final ImmutableGitConfig withInit(GitConfig.GitInit value) {
        if (this.init == value) {
            return this;
        }
        GitConfig.GitInit newValue = Objects.requireNonNull(value, "init");
        return new ImmutableGitConfig(newValue, this.location, this.serializer, this.creds, this.cacheManager, this.cacheName, this.cacheHeap, this.assetsPath, this.parentPath, this.absolutePath, this.absoluteAssetsPath, this.callback, this.client);
    }

    public final ImmutableGitConfig withLocation(StoreEntityLocation value) {
        if (this.location == value) {
            return this;
        }
        StoreEntityLocation newValue = Objects.requireNonNull(value, "location");
        return new ImmutableGitConfig(this.init, newValue, this.serializer, this.creds, this.cacheManager, this.cacheName, this.cacheHeap, this.assetsPath, this.parentPath, this.absolutePath, this.absoluteAssetsPath, this.callback, this.client);
    }

    public final ImmutableGitConfig withSerializer(GitConfig.GitSerializer value) {
        if (this.serializer == value) {
            return this;
        }
        GitConfig.GitSerializer newValue = Objects.requireNonNull(value, "serializer");
        return new ImmutableGitConfig(this.init, this.location, newValue, this.creds, this.cacheManager, this.cacheName, this.cacheHeap, this.assetsPath, this.parentPath, this.absolutePath, this.absoluteAssetsPath, this.callback, this.client);
    }

    public final ImmutableGitConfig withCreds(HdesStore.HdesCredsSupplier value) {
        if (this.creds == value) {
            return this;
        }
        HdesStore.HdesCredsSupplier newValue = Objects.requireNonNull(value, "creds");
        return new ImmutableGitConfig(this.init, this.location, this.serializer, newValue, this.cacheManager, this.cacheName, this.cacheHeap, this.assetsPath, this.parentPath, this.absolutePath, this.absoluteAssetsPath, this.callback, this.client);
    }

    public final ImmutableGitConfig withCacheManager(CacheManager value) {
        if (this.cacheManager == value) {
            return this;
        }
        CacheManager newValue = Objects.requireNonNull(value, "cacheManager");
        return new ImmutableGitConfig(this.init, this.location, this.serializer, this.creds, newValue, this.cacheName, this.cacheHeap, this.assetsPath, this.parentPath, this.absolutePath, this.absoluteAssetsPath, this.callback, this.client);
    }

    public final ImmutableGitConfig withCacheName(String value) {
        String newValue = Objects.requireNonNull(value, "cacheName");
        if (this.cacheName.equals(newValue)) {
            return this;
        }
        return new ImmutableGitConfig(this.init, this.location, this.serializer, this.creds, this.cacheManager, newValue, this.cacheHeap, this.assetsPath, this.parentPath, this.absolutePath, this.absoluteAssetsPath, this.callback, this.client);
    }

    public final ImmutableGitConfig withCacheHeap(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "cacheHeap");
        if (this.cacheHeap.equals(newValue)) {
            return this;
        }
        return new ImmutableGitConfig(this.init, this.location, this.serializer, this.creds, this.cacheManager, this.cacheName, newValue, this.assetsPath, this.parentPath, this.absolutePath, this.absoluteAssetsPath, this.callback, this.client);
    }

    public final ImmutableGitConfig withAssetsPath(String value) {
        String newValue = Objects.requireNonNull(value, "assetsPath");
        if (this.assetsPath.equals(newValue)) {
            return this;
        }
        return new ImmutableGitConfig(this.init, this.location, this.serializer, this.creds, this.cacheManager, this.cacheName, this.cacheHeap, newValue, this.parentPath, this.absolutePath, this.absoluteAssetsPath, this.callback, this.client);
    }

    public final ImmutableGitConfig withParentPath(Path value) {
        if (this.parentPath == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "parentPath");
        return new ImmutableGitConfig(this.init, this.location, this.serializer, this.creds, this.cacheManager, this.cacheName, this.cacheHeap, this.assetsPath, newValue, this.absolutePath, this.absoluteAssetsPath, this.callback, this.client);
    }

    public final ImmutableGitConfig withAbsolutePath(String value) {
        String newValue = Objects.requireNonNull(value, "absolutePath");
        if (this.absolutePath.equals(newValue)) {
            return this;
        }
        return new ImmutableGitConfig(this.init, this.location, this.serializer, this.creds, this.cacheManager, this.cacheName, this.cacheHeap, this.assetsPath, this.parentPath, newValue, this.absoluteAssetsPath, this.callback, this.client);
    }

    public final ImmutableGitConfig withAbsoluteAssetsPath(String value) {
        String newValue = Objects.requireNonNull(value, "absoluteAssetsPath");
        if (this.absoluteAssetsPath.equals(newValue)) {
            return this;
        }
        return new ImmutableGitConfig(this.init, this.location, this.serializer, this.creds, this.cacheManager, this.cacheName, this.cacheHeap, this.assetsPath, this.parentPath, this.absolutePath, newValue, this.callback, this.client);
    }

    public final ImmutableGitConfig withCallback(TransportConfigCallback value) {
        if (this.callback == value) {
            return this;
        }
        TransportConfigCallback newValue = Objects.requireNonNull(value, "callback");
        return new ImmutableGitConfig(this.init, this.location, this.serializer, this.creds, this.cacheManager, this.cacheName, this.cacheHeap, this.assetsPath, this.parentPath, this.absolutePath, this.absoluteAssetsPath, newValue, this.client);
    }

    public final ImmutableGitConfig withClient(Git value) {
        if (this.client == value) {
            return this;
        }
        Git newValue = Objects.requireNonNull(value, "client");
        return new ImmutableGitConfig(this.init, this.location, this.serializer, this.creds, this.cacheManager, this.cacheName, this.cacheHeap, this.assetsPath, this.parentPath, this.absolutePath, this.absoluteAssetsPath, this.callback, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGitConfig && this.equalTo((ImmutableGitConfig)another);
    }

    private boolean equalTo(ImmutableGitConfig another) {
        return this.init.equals(another.init) && this.location.equals(another.location) && this.serializer.equals(another.serializer) && this.creds.equals(another.creds) && this.cacheManager.equals(another.cacheManager) && this.cacheName.equals(another.cacheName) && this.cacheHeap.equals(another.cacheHeap) && this.assetsPath.equals(another.assetsPath) && this.parentPath.equals(another.parentPath) && this.absolutePath.equals(another.absolutePath) && this.absoluteAssetsPath.equals(another.absoluteAssetsPath) && this.callback.equals(another.callback) && this.client.equals(another.client);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.init.hashCode();
        h += (h << 5) + this.location.hashCode();
        h += (h << 5) + this.serializer.hashCode();
        h += (h << 5) + this.creds.hashCode();
        h += (h << 5) + this.cacheManager.hashCode();
        h += (h << 5) + this.cacheName.hashCode();
        h += (h << 5) + this.cacheHeap.hashCode();
        h += (h << 5) + this.assetsPath.hashCode();
        h += (h << 5) + this.parentPath.hashCode();
        h += (h << 5) + this.absolutePath.hashCode();
        h += (h << 5) + this.absoluteAssetsPath.hashCode();
        h += (h << 5) + this.callback.hashCode();
        h += (h << 5) + this.client.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GitConfig").omitNullValues().add("init", (Object)this.init).add("location", (Object)this.location).add("serializer", (Object)this.serializer).add("creds", (Object)this.creds).add("cacheManager", (Object)this.cacheManager).add("cacheName", (Object)this.cacheName).add("cacheHeap", (Object)this.cacheHeap).add("assetsPath", (Object)this.assetsPath).add("parentPath", (Object)this.parentPath).add("absolutePath", (Object)this.absolutePath).add("absoluteAssetsPath", (Object)this.absoluteAssetsPath).add("callback", (Object)this.callback).add("client", (Object)this.client).toString();
    }

    public static ImmutableGitConfig copyOf(GitConfig instance) {
        if (instance instanceof ImmutableGitConfig) {
            return (ImmutableGitConfig)instance;
        }
        return ImmutableGitConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GitConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INIT = 1L;
        private static final long INIT_BIT_LOCATION = 2L;
        private static final long INIT_BIT_SERIALIZER = 4L;
        private static final long INIT_BIT_CREDS = 8L;
        private static final long INIT_BIT_CACHE_MANAGER = 16L;
        private static final long INIT_BIT_CACHE_NAME = 32L;
        private static final long INIT_BIT_CACHE_HEAP = 64L;
        private static final long INIT_BIT_ASSETS_PATH = 128L;
        private static final long INIT_BIT_PARENT_PATH = 256L;
        private static final long INIT_BIT_ABSOLUTE_PATH = 512L;
        private static final long INIT_BIT_ABSOLUTE_ASSETS_PATH = 1024L;
        private static final long INIT_BIT_CALLBACK = 2048L;
        private static final long INIT_BIT_CLIENT = 4096L;
        private long initBits = 8191L;
        @Nullable
        private GitConfig.GitInit init;
        @Nullable
        private StoreEntityLocation location;
        @Nullable
        private GitConfig.GitSerializer serializer;
        @Nullable
        private HdesStore.HdesCredsSupplier creds;
        @Nullable
        private CacheManager cacheManager;
        @Nullable
        private String cacheName;
        @Nullable
        private Integer cacheHeap;
        @Nullable
        private String assetsPath;
        @Nullable
        private Path parentPath;
        @Nullable
        private String absolutePath;
        @Nullable
        private String absoluteAssetsPath;
        @Nullable
        private TransportConfigCallback callback;
        @Nullable
        private Git client;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GitConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.init(instance.getInit());
            this.location(instance.getLocation());
            this.serializer(instance.getSerializer());
            this.creds(instance.getCreds());
            this.cacheManager(instance.getCacheManager());
            this.cacheName(instance.getCacheName());
            this.cacheHeap(instance.getCacheHeap());
            this.assetsPath(instance.getAssetsPath());
            this.parentPath(instance.getParentPath());
            this.absolutePath(instance.getAbsolutePath());
            this.absoluteAssetsPath(instance.getAbsoluteAssetsPath());
            this.callback(instance.getCallback());
            this.client(instance.getClient());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder init(GitConfig.GitInit init) {
            this.init = Objects.requireNonNull(init, "init");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder location(StoreEntityLocation location) {
            this.location = Objects.requireNonNull(location, "location");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serializer(GitConfig.GitSerializer serializer) {
            this.serializer = Objects.requireNonNull(serializer, "serializer");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder creds(HdesStore.HdesCredsSupplier creds) {
            this.creds = Objects.requireNonNull(creds, "creds");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cacheManager(CacheManager cacheManager) {
            this.cacheManager = Objects.requireNonNull(cacheManager, "cacheManager");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cacheName(String cacheName) {
            this.cacheName = Objects.requireNonNull(cacheName, "cacheName");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cacheHeap(Integer cacheHeap) {
            this.cacheHeap = Objects.requireNonNull(cacheHeap, "cacheHeap");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder assetsPath(String assetsPath) {
            this.assetsPath = Objects.requireNonNull(assetsPath, "assetsPath");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parentPath(Path parentPath) {
            this.parentPath = Objects.requireNonNull(parentPath, "parentPath");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder absolutePath(String absolutePath) {
            this.absolutePath = Objects.requireNonNull(absolutePath, "absolutePath");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder absoluteAssetsPath(String absoluteAssetsPath) {
            this.absoluteAssetsPath = Objects.requireNonNull(absoluteAssetsPath, "absoluteAssetsPath");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder callback(TransportConfigCallback callback) {
            this.callback = Objects.requireNonNull(callback, "callback");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder client(Git client) {
            this.client = Objects.requireNonNull(client, "client");
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        public ImmutableGitConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGitConfig(this.init, this.location, this.serializer, this.creds, this.cacheManager, this.cacheName, this.cacheHeap, this.assetsPath, this.parentPath, this.absolutePath, this.absoluteAssetsPath, this.callback, this.client);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("init");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("location");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("serializer");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("creds");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("cacheManager");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("cacheName");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("cacheHeap");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("assetsPath");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("parentPath");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("absolutePath");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("absoluteAssetsPath");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("callback");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("client");
            }
            return "Cannot build GitConfig, some of required attributes are not set " + attributes;
        }
    }
}

