/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.client.spi;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.client.api.ast.AstCommand;
import io.resys.hdes.client.spi.GitConfig;
import io.resys.hdes.client.spi.GitStore;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GitStore.BatchEntry", generator="Immutables")
@Immutable
final class ImmutableBatchEntry
implements GitStore.BatchEntry {
    private final GitConfig.GitFile file;
    private final ImmutableList<AstCommand> body;

    private ImmutableBatchEntry(GitConfig.GitFile file, ImmutableList<AstCommand> body) {
        this.file = file;
        this.body = body;
    }

    @Override
    public GitConfig.GitFile getFile() {
        return this.file;
    }

    public ImmutableList<AstCommand> getBody() {
        return this.body;
    }

    public final ImmutableBatchEntry withFile(GitConfig.GitFile value) {
        if (this.file == value) {
            return this;
        }
        GitConfig.GitFile newValue = Objects.requireNonNull(value, "file");
        return new ImmutableBatchEntry(newValue, this.body);
    }

    public final ImmutableBatchEntry withBody(AstCommand ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableBatchEntry(this.file, (ImmutableList<AstCommand>)newValue);
    }

    public final ImmutableBatchEntry withBody(Iterable<? extends AstCommand> elements) {
        if (this.body == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableBatchEntry(this.file, (ImmutableList<AstCommand>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBatchEntry && this.equalTo((ImmutableBatchEntry)another);
    }

    private boolean equalTo(ImmutableBatchEntry another) {
        return this.file.equals(another.file) && this.body.equals(another.body);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.file.hashCode();
        h += (h << 5) + this.body.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BatchEntry").omitNullValues().add("file", (Object)this.file).add("body", this.body).toString();
    }

    public static ImmutableBatchEntry copyOf(GitStore.BatchEntry instance) {
        if (instance instanceof ImmutableBatchEntry) {
            return (ImmutableBatchEntry)instance;
        }
        return ImmutableBatchEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GitStore.BatchEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FILE = 1L;
        private long initBits = 1L;
        @Nullable
        private GitConfig.GitFile file;
        private ImmutableList.Builder<AstCommand> body = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GitStore.BatchEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.file(instance.getFile());
            this.addAllBody(instance.getBody());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder file(GitConfig.GitFile file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addBody(AstCommand element) {
            this.body.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addBody(AstCommand ... elements) {
            this.body.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder body(Iterable<? extends AstCommand> elements) {
            this.body = ImmutableList.builder();
            return this.addAllBody(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllBody(Iterable<? extends AstCommand> elements) {
            this.body.addAll(elements);
            return this;
        }

        public ImmutableBatchEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBatchEntry(this.file, (ImmutableList<AstCommand>)this.body.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("file");
            }
            return "Cannot build BatchEntry, some of required attributes are not set " + attributes;
        }
    }
}

