/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.client.spi;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.resys.hdes.client.api.HdesStore;
import io.resys.hdes.client.api.ImmutableStoreEntity;
import io.resys.hdes.client.api.ImmutableStoreState;
import io.resys.hdes.client.api.ast.AstBody;
import io.resys.hdes.client.api.ast.AstCommand;
import io.resys.hdes.client.spi.GitConfig;
import io.resys.hdes.client.spi.ImmutableBatchEntry;
import io.resys.hdes.client.spi.ImmutableGitConfig;
import io.resys.hdes.client.spi.ImmutableGitInit;
import io.resys.hdes.client.spi.git.GitConnectionFactory;
import io.resys.hdes.client.spi.git.GitDataSourceLoader;
import io.resys.hdes.client.spi.git.GitFiles;
import io.resys.hdes.client.spi.staticresources.StoreEntityLocation;
import io.resys.hdes.client.spi.util.HdesAssert;
import io.smallrye.mutiny.Uni;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.ehcache.Cache;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitStore
implements HdesStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitStore.class);
    private final GitConfig conn;
    private final Optional<String> branchName;

    public GitStore(GitConfig conn) {
        this.conn = conn;
        this.branchName = Optional.empty();
    }

    public GitStore(GitConfig conn, String branchName) {
        this.conn = conn;
        this.branchName = Optional.ofNullable(branchName);
    }

    public String getRepoName() {
        return this.conn.getInit().getRemote();
    }

    public String getHeadName() {
        return this.conn.getInit().getBranch();
    }

    public Optional<String> getBranchName() {
        return this.branchName;
    }

    public HdesStore withBranch(String branchName) {
        Objects.requireNonNull(branchName, () -> "branchName can't be null!");
        return new GitStore(ImmutableGitConfig.builder().from(this.conn).location(new StoreEntityLocation(this.conn.getAbsoluteAssetsPath(), branchName)).build(), branchName);
    }

    public Uni<List<HdesStore.StoreEntity>> batch(HdesStore.ImportStoreEntity batchType) {
        return Uni.createFrom().item(() -> {
            try {
                ArrayList<GitConfig.GitFile> gitFiles = new ArrayList<GitConfig.GitFile>();
                ArrayList<ImmutableBatchEntry> entries = new ArrayList<ImmutableBatchEntry>();
                GitFiles git = GitFiles.builder().git(this.conn).build();
                for (HdesStore.CreateStoreEntity create : batchType.getCreate()) {
                    GitConfig.GitFile created = git.create(create.getBodyType(), create.getBody());
                    gitFiles.add(created);
                    entries.add(ImmutableBatchEntry.builder().file(created).body(create.getBody()).build());
                }
                for (HdesStore.UpdateStoreEntityWithBodyType update : batchType.getUpdate()) {
                    GitConfig.GitFile updated = git.update(update.getId(), update.getBodyType(), update.getBody());
                    gitFiles.add(updated);
                    entries.add(ImmutableBatchEntry.builder().file(updated).body(update.getBody()).build());
                }
                List<GitConfig.GitFileReload> refresh = git.push(gitFiles);
                this.cache(refresh);
                return entries.stream().map(entry -> ImmutableStoreEntity.builder().id(entry.getFile().getId()).hash(entry.getFile().getBlobHash()).body(entry.getBody()).bodyType(entry.getFile().getBodyType()).build()).collect(Collectors.toList());
            }
            catch (Exception e) {
                LOGGER.error("Failed to run batch:" + System.lineSeparator() + "  - because: " + e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        });
    }

    public Uni<HdesStore.StoreEntity> create(HdesStore.CreateStoreEntity newType) {
        return Uni.createFrom().item(() -> {
            try {
                GitFiles git = GitFiles.builder().git(this.conn).build();
                if (newType.getBodyType() == AstBody.AstBodyType.TAG) {
                    Map.Entry<String, List<GitConfig.GitFileReload>> newTag = git.tag(newType);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Hdes git store, new tag created: '" + newTag.getKey() + "'");
                    }
                }
                GitConfig.GitFile file = git.create(newType.getBodyType(), newType.getBody());
                List<GitConfig.GitFileReload> refresh = git.push(file);
                this.cache(refresh);
                return ImmutableStoreEntity.builder().id(file.getId()).hash(file.getBlobHash()).body((Iterable)newType.getBody()).bodyType(newType.getBodyType()).build();
            }
            catch (Exception e) {
                LOGGER.error("Failed to create store entity: '" + newType.getBodyType() + "'" + System.lineSeparator() + "  - with commands: " + this.conn.getSerializer().write(newType.getBody()) + System.lineSeparator() + "  - because: " + e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        });
    }

    public Uni<HdesStore.StoreEntity> update(HdesStore.UpdateStoreEntity updateType) {
        return this.query().get(updateType.getId()).onItem().transform(oldState -> {
            try {
                HdesAssert.isTrue((oldState.getBodyType() != AstBody.AstBodyType.TAG ? 1 : 0) != 0, () -> "Tags can't be updated!");
                GitFiles git = GitFiles.builder().git(this.conn).build();
                GitConfig.GitFile file = git.update(updateType.getId(), oldState.getBodyType(), updateType.getBody());
                List<GitConfig.GitFileReload> refresh = git.push(file);
                this.cache(refresh);
                return ImmutableStoreEntity.builder().id(file.getId()).hash(file.getBlobHash()).body((Iterable)updateType.getBody()).bodyType(oldState.getBodyType()).build();
            }
            catch (Exception e) {
                LOGGER.error("Failed to update store entity: '" + oldState.getBodyType() + "'" + System.lineSeparator() + "  - with commands: " + this.conn.getSerializer().write(updateType.getBody()) + System.lineSeparator() + "  - because: " + e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        });
    }

    public Uni<List<HdesStore.StoreEntity>> delete(HdesStore.DeleteAstType deleteType) {
        return Uni.createFrom().item(() -> {
            Cache cache = this.conn.getCacheManager().getCache(this.conn.getCacheName(), String.class, GitConfig.GitEntry.class);
            ArrayList<GitConfig.GitEntry> gitFiles = new ArrayList<GitConfig.GitEntry>();
            GitConfig.GitEntry deleteEntry = (GitConfig.GitEntry)cache.get((Object)deleteType.getId());
            if (deleteType.getBodyType().equals((Object)AstBody.AstBodyType.BRANCH)) {
                String branchName = ((AstCommand)deleteEntry.getCommands().stream().filter(c -> c.getType().equals((Object)AstCommand.AstCommandValue.SET_BRANCH_NAME)).collect(Collectors.toList()).get(0)).getValue();
                for (Cache.Entry entry : cache) {
                    String treeValue = ((GitConfig.GitEntry)entry.getValue()).getTreeValue();
                    if (!treeValue.contains(branchName)) continue;
                    gitFiles.add((GitConfig.GitEntry)entry.getValue());
                }
            } else {
                gitFiles.add((GitConfig.GitEntry)cache.get((Object)deleteType.getId()));
            }
            try {
                GitFiles git = GitFiles.builder().git(this.conn).build();
                List<GitConfig.GitFileReload> refresh = git.delete(gitFiles);
                this.cache(refresh);
                return gitFiles.stream().map(gitFile -> ImmutableStoreEntity.builder().id(gitFile.getId()).body(gitFile.getCommands()).bodyType(gitFile.getBodyType()).hash(gitFile.getBlobHash()).build()).collect(Collectors.toList());
            }
            catch (Exception e) {
                LOGGER.error("Failed to delete store entity: '" + gitFiles.stream().map(GitConfig.GitEntry::getBodyType).collect(Collectors.toList()) + "'" + System.lineSeparator() + "  - with commands: " + gitFiles.stream().map(GitConfig.GitEntry::getBlobValue).collect(Collectors.toList()) + System.lineSeparator() + "  - because: " + e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        });
    }

    private void cache(List<GitConfig.GitFileReload> reloads) {
        ObjectId head;
        GitFiles files = GitFiles.builder().git(this.conn).build();
        try {
            Git git = this.conn.getClient();
            Repository repo = git.getRepository();
            head = repo.resolve("HEAD");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load head!" + System.lineSeparator() + e.getMessage(), e);
        }
        Cache cache = this.conn.getCacheManager().getCache(this.conn.getCacheName(), String.class, GitConfig.GitEntry.class);
        for (GitConfig.GitFileReload reload : reloads) {
            if (reload.getFile().isEmpty()) {
                cache.remove((Object)reload.getId());
                continue;
            }
            GitConfig.GitEntry entry = files.readEntry(reload.getFile().get(), head);
            cache.put((Object)entry.getId(), (Object)entry);
        }
    }

    public HdesStore.QueryBuilder query() {
        return new HdesStore.QueryBuilder(){

            private HdesStore.StoreEntity map(GitConfig.GitEntry entry) {
                return ImmutableStoreEntity.builder().id(entry.getId()).bodyType(entry.getBodyType()).body(entry.getCommands()).hash(entry.getBlobHash()).build();
            }

            public Uni<HdesStore.StoreEntity> get(String id) {
                return Uni.createFrom().item(() -> {
                    Cache cache = GitStore.this.conn.getCacheManager().getCache(GitStore.this.conn.getCacheName(), String.class, GitConfig.GitEntry.class);
                    GitConfig.GitEntry entity = (GitConfig.GitEntry)cache.get((Object)id);
                    HdesAssert.notFound((Object)entity, () -> "Entity was not found by id: '" + id + "'!");
                    return this.map(entity);
                });
            }

            public Uni<HdesStore.StoreState> get() {
                return Uni.createFrom().item(() -> {
                    ImmutableStoreState.Builder state = ImmutableStoreState.builder();
                    Cache cache = GitStore.this.conn.getCacheManager().getCache(GitStore.this.conn.getCacheName(), String.class, GitConfig.GitEntry.class);
                    block7: for (Cache.Entry entry : cache) {
                        HdesStore.StoreEntity mapped = this.map((GitConfig.GitEntry)entry.getValue());
                        String treeValue = ((GitConfig.GitEntry)entry.getValue()).getTreeValue();
                        boolean isBranchSpecified = GitStore.this.branchName.isPresent();
                        boolean assetBelongsToABranch = treeValue.contains("_dev");
                        boolean assetOnDefaultBranch = !isBranchSpecified && !assetBelongsToABranch;
                        boolean assetOnCurrentBranch = isBranchSpecified && Arrays.asList(treeValue.split("/")).contains(GitStore.this.branchName.get());
                        switch (mapped.getBodyType()) {
                            case FLOW: {
                                if (!assetOnDefaultBranch && !assetOnCurrentBranch) continue block7;
                                state.putFlows((String)entry.getKey(), this.map((GitConfig.GitEntry)entry.getValue()));
                                continue block7;
                            }
                            case FLOW_TASK: {
                                if (!assetOnDefaultBranch && !assetOnCurrentBranch) continue block7;
                                state.putServices((String)entry.getKey(), this.map((GitConfig.GitEntry)entry.getValue()));
                                continue block7;
                            }
                            case DT: {
                                if (!assetOnDefaultBranch && !assetOnCurrentBranch) continue block7;
                                state.putDecisions((String)entry.getKey(), this.map((GitConfig.GitEntry)entry.getValue()));
                                continue block7;
                            }
                            case TAG: {
                                state.putTags((String)entry.getKey(), this.map((GitConfig.GitEntry)entry.getValue()));
                                continue block7;
                            }
                            case BRANCH: {
                                state.putBranches((String)entry.getKey(), this.map((GitConfig.GitEntry)entry.getValue()));
                                continue block7;
                            }
                        }
                        throw new RuntimeException("Unknown body type: '" + mapped.getBodyType() + "'!");
                    }
                    return state.build();
                });
            }
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    public HdesStore.HistoryQuery history() {
        throw new RuntimeException("not implemented");
    }

    public HdesStore.StoreRepoBuilder repo() {
        throw new RuntimeException("not implemented");
    }

    public static class Builder {
        private String remote;
        private String branch;
        private String storage;
        private String sshPath;
        private ObjectMapper objectMapper;
        private HdesStore.HdesCredsSupplier creds;

        public Builder remote(String remote) {
            this.remote = remote;
            return this;
        }

        public Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public Builder storage(String storage) {
            this.storage = storage;
            return this;
        }

        public Builder sshPath(String sshPath) {
            this.sshPath = sshPath;
            return this;
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder creds(HdesStore.HdesCredsSupplier creds) {
            this.creds = creds;
            return this;
        }

        public GitStore build() {
            GitConfig conn;
            HdesAssert.notNull((Object)this.objectMapper, () -> "objectMapper must be defined!");
            HdesAssert.notNull((Object)this.creds, () -> "creds must be defined!");
            if (LOGGER.isDebugEnabled()) {
                StringBuilder log = new StringBuilder().append(System.lineSeparator()).append("Configuring GIT: ").append(System.lineSeparator()).append("  remote: '").append(this.remote).append("'").append(System.lineSeparator()).append("  branch: '").append(this.branch).append("'").append(System.lineSeparator()).append("  storage: '").append(this.storage).append("'").append(System.lineSeparator()).append("  sshPath: '").append(this.sshPath).append("'").append(System.lineSeparator());
                LOGGER.debug(log.toString());
            }
            HdesAssert.notEmpty((String)this.remote, () -> "remote must be defined! Example of the remote: 'ssh://git@git.resys.io:22222/wrench/wrench-demo-assets.git'");
            HdesAssert.notEmpty((String)this.branch, () -> "branch must be defined! Example of the branch: 'main'");
            HdesAssert.notEmpty((String)this.storage, () -> "storage must be defined! Storage is the path to what to clone the repository, example: '/home/olev/Development/wrench-demo-assets'");
            HdesAssert.notEmpty((String)this.sshPath, () -> "sshPath must be defined! SshPath must contain 2 files(classpath or folder), private key and known host: 'id_rsa', 'id_rsa.known_hosts'. Classpath example: 'classpath:ssh/id_rsa'");
            ImmutableGitInit init = ImmutableGitInit.builder().branch(this.branch).remote(this.remote).storage(this.storage).sshPath(this.sshPath).build();
            try {
                conn = GitConnectionFactory.create(init, this.creds, this.objectMapper);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2.getMessage(), e2);
            }
            if (LOGGER.isDebugEnabled()) {
                StringBuilder log = new StringBuilder().append(System.lineSeparator()).append("Configured GIT: ").append(System.lineSeparator()).append("  cloned into directory: '").append(conn.getParentPath()).append("'").append(System.lineSeparator()).append("  working directory: '").append(conn.getAbsolutePath()).append("'").append(System.lineSeparator()).append("  assets directory: '").append(conn.getAbsoluteAssetsPath()).append("'").append(System.lineSeparator()).append("  relative assets directory: '").append(conn.getAssetsPath()).append("'").append(System.lineSeparator()).append("  cache name: '").append(conn.getCacheName()).append("'").append(System.lineSeparator()).append("  cache size/heap: '").append(conn.getCacheHeap()).append("'").append(System.lineSeparator());
                LOGGER.debug(log.toString());
            }
            Cache cache = conn.getCacheManager().getCache(conn.getCacheName(), String.class, GitConfig.GitEntry.class);
            try (GitDataSourceLoader loader = new GitDataSourceLoader(conn);){
                loader.read().forEach(e -> cache.put((Object)e.getId(), e));
            }
            catch (Exception e3) {
                throw new RuntimeException(e3.getMessage(), e3);
            }
            return new GitStore(conn);
        }
    }

    @Value.Immutable
    static interface BatchEntry {
        public GitConfig.GitFile getFile();

        public List<AstCommand> getBody();
    }

    static interface FileMarker {
        public String getAbsolutePath();
    }
}

