/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.client.spi.git;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import io.resys.hdes.client.api.HdesStore;
import io.resys.hdes.client.spi.GitConfig;
import io.resys.hdes.client.spi.ImmutableGitConfig;
import io.resys.hdes.client.spi.git.GitSerializerImpl;
import io.resys.hdes.client.spi.staticresources.StoreEntityLocation;
import io.resys.hdes.client.spi.util.FileUtils;
import io.resys.hdes.client.spi.util.HdesAssert;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.util.FS;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class GitConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitConnectionFactory.class);

    public static GitConfig create(GitConfig.GitInit config, HdesStore.HdesCredsSupplier creds, ObjectMapper objectMapper) throws IOException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException, CheckoutConflictException, GitAPIException {
        Git git;
        Path path = StringUtils.isEmpty((CharSequence)config.getRemote()) ? Files.createTempDirectory("git_repo", new FileAttribute[0]) : new File(config.getStorage()).toPath();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        File privateKey = GitConnectionFactory.copyKey((ResourcePatternResolver)resolver, path, config.getSshPath(), "id_rsa", "Define git respository private key for assets");
        File knownHosts = GitConnectionFactory.copyKey((ResourcePatternResolver)resolver, path, config.getSshPath() + ".known_hosts", "id_rsa.known_hosts", "Define git respository known hosts for assets");
        SshSessionFactory sshSessionFactory = GitConnectionFactory.createSshSessionFactory(privateKey, knownHosts);
        File clone = new File(path + "/clone");
        TransportConfigCallback callback = transport -> ((SshTransport)transport).setSshSessionFactory(sshSessionFactory);
        if (clone.exists()) {
            LOGGER.debug("Checking out branch: {}", (Object)config.getBranch());
            git = Git.open((File)clone);
            if (!git.getRepository().getBranch().equals(config.getBranch())) {
                git.reset().setMode(ResetCommand.ResetType.HARD).call();
                git.checkout().setName(config.getBranch()).call();
                ((PullCommand)git.pull().setTransportConfigCallback(callback)).call();
            }
        } else {
            LOGGER.debug("Cloning new repository branch: {}", (Object)config.getBranch());
            git = ((CloneCommand)Git.cloneRepository().setURI(config.getRemote()).setDirectory(new File(path + "/clone")).setBranch(config.getBranch()).setTransportConfigCallback(callback)).call();
        }
        git.getRepository().getRefDatabase().getRefsByPrefix("refs/tags/");
        String assetPath = "src/main/resources/assets/";
        String absolutePath = git.getRepository().getWorkTree().getAbsolutePath();
        String absoluteAssetPath = "/" + FileUtils.cleanPath((String)absolutePath) + "/src/main/resources/assets/";
        String cacheName = GitConnectionFactory.class.getCanonicalName();
        int cacheHeap = 200;
        CacheManager cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withCache(cacheName, (Builder)CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, GitConfig.GitEntry.class, (Builder)ResourcePoolsBuilder.heap((long)200L))).build();
        cacheManager.init();
        return ImmutableGitConfig.builder().init(config).serializer(new GitSerializerImpl(objectMapper)).client(git).location(new StoreEntityLocation(absoluteAssetPath)).cacheManager(cacheManager).cacheName(cacheName).cacheHeap(200).parentPath(path).callback(callback).absolutePath(absolutePath).absoluteAssetsPath(absoluteAssetPath).assetsPath("src/main/resources/assets/").creds(creds).build();
    }

    private static File copyKey(ResourcePatternResolver resolver, Path path, String src, String target, String errorMsg) throws IOException {
        File result = new File(path.toFile(), target);
        LOGGER.debug("Reading private key from: " + src);
        Resource resource = resolver.getResource(src);
        HdesAssert.isTrue((boolean)resource.exists(), () -> errorMsg + ": " + src);
        InputStream stream = resource.getInputStream();
        LOGGER.debug("Writing private key to: " + result.getPath());
        if (result.exists()) {
            result.delete();
        }
        result.getParentFile().mkdirs();
        result.createNewFile();
        IOUtils.copy((InputStream)stream, (OutputStream)new FileOutputStream(result));
        stream.close();
        return result;
    }

    private static SshSessionFactory createSshSessionFactory(final File privateKey, final File knownHosts) {
        return new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host host, Session session) {
            }

            protected JSch createDefaultJSch(FS fs) throws JSchException {
                JSch defaultJSch = new JSch();
                GitConnectionFactory.configureKnownHosts(defaultJSch, fs, knownHosts);
                defaultJSch.addIdentity(privateKey.getAbsolutePath());
                return defaultJSch;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureKnownHosts(JSch sch, FS fs, File knownHosts) throws JSchException {
        File home = fs.userHome();
        if (home == null) {
            return;
        }
        try (FileInputStream in = new FileInputStream(knownHosts);){
            sch.setKnownHosts((InputStream)in);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

