/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.client.spi;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.client.spi.GitConfig;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GitConfig.GitInit", generator="Immutables")
@Immutable
public final class ImmutableGitInit
implements GitConfig.GitInit {
    private final String branch;
    private final String remote;
    private final String sshPath;
    private final String storage;

    private ImmutableGitInit(String branch, String remote, String sshPath, String storage) {
        this.branch = branch;
        this.remote = remote;
        this.sshPath = sshPath;
        this.storage = storage;
    }

    @Override
    public String getBranch() {
        return this.branch;
    }

    @Override
    public String getRemote() {
        return this.remote;
    }

    @Override
    public String getSshPath() {
        return this.sshPath;
    }

    @Override
    public String getStorage() {
        return this.storage;
    }

    public final ImmutableGitInit withBranch(String value) {
        String newValue = Objects.requireNonNull(value, "branch");
        if (this.branch.equals(newValue)) {
            return this;
        }
        return new ImmutableGitInit(newValue, this.remote, this.sshPath, this.storage);
    }

    public final ImmutableGitInit withRemote(String value) {
        String newValue = Objects.requireNonNull(value, "remote");
        if (this.remote.equals(newValue)) {
            return this;
        }
        return new ImmutableGitInit(this.branch, newValue, this.sshPath, this.storage);
    }

    public final ImmutableGitInit withSshPath(String value) {
        String newValue = Objects.requireNonNull(value, "sshPath");
        if (this.sshPath.equals(newValue)) {
            return this;
        }
        return new ImmutableGitInit(this.branch, this.remote, newValue, this.storage);
    }

    public final ImmutableGitInit withStorage(String value) {
        String newValue = Objects.requireNonNull(value, "storage");
        if (this.storage.equals(newValue)) {
            return this;
        }
        return new ImmutableGitInit(this.branch, this.remote, this.sshPath, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGitInit && this.equalTo((ImmutableGitInit)another);
    }

    private boolean equalTo(ImmutableGitInit another) {
        return this.branch.equals(another.branch) && this.remote.equals(another.remote) && this.sshPath.equals(another.sshPath) && this.storage.equals(another.storage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.branch.hashCode();
        h += (h << 5) + this.remote.hashCode();
        h += (h << 5) + this.sshPath.hashCode();
        h += (h << 5) + this.storage.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GitInit").omitNullValues().add("branch", (Object)this.branch).add("remote", (Object)this.remote).add("sshPath", (Object)this.sshPath).add("storage", (Object)this.storage).toString();
    }

    public static ImmutableGitInit copyOf(GitConfig.GitInit instance) {
        if (instance instanceof ImmutableGitInit) {
            return (ImmutableGitInit)instance;
        }
        return ImmutableGitInit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GitConfig.GitInit", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BRANCH = 1L;
        private static final long INIT_BIT_REMOTE = 2L;
        private static final long INIT_BIT_SSH_PATH = 4L;
        private static final long INIT_BIT_STORAGE = 8L;
        private long initBits = 15L;
        @Nullable
        private String branch;
        @Nullable
        private String remote;
        @Nullable
        private String sshPath;
        @Nullable
        private String storage;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GitConfig.GitInit instance) {
            Objects.requireNonNull(instance, "instance");
            this.branch(instance.getBranch());
            this.remote(instance.getRemote());
            this.sshPath(instance.getSshPath());
            this.storage(instance.getStorage());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder branch(String branch) {
            this.branch = Objects.requireNonNull(branch, "branch");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder remote(String remote) {
            this.remote = Objects.requireNonNull(remote, "remote");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sshPath(String sshPath) {
            this.sshPath = Objects.requireNonNull(sshPath, "sshPath");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder storage(String storage) {
            this.storage = Objects.requireNonNull(storage, "storage");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableGitInit build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGitInit(this.branch, this.remote, this.sshPath, this.storage);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("branch");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("remote");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sshPath");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("storage");
            }
            return "Cannot build GitInit, some of required attributes are not set " + attributes;
        }
    }
}

