/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.client.spi;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.client.api.ast.AstBody;
import io.resys.hdes.client.spi.GitConfig;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GitConfig.GitFileReload", generator="Immutables")
@Immutable
public final class ImmutableGitFileReload
implements GitConfig.GitFileReload {
    private final String treeValue;
    private final String id;
    private final AstBody.AstBodyType bodyType;
    @Nullable
    private final GitConfig.GitFile file;

    private ImmutableGitFileReload(String treeValue, String id, AstBody.AstBodyType bodyType, @Nullable GitConfig.GitFile file) {
        this.treeValue = treeValue;
        this.id = id;
        this.bodyType = bodyType;
        this.file = file;
    }

    @Override
    public String getTreeValue() {
        return this.treeValue;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public AstBody.AstBodyType getBodyType() {
        return this.bodyType;
    }

    @Override
    public Optional<GitConfig.GitFile> getFile() {
        return Optional.ofNullable(this.file);
    }

    public final ImmutableGitFileReload withTreeValue(String value) {
        String newValue = Objects.requireNonNull(value, "treeValue");
        if (this.treeValue.equals(newValue)) {
            return this;
        }
        return new ImmutableGitFileReload(newValue, this.id, this.bodyType, this.file);
    }

    public final ImmutableGitFileReload withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableGitFileReload(this.treeValue, newValue, this.bodyType, this.file);
    }

    public final ImmutableGitFileReload withBodyType(AstBody.AstBodyType value) {
        if (this.bodyType == value) {
            return this;
        }
        AstBody.AstBodyType newValue = Objects.requireNonNull(value, "bodyType");
        if (this.bodyType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableGitFileReload(this.treeValue, this.id, newValue, this.file);
    }

    public final ImmutableGitFileReload withFile(GitConfig.GitFile value) {
        GitConfig.GitFile newValue = Objects.requireNonNull(value, "file");
        if (this.file == newValue) {
            return this;
        }
        return new ImmutableGitFileReload(this.treeValue, this.id, this.bodyType, newValue);
    }

    public final ImmutableGitFileReload withFile(Optional<? extends GitConfig.GitFile> optional) {
        GitConfig.GitFile value = optional.orElse(null);
        if (this.file == value) {
            return this;
        }
        return new ImmutableGitFileReload(this.treeValue, this.id, this.bodyType, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGitFileReload && this.equalTo((ImmutableGitFileReload)another);
    }

    private boolean equalTo(ImmutableGitFileReload another) {
        return this.treeValue.equals(another.treeValue) && this.id.equals(another.id) && this.bodyType.equals((Object)another.bodyType) && Objects.equals(this.file, another.file);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.treeValue.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.bodyType.hashCode();
        h += (h << 5) + Objects.hashCode(this.file);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GitFileReload").omitNullValues().add("treeValue", (Object)this.treeValue).add("id", (Object)this.id).add("bodyType", (Object)this.bodyType).add("file", (Object)this.file).toString();
    }

    public static ImmutableGitFileReload copyOf(GitConfig.GitFileReload instance) {
        if (instance instanceof ImmutableGitFileReload) {
            return (ImmutableGitFileReload)instance;
        }
        return ImmutableGitFileReload.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GitConfig.GitFileReload", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TREE_VALUE = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_BODY_TYPE = 4L;
        private long initBits = 7L;
        @Nullable
        private String treeValue;
        @Nullable
        private String id;
        @Nullable
        private AstBody.AstBodyType bodyType;
        @Nullable
        private GitConfig.GitFile file;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GitConfig.GitFileReload instance) {
            Objects.requireNonNull(instance, "instance");
            this.treeValue(instance.getTreeValue());
            this.id(instance.getId());
            this.bodyType(instance.getBodyType());
            Optional<GitConfig.GitFile> fileOptional = instance.getFile();
            if (fileOptional.isPresent()) {
                this.file(fileOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder treeValue(String treeValue) {
            this.treeValue = Objects.requireNonNull(treeValue, "treeValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bodyType(AstBody.AstBodyType bodyType) {
            this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder file(GitConfig.GitFile file) {
            this.file = Objects.requireNonNull(file, "file");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder file(Optional<? extends GitConfig.GitFile> file) {
            this.file = file.orElse(null);
            return this;
        }

        public ImmutableGitFileReload build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGitFileReload(this.treeValue, this.id, this.bodyType, this.file);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("treeValue");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("bodyType");
            }
            return "Cannot build GitFileReload, some of required attributes are not set " + attributes;
        }
    }
}

