/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.client.spi;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.client.api.ast.AstBody;
import io.resys.hdes.client.spi.GitConfig;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GitConfig.GitFile", generator="Immutables")
@Immutable
public final class ImmutableGitFile
implements GitConfig.GitFile {
    private final String id;
    private final String treeValue;
    private final String blobValue;
    private final String blobHash;
    private final AstBody.AstBodyType bodyType;

    private ImmutableGitFile(String id, String treeValue, String blobValue, String blobHash, AstBody.AstBodyType bodyType) {
        this.id = id;
        this.treeValue = treeValue;
        this.blobValue = blobValue;
        this.blobHash = blobHash;
        this.bodyType = bodyType;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTreeValue() {
        return this.treeValue;
    }

    @Override
    public String getBlobValue() {
        return this.blobValue;
    }

    @Override
    public String getBlobHash() {
        return this.blobHash;
    }

    @Override
    public AstBody.AstBodyType getBodyType() {
        return this.bodyType;
    }

    public final ImmutableGitFile withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableGitFile(newValue, this.treeValue, this.blobValue, this.blobHash, this.bodyType);
    }

    public final ImmutableGitFile withTreeValue(String value) {
        String newValue = Objects.requireNonNull(value, "treeValue");
        if (this.treeValue.equals(newValue)) {
            return this;
        }
        return new ImmutableGitFile(this.id, newValue, this.blobValue, this.blobHash, this.bodyType);
    }

    public final ImmutableGitFile withBlobValue(String value) {
        String newValue = Objects.requireNonNull(value, "blobValue");
        if (this.blobValue.equals(newValue)) {
            return this;
        }
        return new ImmutableGitFile(this.id, this.treeValue, newValue, this.blobHash, this.bodyType);
    }

    public final ImmutableGitFile withBlobHash(String value) {
        String newValue = Objects.requireNonNull(value, "blobHash");
        if (this.blobHash.equals(newValue)) {
            return this;
        }
        return new ImmutableGitFile(this.id, this.treeValue, this.blobValue, newValue, this.bodyType);
    }

    public final ImmutableGitFile withBodyType(AstBody.AstBodyType value) {
        if (this.bodyType == value) {
            return this;
        }
        AstBody.AstBodyType newValue = Objects.requireNonNull(value, "bodyType");
        if (this.bodyType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableGitFile(this.id, this.treeValue, this.blobValue, this.blobHash, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGitFile && this.equalTo((ImmutableGitFile)another);
    }

    private boolean equalTo(ImmutableGitFile another) {
        return this.id.equals(another.id) && this.treeValue.equals(another.treeValue) && this.blobValue.equals(another.blobValue) && this.blobHash.equals(another.blobHash) && this.bodyType.equals((Object)another.bodyType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.treeValue.hashCode();
        h += (h << 5) + this.blobValue.hashCode();
        h += (h << 5) + this.blobHash.hashCode();
        h += (h << 5) + this.bodyType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GitFile").omitNullValues().add("id", (Object)this.id).add("treeValue", (Object)this.treeValue).add("blobValue", (Object)this.blobValue).add("blobHash", (Object)this.blobHash).add("bodyType", (Object)this.bodyType).toString();
    }

    public static ImmutableGitFile copyOf(GitConfig.GitFile instance) {
        if (instance instanceof ImmutableGitFile) {
            return (ImmutableGitFile)instance;
        }
        return ImmutableGitFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GitConfig.GitFile", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TREE_VALUE = 2L;
        private static final long INIT_BIT_BLOB_VALUE = 4L;
        private static final long INIT_BIT_BLOB_HASH = 8L;
        private static final long INIT_BIT_BODY_TYPE = 16L;
        private long initBits = 31L;
        @Nullable
        private String id;
        @Nullable
        private String treeValue;
        @Nullable
        private String blobValue;
        @Nullable
        private String blobHash;
        @Nullable
        private AstBody.AstBodyType bodyType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GitConfig.GitFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.treeValue(instance.getTreeValue());
            this.blobValue(instance.getBlobValue());
            this.blobHash(instance.getBlobHash());
            this.bodyType(instance.getBodyType());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder treeValue(String treeValue) {
            this.treeValue = Objects.requireNonNull(treeValue, "treeValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blobValue(String blobValue) {
            this.blobValue = Objects.requireNonNull(blobValue, "blobValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blobHash(String blobHash) {
            this.blobHash = Objects.requireNonNull(blobHash, "blobHash");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bodyType(AstBody.AstBodyType bodyType) {
            this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableGitFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGitFile(this.id, this.treeValue, this.blobValue, this.blobHash, this.bodyType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("treeValue");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("blobValue");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("blobHash");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("bodyType");
            }
            return "Cannot build GitFile, some of required attributes are not set " + attributes;
        }
    }
}

