/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.client.spi;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.client.api.ast.AstBody;
import io.resys.hdes.client.api.ast.AstCommand;
import io.resys.hdes.client.spi.GitConfig;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GitConfig.GitEntry", generator="Immutables")
@Immutable
public final class ImmutableGitEntry
implements GitConfig.GitEntry {
    private final String id;
    private final Timestamp created;
    private final Timestamp modified;
    private final AstBody.AstBodyType bodyType;
    private final String revision;
    private final String blobHash;
    private final String treeValue;
    private final String blobValue;
    private final ImmutableList<AstCommand> commands;

    private ImmutableGitEntry(String id, Timestamp created, Timestamp modified, AstBody.AstBodyType bodyType, String revision, String blobHash, String treeValue, String blobValue, ImmutableList<AstCommand> commands) {
        this.id = id;
        this.created = created;
        this.modified = modified;
        this.bodyType = bodyType;
        this.revision = revision;
        this.blobHash = blobHash;
        this.treeValue = treeValue;
        this.blobValue = blobValue;
        this.commands = commands;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Timestamp getCreated() {
        return this.created;
    }

    @Override
    public Timestamp getModified() {
        return this.modified;
    }

    @Override
    public AstBody.AstBodyType getBodyType() {
        return this.bodyType;
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    @Override
    public String getBlobHash() {
        return this.blobHash;
    }

    @Override
    public String getTreeValue() {
        return this.treeValue;
    }

    @Override
    public String getBlobValue() {
        return this.blobValue;
    }

    public ImmutableList<AstCommand> getCommands() {
        return this.commands;
    }

    public final ImmutableGitEntry withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableGitEntry(newValue, this.created, this.modified, this.bodyType, this.revision, this.blobHash, this.treeValue, this.blobValue, this.commands);
    }

    public final ImmutableGitEntry withCreated(Timestamp value) {
        if (this.created == value) {
            return this;
        }
        Timestamp newValue = Objects.requireNonNull(value, "created");
        return new ImmutableGitEntry(this.id, newValue, this.modified, this.bodyType, this.revision, this.blobHash, this.treeValue, this.blobValue, this.commands);
    }

    public final ImmutableGitEntry withModified(Timestamp value) {
        if (this.modified == value) {
            return this;
        }
        Timestamp newValue = Objects.requireNonNull(value, "modified");
        return new ImmutableGitEntry(this.id, this.created, newValue, this.bodyType, this.revision, this.blobHash, this.treeValue, this.blobValue, this.commands);
    }

    public final ImmutableGitEntry withBodyType(AstBody.AstBodyType value) {
        if (this.bodyType == value) {
            return this;
        }
        AstBody.AstBodyType newValue = Objects.requireNonNull(value, "bodyType");
        if (this.bodyType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableGitEntry(this.id, this.created, this.modified, newValue, this.revision, this.blobHash, this.treeValue, this.blobValue, this.commands);
    }

    public final ImmutableGitEntry withRevision(String value) {
        String newValue = Objects.requireNonNull(value, "revision");
        if (this.revision.equals(newValue)) {
            return this;
        }
        return new ImmutableGitEntry(this.id, this.created, this.modified, this.bodyType, newValue, this.blobHash, this.treeValue, this.blobValue, this.commands);
    }

    public final ImmutableGitEntry withBlobHash(String value) {
        String newValue = Objects.requireNonNull(value, "blobHash");
        if (this.blobHash.equals(newValue)) {
            return this;
        }
        return new ImmutableGitEntry(this.id, this.created, this.modified, this.bodyType, this.revision, newValue, this.treeValue, this.blobValue, this.commands);
    }

    public final ImmutableGitEntry withTreeValue(String value) {
        String newValue = Objects.requireNonNull(value, "treeValue");
        if (this.treeValue.equals(newValue)) {
            return this;
        }
        return new ImmutableGitEntry(this.id, this.created, this.modified, this.bodyType, this.revision, this.blobHash, newValue, this.blobValue, this.commands);
    }

    public final ImmutableGitEntry withBlobValue(String value) {
        String newValue = Objects.requireNonNull(value, "blobValue");
        if (this.blobValue.equals(newValue)) {
            return this;
        }
        return new ImmutableGitEntry(this.id, this.created, this.modified, this.bodyType, this.revision, this.blobHash, this.treeValue, newValue, this.commands);
    }

    public final ImmutableGitEntry withCommands(AstCommand ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableGitEntry(this.id, this.created, this.modified, this.bodyType, this.revision, this.blobHash, this.treeValue, this.blobValue, (ImmutableList<AstCommand>)newValue);
    }

    public final ImmutableGitEntry withCommands(Iterable<? extends AstCommand> elements) {
        if (this.commands == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableGitEntry(this.id, this.created, this.modified, this.bodyType, this.revision, this.blobHash, this.treeValue, this.blobValue, (ImmutableList<AstCommand>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGitEntry && this.equalTo((ImmutableGitEntry)another);
    }

    private boolean equalTo(ImmutableGitEntry another) {
        return this.id.equals(another.id) && this.created.equals(another.created) && this.modified.equals(another.modified) && this.bodyType.equals((Object)another.bodyType) && this.revision.equals(another.revision) && this.blobHash.equals(another.blobHash) && this.treeValue.equals(another.treeValue) && this.blobValue.equals(another.blobValue) && this.commands.equals(another.commands);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + this.modified.hashCode();
        h += (h << 5) + this.bodyType.hashCode();
        h += (h << 5) + this.revision.hashCode();
        h += (h << 5) + this.blobHash.hashCode();
        h += (h << 5) + this.treeValue.hashCode();
        h += (h << 5) + this.blobValue.hashCode();
        h += (h << 5) + this.commands.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GitEntry").omitNullValues().add("id", (Object)this.id).add("created", (Object)this.created).add("modified", (Object)this.modified).add("bodyType", (Object)this.bodyType).add("revision", (Object)this.revision).add("blobHash", (Object)this.blobHash).add("treeValue", (Object)this.treeValue).add("blobValue", (Object)this.blobValue).add("commands", this.commands).toString();
    }

    public static ImmutableGitEntry copyOf(GitConfig.GitEntry instance) {
        if (instance instanceof ImmutableGitEntry) {
            return (ImmutableGitEntry)instance;
        }
        return ImmutableGitEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GitConfig.GitEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_CREATED = 2L;
        private static final long INIT_BIT_MODIFIED = 4L;
        private static final long INIT_BIT_BODY_TYPE = 8L;
        private static final long INIT_BIT_REVISION = 16L;
        private static final long INIT_BIT_BLOB_HASH = 32L;
        private static final long INIT_BIT_TREE_VALUE = 64L;
        private static final long INIT_BIT_BLOB_VALUE = 128L;
        private long initBits = 255L;
        @Nullable
        private String id;
        @Nullable
        private Timestamp created;
        @Nullable
        private Timestamp modified;
        @Nullable
        private AstBody.AstBodyType bodyType;
        @Nullable
        private String revision;
        @Nullable
        private String blobHash;
        @Nullable
        private String treeValue;
        @Nullable
        private String blobValue;
        private ImmutableList.Builder<AstCommand> commands = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GitConfig.GitEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.created(instance.getCreated());
            this.modified(instance.getModified());
            this.bodyType(instance.getBodyType());
            this.revision(instance.getRevision());
            this.blobHash(instance.getBlobHash());
            this.treeValue(instance.getTreeValue());
            this.blobValue(instance.getBlobValue());
            this.addAllCommands(instance.getCommands());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder created(Timestamp created) {
            this.created = Objects.requireNonNull(created, "created");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder modified(Timestamp modified) {
            this.modified = Objects.requireNonNull(modified, "modified");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bodyType(AstBody.AstBodyType bodyType) {
            this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder revision(String revision) {
            this.revision = Objects.requireNonNull(revision, "revision");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blobHash(String blobHash) {
            this.blobHash = Objects.requireNonNull(blobHash, "blobHash");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder treeValue(String treeValue) {
            this.treeValue = Objects.requireNonNull(treeValue, "treeValue");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blobValue(String blobValue) {
            this.blobValue = Objects.requireNonNull(blobValue, "blobValue");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCommands(AstCommand element) {
            this.commands.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCommands(AstCommand ... elements) {
            this.commands.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commands(Iterable<? extends AstCommand> elements) {
            this.commands = ImmutableList.builder();
            return this.addAllCommands(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCommands(Iterable<? extends AstCommand> elements) {
            this.commands.addAll(elements);
            return this;
        }

        public ImmutableGitEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGitEntry(this.id, this.created, this.modified, this.bodyType, this.revision, this.blobHash, this.treeValue, this.blobValue, (ImmutableList<AstCommand>)this.commands.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("created");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("modified");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("bodyType");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("revision");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("blobHash");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("treeValue");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("blobValue");
            }
            return "Cannot build GitEntry, some of required attributes are not set " + attributes;
        }
    }
}

