/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.client.spi;

import io.resys.hdes.client.api.HdesStore;
import io.resys.hdes.client.api.ast.AstBody;
import io.resys.hdes.client.api.ast.AstCommand;
import io.resys.hdes.client.spi.staticresources.StoreEntityLocation;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.ehcache.CacheManager;
import org.immutables.value.Value;

@Value.Immutable
public interface GitConfig {
    public GitInit getInit();

    public StoreEntityLocation getLocation();

    public GitSerializer getSerializer();

    public HdesStore.HdesCredsSupplier getCreds();

    public CacheManager getCacheManager();

    public String getCacheName();

    public Integer getCacheHeap();

    public String getAssetsPath();

    public Path getParentPath();

    public String getAbsolutePath();

    public String getAbsoluteAssetsPath();

    public TransportConfigCallback getCallback();

    public Git getClient();

    @Value.Immutable
    public static interface GitFile {
        public String getId();

        public String getTreeValue();

        public String getBlobValue();

        public String getBlobHash();

        public AstBody.AstBodyType getBodyType();
    }

    @Value.Immutable
    public static interface GitFileReload {
        public String getTreeValue();

        public String getId();

        public AstBody.AstBodyType getBodyType();

        public Optional<GitFile> getFile();
    }

    public static interface GitSerializer {
        public List<AstCommand> read(String var1);

        public String write(List<AstCommand> var1);
    }

    @Value.Immutable
    public static interface GitEntry {
        public String getId();

        public Timestamp getCreated();

        public Timestamp getModified();

        public AstBody.AstBodyType getBodyType();

        public String getRevision();

        public String getBlobHash();

        public String getTreeValue();

        public String getBlobValue();

        public List<AstCommand> getCommands();
    }

    @Value.Immutable
    public static interface GitInit {
        public String getBranch();

        public String getRemote();

        public String getSshPath();

        public String getStorage();
    }
}

