/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.client.spi.git;

import io.resys.hdes.client.api.ast.AstBody;
import io.resys.hdes.client.spi.GitConfig;
import io.resys.hdes.client.spi.ImmutableGitFile;
import io.resys.hdes.client.spi.git.GitFiles;
import io.resys.hdes.client.spi.staticresources.Sha2;
import io.resys.hdes.client.spi.staticresources.StoreEntityLocation;
import io.resys.hdes.client.spi.util.HdesAssert;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class GitDataSourceLoader
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitDataSourceLoader.class);
    private final PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private final GitConfig conn;
    private final Repository repo;
    private final ObjectId start;
    private final StoreEntityLocation location;

    public GitDataSourceLoader(GitConfig conn) throws IOException {
        this.repo = conn.getClient().getRepository();
        this.conn = conn;
        this.start = this.repo.resolve("HEAD");
        this.location = conn.getLocation();
    }

    public List<GitConfig.GitEntry> read() {
        try {
            ((PullCommand)this.conn.getClient().pull().setTransportConfigCallback(this.conn.getCallback())).call();
        }
        catch (GitAPIException e) {
            LOGGER.error("Can't pull repository! " + System.lineSeparator() + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        List load = Arrays.asList(Map.entry(AstBody.AstBodyType.DT, this.location.getDtRegex()), Map.entry(AstBody.AstBodyType.FLOW_TASK, this.location.getFlowTaskRegex()), Map.entry(AstBody.AstBodyType.FLOW, this.location.getFlowRegex()), Map.entry(AstBody.AstBodyType.TAG, this.location.getTagRegex())).parallelStream().map(this::readFile).collect(Collectors.toList());
        GitFiles files = GitFiles.builder().git(this.conn).build();
        ArrayList result = new ArrayList();
        load.stream().forEach(loaded -> loaded.stream().map(file -> files.readEntry((GitConfig.GitFile)file, this.start)).forEach(result::add));
        return Collections.unmodifiableList(result);
    }

    private List<GitConfig.GitFile> readFile(Map.Entry<AstBody.AstBodyType, String> src) {
        AstBody.AstBodyType bodyType = src.getKey();
        String location = src.getValue();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading assets from: " + location + "!");
        }
        ArrayList<GitConfig.GitFile> files = new ArrayList<GitConfig.GitFile>();
        try {
            for (Resource resource : this.resolver.getResources("file:" + location)) {
                String content = this.getContent(resource);
                String fileName = resource.getFilename();
                String id = fileName.substring(0, fileName.indexOf("."));
                String treeValue = this.conn.getAssetsPath() + this.location.getFileName(bodyType, id);
                ImmutableGitFile gitFile = ImmutableGitFile.builder().id(id).treeValue(treeValue).blobValue(content).bodyType(bodyType).blobHash(Sha2.blob((String)content)).build();
                files.add(gitFile);
                HdesAssert.isTrue((boolean)resource.getFile().getAbsolutePath().endsWith(gitFile.getTreeValue()), () -> "Failed to create correct treeValue for: " + fileName);
            }
            return files;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load asset from: '" + location + "'!" + System.lineSeparator() + e.getMessage(), e);
        }
    }

    private String getContent(Resource entry) {
        try {
            return IOUtils.toString((InputStream)entry.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load asset content from: " + entry.getFilename() + "!" + e.getMessage(), e);
        }
    }

    @Override
    public void close() throws Exception {
    }
}

